/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.collection.multimap.MultiHashMapTreeSetBased;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsNavigableSet;
import com.helger.commons.locale.country.CountryCache;
import com.helger.masterdata.locale.EContinent;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ContinentHelper {
    private static final MultiHashMapTreeSetBased<Locale, EContinent> s_aMap = new MultiHashMapTreeSetBased();

    private ContinentHelper() {
    }

    private static void _register(@Nonnull @Nonempty String string, EContinent ... eContinentArray) {
        Locale locale = CountryCache.getInstance().getCountry(string);
        if (s_aMap.containsKey((Object)locale)) {
            throw new IllegalArgumentException("Country code '" + string + "' is already registered!");
        }
        for (EContinent eContinent : eContinentArray) {
            s_aMap.putSingle((Object)locale, (Object)eContinent);
        }
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsNavigableSet<EContinent> getContinentsOfCountry(@Nullable Locale locale) {
        ICommonsNavigableSet iCommonsNavigableSet;
        Locale locale2 = CountryCache.getInstance().getCountry(locale);
        if (locale2 != null && (iCommonsNavigableSet = (ICommonsNavigableSet)s_aMap.get((Object)locale2)) != null) {
            return iCommonsNavigableSet.getClone();
        }
        return null;
    }

    @Nullable
    @ReturnsMutableCopy
    public static ICommonsNavigableSet<EContinent> getContinentsOfCountry(@Nullable String string) {
        ICommonsNavigableSet iCommonsNavigableSet;
        Locale locale = CountryCache.getInstance().getCountry(string);
        if (locale != null && (iCommonsNavigableSet = (ICommonsNavigableSet)s_aMap.get((Object)locale)) != null) {
            return iCommonsNavigableSet.getClone();
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static final ICommonsMap<Locale, ICommonsNavigableSet<EContinent>> getAll() {
        return s_aMap.getClone();
    }

    static {
        ContinentHelper._register("AD", EContinent.EUROPE);
        ContinentHelper._register("AE", EContinent.ASIA);
        ContinentHelper._register("AF", EContinent.ASIA);
        ContinentHelper._register("AG", EContinent.NORTH_AMERICA);
        ContinentHelper._register("AI", EContinent.NORTH_AMERICA);
        ContinentHelper._register("AL", EContinent.EUROPE);
        ContinentHelper._register("AM", EContinent.ASIA);
        ContinentHelper._register("AN", EContinent.NORTH_AMERICA);
        ContinentHelper._register("AO", EContinent.AFRICA);
        ContinentHelper._register("AQ", EContinent.ANTARCTICA);
        ContinentHelper._register("AR", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("AS", EContinent.OCEANIA);
        ContinentHelper._register("AT", EContinent.EUROPE);
        ContinentHelper._register("AU", EContinent.OCEANIA);
        ContinentHelper._register("AW", EContinent.NORTH_AMERICA);
        ContinentHelper._register("AX", EContinent.EUROPE);
        ContinentHelper._register("AZ", EContinent.EUROPE, EContinent.ASIA);
        ContinentHelper._register("BA", EContinent.EUROPE);
        ContinentHelper._register("BB", EContinent.NORTH_AMERICA);
        ContinentHelper._register("BD", EContinent.ASIA);
        ContinentHelper._register("BE", EContinent.EUROPE);
        ContinentHelper._register("BF", EContinent.AFRICA);
        ContinentHelper._register("BG", EContinent.EUROPE);
        ContinentHelper._register("BH", EContinent.ASIA);
        ContinentHelper._register("BI", EContinent.AFRICA);
        ContinentHelper._register("BJ", EContinent.AFRICA);
        ContinentHelper._register("BL", EContinent.NORTH_AMERICA);
        ContinentHelper._register("BM", EContinent.NORTH_AMERICA);
        ContinentHelper._register("BN", EContinent.ASIA);
        ContinentHelper._register("BO", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("BQ", EContinent.NORTH_AMERICA);
        ContinentHelper._register("BR", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("BS", EContinent.NORTH_AMERICA);
        ContinentHelper._register("BT", EContinent.ASIA);
        ContinentHelper._register("BV", EContinent.UNDEFINED);
        ContinentHelper._register("BW", EContinent.AFRICA);
        ContinentHelper._register("BY", EContinent.EUROPE);
        ContinentHelper._register("BZ", EContinent.NORTH_AMERICA);
        ContinentHelper._register("CA", EContinent.NORTH_AMERICA);
        ContinentHelper._register("CC", EContinent.ASIA);
        ContinentHelper._register("CD", EContinent.AFRICA);
        ContinentHelper._register("CF", EContinent.AFRICA);
        ContinentHelper._register("CG", EContinent.AFRICA);
        ContinentHelper._register("CH", EContinent.EUROPE);
        ContinentHelper._register("CI", EContinent.AFRICA);
        ContinentHelper._register("CK", EContinent.OCEANIA);
        ContinentHelper._register("CL", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("CM", EContinent.AFRICA);
        ContinentHelper._register("CN", EContinent.ASIA);
        ContinentHelper._register("CO", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("CR", EContinent.NORTH_AMERICA);
        ContinentHelper._register("CS", EContinent.EUROPE);
        ContinentHelper._register("CU", EContinent.NORTH_AMERICA);
        ContinentHelper._register("CV", EContinent.AFRICA);
        ContinentHelper._register("CW", EContinent.NORTH_AMERICA);
        ContinentHelper._register("CX", EContinent.ASIA);
        ContinentHelper._register("CY", EContinent.ASIA, EContinent.EUROPE);
        ContinentHelper._register("CZ", EContinent.EUROPE);
        ContinentHelper._register("DE", EContinent.EUROPE);
        ContinentHelper._register("DJ", EContinent.AFRICA);
        ContinentHelper._register("DK", EContinent.EUROPE);
        ContinentHelper._register("DM", EContinent.NORTH_AMERICA);
        ContinentHelper._register("DO", EContinent.NORTH_AMERICA);
        ContinentHelper._register("DZ", EContinent.AFRICA);
        ContinentHelper._register("EC", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("EE", EContinent.EUROPE);
        ContinentHelper._register("EG", EContinent.AFRICA);
        ContinentHelper._register("EH", EContinent.AFRICA);
        ContinentHelper._register("ER", EContinent.AFRICA);
        ContinentHelper._register("ES", EContinent.EUROPE);
        ContinentHelper._register("ET", EContinent.AFRICA);
        ContinentHelper._register("FI", EContinent.EUROPE);
        ContinentHelper._register("FJ", EContinent.OCEANIA);
        ContinentHelper._register("FK", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("FM", EContinent.OCEANIA);
        ContinentHelper._register("FO", EContinent.EUROPE);
        ContinentHelper._register("FR", EContinent.EUROPE);
        ContinentHelper._register("GA", EContinent.AFRICA);
        ContinentHelper._register("GB", EContinent.EUROPE);
        ContinentHelper._register("GD", EContinent.NORTH_AMERICA);
        ContinentHelper._register("GE", EContinent.ASIA);
        ContinentHelper._register("GF", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("GG", EContinent.EUROPE);
        ContinentHelper._register("GH", EContinent.AFRICA);
        ContinentHelper._register("GI", EContinent.EUROPE);
        ContinentHelper._register("GL", EContinent.NORTH_AMERICA);
        ContinentHelper._register("GM", EContinent.AFRICA);
        ContinentHelper._register("GN", EContinent.AFRICA);
        ContinentHelper._register("GP", EContinent.NORTH_AMERICA);
        ContinentHelper._register("GQ", EContinent.AFRICA);
        ContinentHelper._register("GR", EContinent.EUROPE);
        ContinentHelper._register("GS", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("GT", EContinent.NORTH_AMERICA);
        ContinentHelper._register("GU", EContinent.OCEANIA);
        ContinentHelper._register("GW", EContinent.AFRICA);
        ContinentHelper._register("GY", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("HK", EContinent.ASIA);
        ContinentHelper._register("HM", EContinent.OCEANIA);
        ContinentHelper._register("HN", EContinent.NORTH_AMERICA);
        ContinentHelper._register("HR", EContinent.EUROPE);
        ContinentHelper._register("HT", EContinent.NORTH_AMERICA);
        ContinentHelper._register("HU", EContinent.EUROPE);
        ContinentHelper._register("ID", EContinent.ASIA);
        ContinentHelper._register("IE", EContinent.EUROPE);
        ContinentHelper._register("IL", EContinent.ASIA);
        ContinentHelper._register("IM", EContinent.EUROPE);
        ContinentHelper._register("IN", EContinent.ASIA);
        ContinentHelper._register("IO", EContinent.ASIA);
        ContinentHelper._register("IQ", EContinent.ASIA);
        ContinentHelper._register("IR", EContinent.ASIA);
        ContinentHelper._register("IS", EContinent.EUROPE);
        ContinentHelper._register("IT", EContinent.EUROPE);
        ContinentHelper._register("JE", EContinent.EUROPE);
        ContinentHelper._register("JM", EContinent.NORTH_AMERICA);
        ContinentHelper._register("JO", EContinent.ASIA);
        ContinentHelper._register("JP", EContinent.ASIA);
        ContinentHelper._register("KE", EContinent.AFRICA);
        ContinentHelper._register("KG", EContinent.ASIA);
        ContinentHelper._register("KH", EContinent.ASIA);
        ContinentHelper._register("KI", EContinent.OCEANIA);
        ContinentHelper._register("KM", EContinent.AFRICA);
        ContinentHelper._register("KN", EContinent.NORTH_AMERICA);
        ContinentHelper._register("KP", EContinent.ASIA);
        ContinentHelper._register("KR", EContinent.ASIA);
        ContinentHelper._register("KW", EContinent.ASIA);
        ContinentHelper._register("KY", EContinent.NORTH_AMERICA);
        ContinentHelper._register("KZ", EContinent.ASIA, EContinent.EUROPE);
        ContinentHelper._register("LA", EContinent.ASIA);
        ContinentHelper._register("LB", EContinent.ASIA);
        ContinentHelper._register("LC", EContinent.NORTH_AMERICA);
        ContinentHelper._register("LI", EContinent.EUROPE);
        ContinentHelper._register("LK", EContinent.ASIA);
        ContinentHelper._register("LR", EContinent.AFRICA);
        ContinentHelper._register("LS", EContinent.AFRICA);
        ContinentHelper._register("LT", EContinent.EUROPE);
        ContinentHelper._register("LU", EContinent.EUROPE);
        ContinentHelper._register("LV", EContinent.EUROPE);
        ContinentHelper._register("LY", EContinent.AFRICA);
        ContinentHelper._register("MA", EContinent.AFRICA);
        ContinentHelper._register("MC", EContinent.EUROPE);
        ContinentHelper._register("MD", EContinent.EUROPE);
        ContinentHelper._register("ME", EContinent.EUROPE);
        ContinentHelper._register("MF", EContinent.NORTH_AMERICA);
        ContinentHelper._register("MG", EContinent.AFRICA);
        ContinentHelper._register("MH", EContinent.OCEANIA);
        ContinentHelper._register("MK", EContinent.EUROPE);
        ContinentHelper._register("ML", EContinent.AFRICA);
        ContinentHelper._register("MM", EContinent.ASIA);
        ContinentHelper._register("MN", EContinent.ASIA);
        ContinentHelper._register("MO", EContinent.ASIA);
        ContinentHelper._register("MP", EContinent.OCEANIA);
        ContinentHelper._register("MQ", EContinent.NORTH_AMERICA);
        ContinentHelper._register("MR", EContinent.AFRICA);
        ContinentHelper._register("MS", EContinent.NORTH_AMERICA);
        ContinentHelper._register("MT", EContinent.EUROPE);
        ContinentHelper._register("MU", EContinent.AFRICA);
        ContinentHelper._register("MV", EContinent.ASIA);
        ContinentHelper._register("MW", EContinent.AFRICA);
        ContinentHelper._register("MX", EContinent.NORTH_AMERICA);
        ContinentHelper._register("MY", EContinent.ASIA);
        ContinentHelper._register("MZ", EContinent.AFRICA);
        ContinentHelper._register("NA", EContinent.AFRICA);
        ContinentHelper._register("NC", EContinent.OCEANIA);
        ContinentHelper._register("NE", EContinent.AFRICA);
        ContinentHelper._register("NF", EContinent.OCEANIA);
        ContinentHelper._register("NG", EContinent.AFRICA);
        ContinentHelper._register("NI", EContinent.NORTH_AMERICA);
        ContinentHelper._register("NL", EContinent.EUROPE);
        ContinentHelper._register("NO", EContinent.EUROPE);
        ContinentHelper._register("NP", EContinent.ASIA);
        ContinentHelper._register("NR", EContinent.OCEANIA);
        ContinentHelper._register("NU", EContinent.OCEANIA);
        ContinentHelper._register("NZ", EContinent.OCEANIA);
        ContinentHelper._register("OM", EContinent.ASIA);
        ContinentHelper._register("PA", EContinent.NORTH_AMERICA);
        ContinentHelper._register("PE", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("PF", EContinent.OCEANIA);
        ContinentHelper._register("PG", EContinent.OCEANIA);
        ContinentHelper._register("PH", EContinent.ASIA);
        ContinentHelper._register("PK", EContinent.ASIA);
        ContinentHelper._register("PL", EContinent.EUROPE);
        ContinentHelper._register("PM", EContinent.NORTH_AMERICA);
        ContinentHelper._register("PN", EContinent.OCEANIA);
        ContinentHelper._register("PR", EContinent.NORTH_AMERICA);
        ContinentHelper._register("PS", EContinent.ASIA);
        ContinentHelper._register("PT", EContinent.EUROPE);
        ContinentHelper._register("PW", EContinent.OCEANIA);
        ContinentHelper._register("PY", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("QA", EContinent.ASIA);
        ContinentHelper._register("RE", EContinent.AFRICA);
        ContinentHelper._register("RO", EContinent.EUROPE);
        ContinentHelper._register("RS", EContinent.EUROPE);
        ContinentHelper._register("RU", EContinent.EUROPE, EContinent.ASIA);
        ContinentHelper._register("RW", EContinent.AFRICA);
        ContinentHelper._register("SA", EContinent.ASIA);
        ContinentHelper._register("SB", EContinent.OCEANIA);
        ContinentHelper._register("SC", EContinent.AFRICA);
        ContinentHelper._register("SD", EContinent.AFRICA);
        ContinentHelper._register("SE", EContinent.EUROPE);
        ContinentHelper._register("SG", EContinent.ASIA);
        ContinentHelper._register("SH", EContinent.UNDEFINED);
        ContinentHelper._register("SI", EContinent.EUROPE);
        ContinentHelper._register("SJ", EContinent.UNDEFINED);
        ContinentHelper._register("SK", EContinent.EUROPE);
        ContinentHelper._register("SL", EContinent.AFRICA);
        ContinentHelper._register("SM", EContinent.EUROPE);
        ContinentHelper._register("SN", EContinent.AFRICA);
        ContinentHelper._register("SO", EContinent.AFRICA);
        ContinentHelper._register("SR", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("ST", EContinent.AFRICA);
        ContinentHelper._register("SV", EContinent.NORTH_AMERICA);
        ContinentHelper._register("SX", EContinent.NORTH_AMERICA);
        ContinentHelper._register("SY", EContinent.ASIA);
        ContinentHelper._register("SZ", EContinent.AFRICA);
        ContinentHelper._register("TC", EContinent.NORTH_AMERICA);
        ContinentHelper._register("TD", EContinent.AFRICA);
        ContinentHelper._register("TF", EContinent.AFRICA);
        ContinentHelper._register("TG", EContinent.AFRICA);
        ContinentHelper._register("TH", EContinent.ASIA);
        ContinentHelper._register("TJ", EContinent.ASIA);
        ContinentHelper._register("TK", EContinent.OCEANIA);
        ContinentHelper._register("TL", EContinent.ASIA);
        ContinentHelper._register("TM", EContinent.ASIA);
        ContinentHelper._register("TN", EContinent.AFRICA);
        ContinentHelper._register("TO", EContinent.OCEANIA);
        ContinentHelper._register("TR", EContinent.EUROPE, EContinent.ASIA);
        ContinentHelper._register("TT", EContinent.NORTH_AMERICA);
        ContinentHelper._register("TV", EContinent.OCEANIA);
        ContinentHelper._register("TW", EContinent.ASIA);
        ContinentHelper._register("TZ", EContinent.AFRICA);
        ContinentHelper._register("UA", EContinent.EUROPE);
        ContinentHelper._register("UG", EContinent.AFRICA);
        ContinentHelper._register("UM", EContinent.OCEANIA);
        ContinentHelper._register("US", EContinent.NORTH_AMERICA);
        ContinentHelper._register("UY", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("UZ", EContinent.ASIA);
        ContinentHelper._register("VA", EContinent.EUROPE);
        ContinentHelper._register("VC", EContinent.NORTH_AMERICA);
        ContinentHelper._register("VE", EContinent.SOUTH_AMERICA);
        ContinentHelper._register("VG", EContinent.NORTH_AMERICA);
        ContinentHelper._register("VI", EContinent.NORTH_AMERICA);
        ContinentHelper._register("VN", EContinent.ASIA);
        ContinentHelper._register("VU", EContinent.OCEANIA);
        ContinentHelper._register("WF", EContinent.OCEANIA);
        ContinentHelper._register("WS", EContinent.OCEANIA);
        ContinentHelper._register("YE", EContinent.ASIA);
        ContinentHelper._register("YT", EContinent.AFRICA);
        ContinentHelper._register("ZA", EContinent.AFRICA);
        ContinentHelper._register("ZM", EContinent.AFRICA);
        ContinentHelper._register("ZW", EContinent.AFRICA);
    }
}

