/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecatedLocaleHandler
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeprecatedLocaleHandler.class);
    private final ICommonsSet<Locale> m_aLocales = new CommonsHashSet();
    private final ICommonsSet<LocaleParts> m_aLocaleParts = new CommonsHashSet();

    public void initFromXML(@Nonnull IMicroDocument iMicroDocument) {
        ValueEnforcer.notNull((Object)iMicroDocument, (String)"Doc");
        ValueEnforcer.notNull((Object)iMicroDocument.getDocumentElement(), (String)"Doc.DocumentElement");
        this.m_aLocales.clear();
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("locale")) {
            String string = iMicroElement.getAttributeValue("language");
            String string2 = iMicroElement.getAttributeValue("country");
            String string3 = iMicroElement.getAttributeValue("variant");
            Locale locale = LocaleCache.getInstance().getLocale(string, string2, string3);
            if (locale == null) {
                LOGGER.warn("Deprecated locale could not be resolved!");
                continue;
            }
            this.m_aLocales.add((Object)locale);
            this.m_aLocaleParts.add((Object)new LocaleParts(string, string2, string3));
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<Locale> getAllDeprecatedLocales() {
        return (ICommonsSet)this.m_aLocales.getClone();
    }

    public boolean isDeprecatedLocale(@Nullable Locale locale) {
        return this.m_aLocales.contains((Object)locale);
    }

    public boolean isDeprecatedLocaleWithFallback(@Nullable Locale locale) {
        if (locale != null) {
            if (this.m_aLocales.contains((Object)locale)) {
                return true;
            }
            for (LocaleParts localeParts : this.m_aLocaleParts) {
                if (!localeParts.matchesLocale(locale)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("locales", this.m_aLocales).getToString();
    }

    @Nonnull
    public static DeprecatedLocaleHandler readFromXML(@Nonnull IHasInputStream iHasInputStream) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        return DeprecatedLocaleHandler.readFromXML(iHasInputStream.getInputStream());
    }

    @Nonnull
    public static DeprecatedLocaleHandler readFromXML(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((InputStream)inputStream);
        DeprecatedLocaleHandler deprecatedLocaleHandler = new DeprecatedLocaleHandler();
        deprecatedLocaleHandler.initFromXML(iMicroDocument);
        return deprecatedLocaleHandler;
    }

    @Nonnull
    public static DeprecatedLocaleHandler getDefaultInstance() {
        return SingletonHolder.s_aInstance;
    }

    @Immutable
    private static final class LocaleParts
    implements Serializable {
        private final String m_sLanguage;
        private final String m_sCountry;
        private final String m_sVariant;

        public LocaleParts(@Nullable String string, @Nullable String string2, @Nullable String string3) {
            this.m_sLanguage = string;
            this.m_sCountry = string2;
            this.m_sVariant = string3;
        }

        public boolean matchesLocale(@Nonnull Locale locale) {
            boolean bl = this.m_sLanguage == null || this.m_sLanguage.equals(locale.getLanguage());
            boolean bl2 = this.m_sCountry == null || this.m_sCountry.equals(locale.getCountry());
            boolean bl3 = this.m_sVariant == null || this.m_sVariant.equals(locale.getVariant());
            return bl && bl2 && bl3;
        }
    }

    private static final class SingletonHolder {
        static final DeprecatedLocaleHandler s_aInstance = DeprecatedLocaleHandler.readFromXML((IHasInputStream)new ClassPathResource("codelists/locale-deprecated.xml"));

        private SingletonHolder() {
        }
    }
}

