/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.locale;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.locale.ISO639_2Item;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ISO639_2Handler
implements Serializable {
    public static final String DEFAULT_RESOURCE = "codelists/iso639-2-data-20130111.xml";
    private final ICommonsMap<String, ISO639_2Item> m_aAlpha3B = new CommonsHashMap();
    private final ICommonsMap<String, ISO639_2Item> m_aAlpha3T = new CommonsHashMap();
    private final ICommonsMap<String, ISO639_2Item> m_aAlpha2 = new CommonsHashMap();

    @Nonnull
    public static ISO639_2Handler getDefaultInstance() {
        return SingletonHolder.s_aInstance;
    }

    @Nullable
    private static String _unifyKey(@Nullable String string) {
        return string == null ? null : string.toLowerCase(Locale.US);
    }

    @Nonnull
    public ISO639_2Handler readFromResource(@Nonnull IReadableResource iReadableResource) {
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("item")) {
            String string = iMicroElement.getAttributeValue("alpha3");
            String string2 = iMicroElement.getAttributeValue("alpha3t");
            String string3 = iMicroElement.getAttributeValue("alpha2");
            String string4 = iMicroElement.getAttributeValue("en");
            String string5 = iMicroElement.getAttributeValue("fr");
            ISO639_2Item iSO639_2Item = new ISO639_2Item(string, string2, string3, string4, string5);
            this.registerItem(iSO639_2Item);
        }
        return this;
    }

    public void registerItem(@Nonnull ISO639_2Item iSO639_2Item) {
        String string;
        ValueEnforcer.notNull((Object)iSO639_2Item, (String)"Item");
        this.m_aAlpha3B.put((Object)ISO639_2Handler._unifyKey(iSO639_2Item.getAlpha3Bibliographic()), (Object)iSO639_2Item);
        String string2 = ISO639_2Handler._unifyKey(iSO639_2Item.getAlpha3Terminologic());
        if (string2 != null) {
            this.m_aAlpha3T.put((Object)string2, (Object)iSO639_2Item);
        }
        if ((string = ISO639_2Handler._unifyKey(iSO639_2Item.getAlpha2())) != null) {
            this.m_aAlpha2.put((Object)string, (Object)iSO639_2Item);
        }
    }

    @Nullable
    public ISO639_2Item getItemOfAlpha3Code(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return (ISO639_2Item)this.m_aAlpha3B.get((Object)ISO639_2Handler._unifyKey(string));
    }

    @Nullable
    public ISO639_2Item getItemOfAlpha3TerminologicCode(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return (ISO639_2Item)this.m_aAlpha3T.get((Object)ISO639_2Handler._unifyKey(string));
    }

    @Nullable
    public ISO639_2Item getItemOfAlpha2Code(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return (ISO639_2Item)this.m_aAlpha2.get((Object)ISO639_2Handler._unifyKey(string));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("alpha3Bibliographic", this.m_aAlpha3B).append("alpha3Terminologic", this.m_aAlpha3T).append("alpha2", this.m_aAlpha2).getToString();
    }

    private static final class SingletonHolder {
        static final ISO639_2Handler s_aInstance = new ISO639_2Handler().readFromResource((IReadableResource)new ClassPathResource("codelists/iso639-2-data-20130111.xml"));

        private SingletonHolder() {
        }
    }
}

