/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.postal;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.MasterDataLogger;
import com.helger.masterdata.postal.EPostalCodeFormatElement;
import com.helger.masterdata.postal.PostalCodeCountry;
import com.helger.masterdata.postal.PostalCodeFormat;
import com.helger.masterdata.postal.PostalCodeManager;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class PostalCodeListReader {
    public static final String ELEMENT_ROOT = "root";
    public static final String ELEMENT_HEADER = "header";
    public static final String ELEMENT_SOURCE = "source";
    public static final String ELEMENT_REVISION = "revision";
    public static final String ELEMENT_BODY = "body";
    public static final String ELEMENT_COUNTRY = "country";
    public static final String ATTR_ISO = "iso";
    public static final String ATTR_NAME = "name";
    public static final String ELEMENT_POSTALCODES = "postalcodes";
    public static final String ATTR_VALIDFROM = "validfrom";
    public static final String ATTR_VALIDTO = "validto";
    public static final String ELEMENT_SPECIFIC = "specific";
    public static final String ELEMENT_FORMAT = "format";
    public static final String ELEMENT_NOTE = "note";
    private final PostalCodeManager m_aMgr;

    public PostalCodeListReader(@Nonnull PostalCodeManager postalCodeManager) {
        this.m_aMgr = (PostalCodeManager)ValueEnforcer.notNull((Object)postalCodeManager, (String)"Mgr");
    }

    @Nonnull
    @ReturnsMutableCopy
    private static ICommonsList<EPostalCodeFormatElement> _parseFormat(String string) {
        EPostalCodeFormatElement ePostalCodeFormatElement;
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (int i = 0; i < string.length(); i += ePostalCodeFormatElement.getTokenLength()) {
            ePostalCodeFormatElement = EPostalCodeFormatElement.getFromString(string, i);
            if (ePostalCodeFormatElement == null) {
                throw new IllegalArgumentException("The format '" + string + "' contains an illegal element at index " + i);
            }
            commonsArrayList.add((Object)ePostalCodeFormatElement);
        }
        return commonsArrayList;
    }

    public void readFromFile(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Passed resource is not an XML file: " + iReadableResource);
        }
        IMicroElement iMicroElement = iMicroDocument.getDocumentElement().getFirstChildElement(ELEMENT_BODY);
        if (iMicroElement == null) {
            throw new IllegalArgumentException("Missing body element in file " + iReadableResource);
        }
        LocalDate localDate = PDTFactory.getCurrentLocalDate();
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(ELEMENT_COUNTRY)) {
            String string = iMicroElement2.getAttributeValue(ATTR_NAME);
            String string2 = iMicroElement2.getAttributeValue(ATTR_ISO);
            PostalCodeCountry postalCodeCountry = new PostalCodeCountry(string2);
            for (IMicroElement iMicroElement3 : iMicroElement2.getAllChildElements(ELEMENT_POSTALCODES)) {
                LocalDate localDate2;
                String string3 = iMicroElement3.getAttributeValue(ATTR_VALIDFROM);
                LocalDate localDate3 = string3 == null ? null : DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)string3, LocalDate::from);
                String string4 = iMicroElement3.getAttributeValue(ATTR_VALIDTO);
                LocalDate localDate4 = localDate2 = string4 == null ? null : DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)string4, LocalDate::from);
                if (localDate3 != null && localDate3.isAfter(localDate)) {
                    MasterDataLogger.getInstance().info((Serializable)((Object)("Ignoring some postal code definitions of " + string + " because they are valid from " + localDate3.toString())));
                    continue;
                }
                if (localDate2 != null && localDate2.isBefore(localDate)) {
                    MasterDataLogger.getInstance().info((Serializable)((Object)("Ignoring some postal code definitions of " + string + " because they are valid until " + localDate2.toString())));
                    continue;
                }
                for (IMicroElement iMicroElement4 : iMicroElement3.getAllChildElements(ELEMENT_FORMAT)) {
                    String string5 = iMicroElement4.getTextContent();
                    if (StringHelper.hasNoText((String)string5)) {
                        throw new IllegalArgumentException("The country " + string2 + " contains an empty postal code format!");
                    }
                    ICommonsList<EPostalCodeFormatElement> iCommonsList = PostalCodeListReader._parseFormat(string5);
                    if (iCommonsList.isEmpty()) {
                        throw new IllegalStateException("The country " + string2 + " contains an invalid format '" + string5 + "'");
                    }
                    postalCodeCountry.addFormat(new PostalCodeFormat(string2, (List<EPostalCodeFormatElement>)iCommonsList));
                }
                for (IMicroElement iMicroElement4 : iMicroElement3.getAllChildElements(ELEMENT_SPECIFIC)) {
                    postalCodeCountry.addSpecificPostalCode(iMicroElement4.getTextContent());
                }
                Iterator iterator = iMicroElement3.getFirstChildElement(ELEMENT_NOTE);
                if (iterator == null) continue;
                postalCodeCountry.setNote(iterator.getTextContent());
            }
            if (postalCodeCountry.getFormatCount() == 0 && postalCodeCountry.getSpecificPostalCodeCount() == 0) {
                throw new IllegalStateException("Country " + string2 + " has no formats defined!");
            }
            this.m_aMgr.addCountry(postalCodeCountry);
        }
    }
}

