/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.price;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currency.PerCurrencySettings;
import com.helger.masterdata.currencyvalue.CurrencyValue;
import com.helger.masterdata.currencyvalue.ICurrencyValue;
import com.helger.masterdata.price.IMutablePrice;
import com.helger.masterdata.price.IPrice;
import com.helger.masterdata.vat.IVATItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class Price
implements IMutablePrice {
    public static final String FIELD_VATITEM = "vatitem";
    private CurrencyValue m_aNetAmount;
    private IVATItem m_aVATItem;

    public Price() {
    }

    public Price(@Nonnull IPrice iPrice) {
        this(iPrice.getNetAmount(), iPrice.getVATItem());
    }

    public Price(@Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnull IVATItem iVATItem) {
        this(new CurrencyValue(eCurrency, bigDecimal), iVATItem);
    }

    public Price(@Nonnull ICurrencyValue iCurrencyValue, @Nonnull IVATItem iVATItem) {
        this.setNetAmount(iCurrencyValue);
        this.setVATItem(iVATItem);
    }

    @Override
    @Nonnull
    public final CurrencyValue getNetAmount() {
        return this.m_aNetAmount;
    }

    @Override
    @Nonnull
    public final EChange setNetAmount(@Nonnull ICurrencyValue iCurrencyValue) {
        ValueEnforcer.notNull((Object)iCurrencyValue, (String)"NetAmount");
        CurrencyValue currencyValue = new CurrencyValue(iCurrencyValue);
        if (EqualsHelper.equals((Object)this.m_aNetAmount, (Object)currencyValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aNetAmount = currencyValue;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final IVATItem getVATItem() {
        return this.m_aVATItem;
    }

    @Override
    @Nonnull
    public final EChange setVATItem(@Nonnull IVATItem iVATItem) {
        ValueEnforcer.notNull((Object)iVATItem, (String)"VATItem");
        if (iVATItem.equals(this.m_aVATItem)) {
            return EChange.UNCHANGED;
        }
        this.m_aVATItem = iVATItem;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final ECurrency getCurrency() {
        return this.m_aNetAmount.getCurrency();
    }

    @Override
    @Nonnull
    public final EChange setCurrency(@Nonnull ECurrency eCurrency) {
        return this.m_aNetAmount.setCurrency(eCurrency);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getAdded(@Nonnull BigDecimal bigDecimal) {
        return new Price(this.m_aNetAmount.getAdded(bigDecimal), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getAdded(long l) {
        return new Price(this.m_aNetAmount.getAdded(l), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getSubtracted(@Nonnull BigDecimal bigDecimal) {
        return new Price(this.m_aNetAmount.getSubtracted(bigDecimal), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getSubtracted(long l) {
        return new Price(this.m_aNetAmount.getSubtracted(l), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getMultiplied(@Nonnull BigDecimal bigDecimal) {
        return new Price(this.m_aNetAmount.getMultiplied(bigDecimal), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getMultiplied(long l) {
        return new Price(this.m_aNetAmount.getMultiplied(l), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getDivided(@Nonnull BigDecimal bigDecimal) {
        return new Price(this.m_aNetAmount.getDivided(bigDecimal), this.m_aVATItem);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Price getDivided(long l) {
        return new Price(this.m_aNetAmount.getDivided(l), this.m_aVATItem);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Price price = (Price)object;
        return this.m_aNetAmount.equals(price.m_aNetAmount) && this.m_aVATItem.equals(price.m_aVATItem);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aNetAmount).append((Object)this.m_aVATItem).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("NetAmount", (Object)this.m_aNetAmount).append("VATItem", (Object)this.m_aVATItem).getToString();
    }

    @Nonnull
    public static Price createFromNetAmount(@Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnull IVATItem iVATItem) {
        return new Price(eCurrency, bigDecimal, iVATItem);
    }

    @Nonnull
    public static Price createFromNetAmount(@Nonnull ICurrencyValue iCurrencyValue, @Nonnull IVATItem iVATItem) {
        return new Price(iCurrencyValue, iVATItem);
    }

    @Nonnull
    public static Price createFromGrossAmount(@Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnull IVATItem iVATItem) {
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        return Price.createFromGrossAmount(eCurrency, bigDecimal, iVATItem, perCurrencySettings.getScale(), perCurrencySettings.getRoundingMode());
    }

    @Nonnull
    public static Price createFromGrossAmount(@Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal, @Nonnull IVATItem iVATItem, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        ValueEnforcer.notNull((Object)iVATItem, (String)"VATItem");
        BigDecimal bigDecimal2 = iVATItem.getMultiplicationFactorNetToGross();
        if (MathHelper.isEQ1((BigDecimal)bigDecimal2)) {
            return new Price(eCurrency, bigDecimal, iVATItem);
        }
        return new Price(eCurrency, bigDecimal.divide(bigDecimal2, n, roundingMode), iVATItem);
    }

    @Nonnull
    public static Price createFromGrossAmount(@Nonnull ICurrencyValue iCurrencyValue, @Nonnull IVATItem iVATItem) {
        ValueEnforcer.notNull((Object)iCurrencyValue, (String)"GrossAmount");
        ECurrency eCurrency = iCurrencyValue.getCurrency();
        PerCurrencySettings perCurrencySettings = CurrencyHelper.getSettings(eCurrency);
        return Price.createFromGrossAmount(iCurrencyValue, iVATItem, perCurrencySettings.getScale(), perCurrencySettings.getRoundingMode());
    }

    @Nonnull
    public static Price createFromGrossAmount(@Nonnull ICurrencyValue iCurrencyValue, @Nonnull IVATItem iVATItem, @Nonnegative int n, @Nonnull RoundingMode roundingMode) {
        ValueEnforcer.notNull((Object)iVATItem, (String)"VATItem");
        BigDecimal bigDecimal = iVATItem.getMultiplicationFactorNetToGross();
        if (MathHelper.isEQ1((BigDecimal)bigDecimal)) {
            return new Price(iCurrencyValue, iVATItem);
        }
        return new Price(iCurrencyValue.getCurrency(), iCurrencyValue.getValue().divide(bigDecimal, n, roundingMode), iVATItem);
    }
}

