/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.price;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.price.IMutablePriceGraduationItem;
import java.math.BigDecimal;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class PriceGraduationItem
implements IMutablePriceGraduationItem {
    private int m_nMinimumQuantity;
    private BigDecimal m_aNetAmount;

    public PriceGraduationItem(@Nonnegative int n, @Nonnull BigDecimal bigDecimal) {
        this.setMinimumQuantity(n);
        this.setUnitNetAmount(bigDecimal);
    }

    @Override
    @Nonnegative
    public final int getMinimumQuantity() {
        return this.m_nMinimumQuantity;
    }

    @Override
    @Nonnull
    public final EChange setMinimumQuantity(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"MinimumQuantity");
        if (n == this.m_nMinimumQuantity) {
            return EChange.UNCHANGED;
        }
        this.m_nMinimumQuantity = n;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public final BigDecimal getUnitNetAmount() {
        return this.m_aNetAmount;
    }

    @Override
    @Nonnull
    public final EChange setUnitNetAmount(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"NetAmount");
        if (EqualsHelper.equals((Object)bigDecimal, (Object)this.m_aNetAmount)) {
            return EChange.UNCHANGED;
        }
        this.m_aNetAmount = bigDecimal;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PriceGraduationItem priceGraduationItem = (PriceGraduationItem)object;
        return this.m_nMinimumQuantity == priceGraduationItem.m_nMinimumQuantity && EqualsHelper.equals((Object)this.m_aNetAmount, (Object)priceGraduationItem.m_aNetAmount);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nMinimumQuantity).append((Object)this.m_aNetAmount).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("minQuantity", this.m_nMinimumQuantity).append("priceamount", (Object)this.m_aNetAmount).getToString();
    }
}

