/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.telephone;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.telephone.ITelephoneNumber;
import com.helger.masterdata.telephone.ITelephoneType;
import com.helger.masterdata.telephone.TelephoneHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class TelephoneNumber
implements ITelephoneNumber,
ICloneable<TelephoneNumber> {
    private ITelephoneType m_aType;
    private String m_sCountryCode;
    private String m_sAreaCode;
    private String m_sLine;
    private String m_sDirectDial;

    public TelephoneNumber() {
    }

    public TelephoneNumber(@Nonnull ITelephoneNumber iTelephoneNumber) {
        ValueEnforcer.notNull((Object)iTelephoneNumber, (String)"Base");
        this.setType(iTelephoneNumber.getType());
        this.setCountryCode(iTelephoneNumber.getCountryCode());
        this.setAreaCode(iTelephoneNumber.getAreaCode());
        this.setLine(iTelephoneNumber.getLine());
        this.setDirectDial(iTelephoneNumber.getDirectDial());
    }

    public TelephoneNumber(@Nullable ITelephoneType iTelephoneType) {
        this.setType(iTelephoneType);
    }

    public TelephoneNumber(@Nullable ITelephoneType iTelephoneType, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4) {
        this.setType(iTelephoneType);
        this.setCountryCode(string);
        this.setAreaCode(string2);
        this.setLine(string3);
        this.setDirectDial(string4);
    }

    @Override
    @Nullable
    public ITelephoneType getType() {
        return this.m_aType;
    }

    @Nonnull
    public EChange setType(@Nullable ITelephoneType iTelephoneType) {
        if (EqualsHelper.equals((Object)this.m_aType, (Object)iTelephoneType)) {
            return EChange.UNCHANGED;
        }
        this.m_aType = iTelephoneType;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCountryCode() {
        return this.m_sCountryCode;
    }

    @Nonnull
    public EChange setCountryCode(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals((Object)this.m_sCountryCode, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sCountryCode = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getAreaCode() {
        return this.m_sAreaCode;
    }

    @Nonnull
    public EChange setAreaCode(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals((Object)this.m_sAreaCode, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sAreaCode = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLine() {
        return this.m_sLine;
    }

    @Nonnull
    public EChange setLine(@Nullable String string) {
        String string2 = TelephoneHelper.getCleanedLine(string);
        if (EqualsHelper.equals((Object)this.m_sLine, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sLine = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getDirectDial() {
        return this.m_sDirectDial;
    }

    @Nonnull
    public EChange setDirectDial(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals((Object)this.m_sDirectDial, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sDirectDial = string2;
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public TelephoneNumber getClone() {
        return new TelephoneNumber(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TelephoneNumber telephoneNumber = (TelephoneNumber)object;
        return EqualsHelper.equals((Object)this.m_aType, (Object)telephoneNumber.m_aType) && EqualsHelper.equals((Object)this.m_sCountryCode, (Object)telephoneNumber.m_sCountryCode) && EqualsHelper.equals((Object)this.m_sAreaCode, (Object)telephoneNumber.m_sAreaCode) && EqualsHelper.equals((Object)this.m_sLine, (Object)telephoneNumber.m_sLine) && EqualsHelper.equals((Object)this.m_sDirectDial, (Object)telephoneNumber.m_sDirectDial);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aType).append((Object)this.m_sCountryCode).append((Object)this.m_sAreaCode).append((Object)this.m_sLine).append((Object)this.m_sDirectDial).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("type", (Object)this.m_aType).appendIfNotNull("countryCode", (Object)this.m_sCountryCode).appendIfNotNull("areaCode", (Object)this.m_sAreaCode).appendIfNotNull("line", (Object)this.m_sLine).appendIfNotNull("directDial", (Object)this.m_sDirectDial).getToString();
    }

    @Nullable
    public static TelephoneNumber createOnDemandLineOnly(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        TelephoneNumber telephoneNumber = new TelephoneNumber();
        telephoneNumber.setLine(string);
        return telephoneNumber;
    }
}

