/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.DevelopersNote;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.OverrideOnDemand;
import com.helger.commons.annotations.UsedViaReflection;
import com.helger.commons.exceptions.LoggedRuntimeException;
import com.helger.commons.scopes.IScope;
import com.helger.commons.scopes.singleton.GlobalSingleton;
import com.helger.schedule.quartz.QuartzSchedulerHelper;
import com.helger.schedule.quartz.listener.StatisticsJobListener;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.matchers.EverythingMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalQuartzScheduler
extends GlobalSingleton {
    public static final String GROUP_NAME = "com.helger";
    private static final Logger s_aLogger = LoggerFactory.getLogger(GlobalQuartzScheduler.class);
    private final Scheduler m_aScheduler = QuartzSchedulerHelper.getScheduler();
    private String m_sGroupName = "com.helger";

    @UsedViaReflection
    @DevelopersNote(value="Used from derived classes")
    public GlobalQuartzScheduler() {
        this.addJobListener(new StatisticsJobListener());
    }

    @Nonnull
    public static final GlobalQuartzScheduler getInstance() {
        return (GlobalQuartzScheduler)GlobalQuartzScheduler.getGlobalSingleton(GlobalQuartzScheduler.class);
    }

    @Nonnull
    @Nonempty
    public String getGroupName() {
        return this.m_sGroupName;
    }

    public void setGroupName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"GroupName");
        this.m_sGroupName = string;
    }

    public void addJobListener(@Nonnull JobListener jobListener) {
        ValueEnforcer.notNull((Object)jobListener, (String)"JobListener");
        try {
            this.m_aScheduler.getListenerManager().addJobListener(jobListener, (Matcher)EverythingMatcher.allJobs());
        }
        catch (SchedulerException schedulerException) {
            throw new IllegalStateException("Failed to add job listener " + jobListener, schedulerException);
        }
    }

    @Nonnull
    protected final Scheduler getScheduler() {
        return this.m_aScheduler;
    }

    @OverrideOnDemand
    protected void modifyJobDataMap(@Nonnull JobDataMap jobDataMap) {
    }

    public final void scheduleJob(@Nonnull String string, @Nonnull TriggerBuilder<? extends Trigger> triggerBuilder, @Nonnull Class<? extends Job> clazz, @Nullable Map<String, ? extends Object> map) {
        ValueEnforcer.notNull((Object)string, (String)"JobName");
        ValueEnforcer.notNull(triggerBuilder, (String)"TriggerBuilder");
        ValueEnforcer.notNull(clazz, (String)"JobClass");
        JobDetail jobDetail = JobBuilder.newJob(clazz).withIdentity(string, this.m_sGroupName).build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                jobDataMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        this.modifyJobDataMap(jobDataMap);
        try {
            Trigger trigger = triggerBuilder.build();
            this.m_aScheduler.scheduleJob(jobDetail, trigger);
            s_aLogger.info("Succesfully scheduled job '" + string + "' with trigger " + trigger);
        }
        catch (SchedulerException schedulerException) {
            throw LoggedRuntimeException.newException((Throwable)schedulerException);
        }
    }

    public void scheduleJobNowOnce(@Nonnull String string, @Nonnull Class<? extends Job> clazz, @Nullable Map<String, ? extends Object> map) {
        this.scheduleJob(string, (TriggerBuilder<? extends Trigger>)TriggerBuilder.newTrigger().startNow().withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMinutes(1).withRepeatCount(0)), clazz, map);
    }

    public final void shutdown() throws SchedulerException {
        try {
            this.m_aScheduler.shutdown(true);
            s_aLogger.info("Successfully shutdown GlobalQuartzScheduler");
        }
        catch (SchedulerException schedulerException) {
            s_aLogger.error("Failed to shutdown GlobalQuartzScheduler", (Throwable)schedulerException);
            throw schedulerException;
        }
    }

    protected final void onDestroy(@Nonnull IScope iScope) throws Exception {
        this.shutdown();
    }
}

