/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz.listener;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.lang.CGStringHelper;
import com.helger.commons.stats.StatisticsManager;
import javax.annotation.Nonnull;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public class StatisticsJobListener
implements JobListener {
    @Nonnull
    @Nonempty
    public String getName() {
        return "StatisticsJobListener";
    }

    @Nonnull
    @Nonempty
    protected String getStatisticsName(@Nonnull JobExecutionContext jobExecutionContext) {
        return "quartz." + CGStringHelper.getClassLocalName((Class)jobExecutionContext.getJobDetail().getJobClass());
    }

    public void jobToBeExecuted(@Nonnull JobExecutionContext jobExecutionContext) {
    }

    public void jobExecutionVetoed(@Nonnull JobExecutionContext jobExecutionContext) {
        StatisticsManager.getCounterHandler((String)(this.getStatisticsName(jobExecutionContext) + "$VETOED")).increment();
    }

    public void jobWasExecuted(@Nonnull JobExecutionContext jobExecutionContext, JobExecutionException jobExecutionException) {
        StatisticsManager.getCounterHandler((String)(this.getStatisticsName(jobExecutionContext) + "$EXEC")).increment();
        if (jobExecutionException != null) {
            StatisticsManager.getCounterHandler((String)(this.getStatisticsName(jobExecutionContext) + "$ERROR")).increment();
        }
    }
}

