/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport.format;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsImmutableObject;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.IJsonWriterSettings;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.photon.exchange.EExchangeFileType;
import com.helger.photon.exchange.bulkexport.IExportRecord;
import com.helger.photon.exchange.bulkexport.IExportRecordField;
import com.helger.photon.exchange.bulkexport.IExportRecordProvider;
import com.helger.photon.exchange.bulkexport.IExporterFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ExporterJSON
implements IExporterFile {
    public static final boolean DEFAULT_EMIT_TYPE = true;
    public static final String ELEMENT_HEADER = "header";
    public static final String ELEMENT_BODY = "body";
    public static final String ELEMENT_FOOTER = "footer";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VALUE = "value";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExporterJSON.class);
    private JsonWriterSettings m_aJWS = new JsonWriterSettings();
    private Charset m_aCharset = StandardCharsets.UTF_8;
    private boolean m_bEmitType = true;

    @Override
    @Nonnull
    public final EExchangeFileType getFileType() {
        return EExchangeFileType.XML;
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final ExporterJSON setCharset(@Nonnull Charset charset) {
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final JsonWriterSettings jsonWriterSettings() {
        return this.m_aJWS;
    }

    @Nonnull
    @ReturnsImmutableObject
    public final IJsonWriterSettings getJsonWriterSettings() {
        return this.m_aJWS;
    }

    @Nonnull
    public final ExporterJSON setJsonWriterSettings(@Nonnull JsonWriterSettings jsonWriterSettings) {
        this.m_aJWS = (JsonWriterSettings)ValueEnforcer.notNull((Object)jsonWriterSettings, (String)"JsonWriterSettings");
        return this;
    }

    public final boolean isEmitType() {
        return this.m_bEmitType;
    }

    @Nonnull
    public final ExporterJSON setEmitType(boolean bl) {
        this.m_bEmitType = bl;
        return this;
    }

    @Nonnull
    @Nonempty
    private IJsonArray _emitRecord(@Nonnull IExportRecord iExportRecord) {
        JsonArray jsonArray = new JsonArray();
        for (IExportRecordField iExportRecordField : iExportRecord.getAllFields()) {
            Object object = iExportRecordField.getFieldValue();
            if (this.m_bEmitType) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.add(ATTR_TYPE, (Object)iExportRecordField.getFieldType().getID());
                if (object != null) {
                    jsonObject.add(ATTR_VALUE, object);
                }
                jsonArray.add((Serializable)jsonObject);
                continue;
            }
            if (object == null) continue;
            jsonArray.add(object);
        }
        return jsonArray;
    }

    @Nullable
    public IJsonObject convertRecords(@Nonnull IExportRecordProvider iExportRecordProvider) {
        ValueEnforcer.notNull((Object)iExportRecordProvider, (String)"Provider");
        JsonObject jsonObject = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        iExportRecordProvider.forEachHeaderRecord(arg_0 -> this.lambda$convertRecords$0((IJsonArray)jsonArray, arg_0));
        if (jsonArray.isNotEmpty()) {
            jsonObject.addJson(ELEMENT_HEADER, (IJson)jsonArray);
        }
        JsonArray jsonArray2 = new JsonArray();
        iExportRecordProvider.forEachBodyRecord(arg_0 -> this.lambda$convertRecords$1((IJsonArray)jsonArray2, arg_0));
        if (jsonArray2.isNotEmpty()) {
            jsonObject.addJson(ELEMENT_BODY, (IJson)jsonArray2);
        }
        JsonArray jsonArray3 = new JsonArray();
        iExportRecordProvider.forEachFooterRecord(arg_0 -> this.lambda$convertRecords$2((IJsonArray)jsonArray3, arg_0));
        if (jsonArray3.isNotEmpty()) {
            jsonObject.addJson(ELEMENT_FOOTER, (IJson)jsonArray3);
        }
        if (jsonObject.isEmpty()) {
            return null;
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess exportRecords(@Nonnull IExportRecordProvider iExportRecordProvider, @Nonnull @WillClose OutputStream outputStream) {
        try {
            ValueEnforcer.notNull((Object)iExportRecordProvider, (String)"Provider");
            ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
            IJsonObject iJsonObject = this.convertRecords(iExportRecordProvider);
            if (iJsonObject == null) {
                ESuccess eSuccess = ESuccess.FAILURE;
                return eSuccess;
            }
            try (OutputStreamWriter outputStreamWriter = StreamHelper.createWriter((OutputStream)outputStream, (Charset)this.m_aCharset);){
                new JsonWriter((IJsonWriterSettings)this.m_aJWS).writeToWriter((IJson)iJsonObject, (Writer)outputStreamWriter);
            }
            outputStreamWriter = ESuccess.SUCCESS;
            return outputStreamWriter;
        }
        catch (IOException iOException) {
            if (!StreamHelper.isKnownEOFException((Throwable)iOException)) {
                LOGGER.error("Failed to write JSON to output stream " + outputStream, (Throwable)iOException);
            }
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    private /* synthetic */ void lambda$convertRecords$2(IJsonArray iJsonArray, IExportRecord iExportRecord) {
        IJsonArray cfr_ignored_0 = (IJsonArray)iJsonArray.add((Serializable)this._emitRecord(iExportRecord));
    }

    private /* synthetic */ void lambda$convertRecords$1(IJsonArray iJsonArray, IExportRecord iExportRecord) {
        IJsonArray cfr_ignored_0 = (IJsonArray)iJsonArray.add((Serializable)this._emitRecord(iExportRecord));
    }

    private /* synthetic */ void lambda$convertRecords$0(IJsonArray iJsonArray, IExportRecord iExportRecord) {
        IJsonArray cfr_ignored_0 = (IJsonArray)iJsonArray.add((Serializable)this._emitRecord(iExportRecord));
    }
}

