/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.exchange.bulkexport.EExportDataType;
import com.helger.photon.exchange.bulkexport.ExportRecordField;
import com.helger.photon.exchange.bulkexport.IExportRecord;
import com.helger.photon.exchange.bulkexport.IExportRecordField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ExportRecord
implements IExportRecord {
    private final ICommonsList<IExportRecordField> m_aFields = new CommonsArrayList();

    public ExportRecord() {
    }

    public ExportRecord(IExportRecordField ... iExportRecordFieldArray) {
        ValueEnforcer.notNull((Object)iExportRecordFieldArray, (String)"Fields");
        for (IExportRecordField iExportRecordField : iExportRecordFieldArray) {
            this.addField(iExportRecordField);
        }
    }

    public ExportRecord(@Nonnull Iterable<? extends IExportRecordField> iterable) {
        ValueEnforcer.notNull(iterable, (String)"Fields");
        for (IExportRecordField iExportRecordField : iterable) {
            this.addField(iExportRecordField);
        }
    }

    @Nonnull
    public EChange removeFieldAtIndex(@Nonnegative int n) {
        return this.m_aFields.removeAtIndex(n);
    }

    @Nonnull
    public ExportRecord addField(@Nonnull IExportRecordField iExportRecordField) {
        ValueEnforcer.notNull((Object)iExportRecordField, (String)"Field");
        this.m_aFields.add((Object)iExportRecordField);
        return this;
    }

    @Nonnull
    public ExportRecord addField(@Nullable Object object) {
        return this.addField(ExportRecordField.create(object));
    }

    @Nonnull
    public ExportRecord addField(@Nullable String string) {
        return this.addField(ExportRecordField.create(string));
    }

    @Nonnull
    public ExportRecord addField(@Nullable LocalDate localDate) {
        return this.addField(ExportRecordField.create(localDate));
    }

    @Nonnull
    public ExportRecord addField(@Nullable LocalTime localTime) {
        return this.addField(ExportRecordField.create(localTime));
    }

    @Nonnull
    public ExportRecord addField(@Nullable LocalDateTime localDateTime) {
        return this.addField(ExportRecordField.create(localDateTime));
    }

    @Nonnull
    public ExportRecord addField(@Nullable ZonedDateTime zonedDateTime) {
        return this.addField(ExportRecordField.create(zonedDateTime));
    }

    @Nonnull
    public ExportRecord addField(@Nullable OffsetDateTime offsetDateTime) {
        return this.addField(ExportRecordField.create(offsetDateTime));
    }

    @Nonnull
    public ExportRecord addField(boolean bl) {
        return this.addField(ExportRecordField.create(bl));
    }

    @Nonnull
    public ExportRecord addField(Boolean bl) {
        return this.addField(ExportRecordField.create(bl));
    }

    @Nonnull
    public ExportRecord addField(int n) {
        return this.addField(ExportRecordField.create(n));
    }

    @Nonnull
    public ExportRecord addField(@Nullable Integer n) {
        return this.addField(ExportRecordField.create(n));
    }

    @Nonnull
    public ExportRecord addField(long l) {
        return this.addField(ExportRecordField.create(l));
    }

    @Nonnull
    public ExportRecord addField(@Nullable Long l) {
        return this.addField(ExportRecordField.create(l));
    }

    @Nonnull
    public ExportRecord addField(@Nullable BigInteger bigInteger) {
        return this.addField(ExportRecordField.create(bigInteger));
    }

    @Nonnull
    public ExportRecord addField(double d) {
        return this.addField(ExportRecordField.create(d));
    }

    @Nonnull
    public ExportRecord addField(@Nullable Double d) {
        return this.addField(ExportRecordField.create(d));
    }

    @Nonnull
    public ExportRecord addField(@Nullable BigDecimal bigDecimal) {
        return this.addField(ExportRecordField.create(bigDecimal));
    }

    @Nonnull
    public ExportRecord addNullField() {
        return this.addField(new ExportRecordField(EExportDataType.TEXT, null));
    }

    @Nonnull
    public ExportRecord addNullFields(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Fields");
        for (int i = 0; i < n; ++i) {
            this.addNullField();
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IExportRecordField> getAllFields() {
        return (ICommonsList)this.m_aFields.getClone();
    }

    @Override
    public boolean hasFields() {
        return this.m_aFields.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getFieldCount() {
        return this.m_aFields.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExportRecord exportRecord = (ExportRecord)object;
        return this.m_aFields.equals(exportRecord.m_aFields);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aFields).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("fields", this.m_aFields).getToString();
    }
}

