/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.exchange.bulkexport.EExportDataType;
import com.helger.photon.exchange.bulkexport.IExportRecordField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExportRecordField
implements IExportRecordField {
    private final EExportDataType m_eFieldType;
    private final Object m_aValue;

    protected ExportRecordField(@Nonnull EExportDataType eExportDataType, @Nullable Object object) {
        this.m_eFieldType = (EExportDataType)((Object)ValueEnforcer.notNull((Object)((Object)eExportDataType), (String)"FieldType"));
        this.m_aValue = object;
    }

    @Override
    @Nonnull
    public EExportDataType getFieldType() {
        return this.m_eFieldType;
    }

    @Override
    @Nullable
    public Object getFieldValue() {
        return this.m_aValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExportRecordField exportRecordField = (ExportRecordField)object;
        return this.m_eFieldType.equals((Object)exportRecordField.m_eFieldType) && EqualsHelper.equals((Object)this.m_aValue, (Object)exportRecordField.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eFieldType).append(this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("fieldType", (Enum)this.m_eFieldType).append("value", this.m_aValue).getToString();
    }

    @Nonnull
    public static EExportDataType autoDetermineType(@Nullable Object object) {
        if (object != null) {
            if (object instanceof LocalDate) {
                return EExportDataType.DATE;
            }
            if (object instanceof LocalTime) {
                return EExportDataType.TIME;
            }
            if (object instanceof LocalDateTime || object instanceof ZonedDateTime || object instanceof OffsetDateTime) {
                return EExportDataType.DATETIME;
            }
            if (object instanceof Boolean) {
                return EExportDataType.BOOLEAN;
            }
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof BigInteger) {
                return EExportDataType.INT;
            }
            if (object instanceof Float || object instanceof Double || object instanceof BigDecimal) {
                return EExportDataType.DOUBLE;
            }
        }
        return EExportDataType.TEXT;
    }

    @Nonnull
    public static ExportRecordField create(@Nullable Object object) {
        return new ExportRecordField(ExportRecordField.autoDetermineType(object), object);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable String string) {
        return new ExportRecordField(EExportDataType.TEXT, string);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable LocalDate localDate) {
        return new ExportRecordField(EExportDataType.DATE, localDate);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable LocalTime localTime) {
        return new ExportRecordField(EExportDataType.TIME, localTime);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable LocalDateTime localDateTime) {
        return new ExportRecordField(EExportDataType.DATETIME, localDateTime);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable ZonedDateTime zonedDateTime) {
        return new ExportRecordField(EExportDataType.DATETIME, zonedDateTime);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable OffsetDateTime offsetDateTime) {
        return new ExportRecordField(EExportDataType.DATETIME, offsetDateTime);
    }

    @Nonnull
    public static ExportRecordField create(boolean bl) {
        return ExportRecordField.create((Boolean)bl);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable Boolean bl) {
        return new ExportRecordField(EExportDataType.BOOLEAN, bl);
    }

    @Nonnull
    public static ExportRecordField create(int n) {
        return ExportRecordField.create((Integer)n);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable Integer n) {
        return new ExportRecordField(EExportDataType.INT, n);
    }

    @Nonnull
    public static ExportRecordField create(long l) {
        return ExportRecordField.create((Long)l);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable Long l) {
        return new ExportRecordField(EExportDataType.INT, l);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable BigInteger bigInteger) {
        return new ExportRecordField(EExportDataType.INT, bigInteger);
    }

    @Nonnull
    public static ExportRecordField create(double d) {
        return ExportRecordField.create((Double)d);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable Double d) {
        return new ExportRecordField(EExportDataType.DOUBLE, d);
    }

    @Nonnull
    public static ExportRecordField create(@Nullable BigDecimal bigDecimal) {
        return new ExportRecordField(EExportDataType.DOUBLE, bigDecimal);
    }
}

