/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkimport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.photon.exchange.EExchangeFileType;
import com.helger.photon.exchange.bulkimport.IBulkImport;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class AbstractBulkImport
implements IBulkImport {
    private final int m_nHeaderRowsToSkip;
    private final ICommonsList<IHasDisplayText> m_aColumnNames;
    private final ICommonsOrderedSet<EExchangeFileType> m_aFileTypes;

    protected AbstractBulkImport(@Nonnegative int n, @Nonnull @Nonempty List<IHasDisplayText> list, EExchangeFileType ... eExchangeFileTypeArray) {
        ValueEnforcer.isGE0((int)n, (String)"HeaderRowsToSkip");
        ValueEnforcer.notEmptyNoNullValue(list, (String)"ColumnNames");
        ValueEnforcer.notEmptyNoNullValue((Object[])eExchangeFileTypeArray, (String)"FileTypes");
        this.m_nHeaderRowsToSkip = n;
        this.m_aColumnNames = new CommonsArrayList(list);
        this.m_aFileTypes = new CommonsLinkedHashSet((Object[])eExchangeFileTypeArray);
    }

    @Override
    @Nonnegative
    public final int getHeaderRowsToSkip() {
        return this.m_nHeaderRowsToSkip;
    }

    @Override
    @Nonnegative
    public final int getColumnCount() {
        return this.m_aColumnNames.size();
    }

    @Override
    @Nonnull
    @Nonempty
    public final ICommonsList<String> getColumnDescriptions(@Nonnull Locale locale) {
        CommonsArrayList commonsArrayList = new CommonsArrayList(this.getColumnCount());
        for (IHasDisplayText iHasDisplayText : this.m_aColumnNames) {
            commonsArrayList.add((Object)iHasDisplayText.getDisplayText(locale));
        }
        return commonsArrayList;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final ICommonsList<EExchangeFileType> getSupportedFileTypes() {
        return this.m_aFileTypes.getCopyAsList();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("HeaderRowsToSkip", this.m_nHeaderRowsToSkip).append("ColumnNames", this.m_aColumnNames).append("FileTypes", this.m_aFileTypes).getToString();
    }
}

