/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkimport;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.Translatable;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.text.IHasText;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.commons.text.display.IHasDisplayTextWithArgs;
import com.helger.commons.text.resolve.DefaultTextResolver;
import com.helger.commons.text.util.TextHelper;
import com.helger.photon.exchange.EExchangeFileType;
import com.helger.photon.exchange.bulkimport.AbstractBulkImport;
import com.helger.photon.exchange.bulkimport.BulkImportResult;
import com.helger.poi.excel.ExcelReadHelper;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.poi.ss.usermodel.Cell;

public abstract class AbstractBulkImportExcel
extends AbstractBulkImport {
    protected AbstractBulkImportExcel(@Nonnegative int n, @Nonnull @Nonempty List<IHasDisplayText> list, EExchangeFileType ... eExchangeFileTypeArray) {
        super(n, list, eExchangeFileTypeArray);
    }

    @Nullable
    protected static final String getNormalizedString(@Nullable String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (Character.getType(c) == 15) continue;
            stringBuilder.append(c);
        }
        return StringHelper.replaceAllRepeatedly((String)stringBuilder.toString().trim(), (String)"  ", (String)" ");
    }

    @Nullable
    protected static final String getCellAsString(@Nonnull Cell cell) {
        String string = ExcelReadHelper.getCellValueString((Cell)cell);
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (char c : string.toCharArray()) {
            if (Character.getType(c) == 15) continue;
            stringBuilder.append(c);
        }
        return StringHelper.replaceAllRepeatedly((String)stringBuilder.toString().trim(), (String)"  ", (String)" ");
    }

    @Nullable
    protected static final Integer getCellAsInteger(@Nonnegative int n, @Nonnull Cell cell, @Nonnull BulkImportResult bulkImportResult, @Nonnull Locale locale) {
        Object object = ExcelReadHelper.getCellValueObject((Cell)cell);
        if (object == null) {
            return null;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        Integer n2 = null;
        if (object instanceof String) {
            n2 = StringParser.parseIntObj((String)((String)object));
        }
        if (n2 == null) {
            bulkImportResult.addWarning(EText.MSG_ERR_NO_INT.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(n), Integer.toString(cell.getColumnIndex())}));
        }
        return n2;
    }

    @Nullable
    protected static final Date getCellAsDate(@Nonnegative int n, @Nonnull Cell cell, @Nonnull BulkImportResult bulkImportResult, @Nonnull Locale locale) {
        Date date = ExcelReadHelper.getCellValueJavaDate((Cell)cell);
        if (date == null && ExcelReadHelper.getCellValueObject((Cell)cell) != null) {
            bulkImportResult.addWarning(EText.MSG_ERR_NO_DATE.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(n), Integer.toString(cell.getColumnIndex())}));
            return null;
        }
        return date;
    }

    @Nonnull
    protected static final ETriState getCellAsBoolean(@Nonnegative int n, @Nonnull Cell cell, @Nonnull BulkImportResult bulkImportResult, @Nonnull Locale locale) {
        Object object = ExcelReadHelper.getCellValueObject((Cell)cell);
        if (object == null) {
            return ETriState.UNDEFINED;
        }
        if (!(object instanceof Boolean)) {
            bulkImportResult.addWarning(EText.MSG_ERR_NO_BOOLEAN.getDisplayTextWithArgs(locale, new Object[]{Integer.toString(n), Integer.toString(cell.getColumnIndex())}));
            return ETriState.UNDEFINED;
        }
        return ETriState.valueOf((Boolean)((Boolean)object));
    }

    @Translatable
    private static enum EText implements IHasDisplayTextWithArgs
    {
        MSG_ERR_NO_STRING("Zeile {0}, Spalte {1}: Zeichenkette erwartet", "Row {0}, Column {1}: expected string"),
        MSG_ERR_NO_INT("Zeile {0}, Spalte {1}: Ganzzahl erwartet", "Row {0}, Column {1}: expected integer"),
        MSG_ERR_NO_DATE("Zeile {0}, Spalte {1}: Datum erwartet", "Row {0}, Column {1}: expected date"),
        MSG_ERR_NO_BOOLEAN("Zeile {0}, Spalte {1}: Wahrheitswert erwartet", "Row {0}, Column {1}: expected boolean");

        private final IMultilingualText m_aTP;

        private EText(String string2, String string3) {
            this.m_aTP = TextHelper.create_DE_EN((String)string2, (String)string3);
        }

        @Nullable
        public String getDisplayText(@Nonnull Locale locale) {
            return DefaultTextResolver.getTextStatic((Enum)this, (IHasText)this.m_aTP, (Locale)locale);
        }
    }
}

