/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport.format;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.csv.CSVWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.system.SystemHelper;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.photon.exchange.EExchangeFileType;
import com.helger.photon.exchange.bulkexport.IExportRecord;
import com.helger.photon.exchange.bulkexport.IExportRecordField;
import com.helger.photon.exchange.bulkexport.IExportRecordProvider;
import com.helger.photon.exchange.bulkexport.IExporterFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ExporterCSV
implements IExporterFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExporterCSV.class);
    private Charset m_aCharset;
    private char m_cSeparatorChar = (char)44;
    private char m_cQuoteChar = (char)34;
    private char m_cEscapeChar = (char)92;
    private String m_sLineEnd = "\n";
    private EUnicodeBOM m_eBOM;
    private boolean m_bAvoidWriteEmpty = false;
    private boolean m_bAvoidFinalLineEnd = false;

    public ExporterCSV() {
        this(SystemHelper.getSystemCharset());
    }

    public ExporterCSV(@Nonnull Charset charset) {
        this.setCharset(charset);
    }

    @Override
    @Nonnull
    public final EExchangeFileType getFileType() {
        return EExchangeFileType.CSV;
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final ExporterCSV setCharset(@Nonnull Charset charset) {
        this.m_aCharset = (Charset)ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return this;
    }

    public final char getSeparatorChar() {
        return this.m_cSeparatorChar;
    }

    @Nonnull
    public final ExporterCSV setSeparatorChar(char c) {
        this.m_cSeparatorChar = c;
        return this;
    }

    public final char getQuoteChar() {
        return this.m_cQuoteChar;
    }

    @Nonnull
    public final ExporterCSV setQuoteChar(char c) {
        this.m_cQuoteChar = c;
        return this;
    }

    public final char getEscapeChar() {
        return this.m_cEscapeChar;
    }

    @Nonnull
    public final ExporterCSV setEscapeChar(char c) {
        this.m_cEscapeChar = c;
        return this;
    }

    @Nonnull
    @Nonempty
    public final String getLineEnd() {
        return this.m_sLineEnd;
    }

    @Nonnull
    public final ExporterCSV setLineEnd(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"LineEnd");
        this.m_sLineEnd = string;
        return this;
    }

    @Nullable
    public final EUnicodeBOM getUnicodeBOM() {
        return this.m_eBOM;
    }

    @Nonnull
    public final ExporterCSV setUnicodeBOM(@Nullable EUnicodeBOM eUnicodeBOM) {
        this.m_eBOM = eUnicodeBOM;
        return this;
    }

    public final boolean isAvoidWriteEmpty() {
        return this.m_bAvoidWriteEmpty;
    }

    @Nonnull
    public final ExporterCSV setAvoidWriteEmpty(boolean bl) {
        this.m_bAvoidWriteEmpty = bl;
        return this;
    }

    public final boolean isAvoidFinalLineEnd() {
        return this.m_bAvoidFinalLineEnd;
    }

    @Nonnull
    public final ExporterCSV setAvoidFinalLineEnd(boolean bl) {
        this.m_bAvoidFinalLineEnd = bl;
        return this;
    }

    @Nonnull
    private static ICommonsList<String> _getAsCSVRecord(@Nonnull IExportRecord iExportRecord) {
        ICommonsList<? extends IExportRecordField> iCommonsList = iExportRecord.getAllFields();
        CommonsArrayList commonsArrayList = new CommonsArrayList(iCommonsList.size());
        for (IExportRecordField iExportRecordField : iCommonsList) {
            Object object = iExportRecordField.getFieldValue();
            if (object == null) {
                commonsArrayList.add((Object)"");
                continue;
            }
            commonsArrayList.add((Object)((String)TypeConverter.convert((Object)object, String.class)));
        }
        return commonsArrayList;
    }

    @Nonnull
    @WillCloseWhenClosed
    @OverrideOnDemand
    protected CSVWriter createCSVWriter(@Nonnull OutputStream outputStream) {
        return new CSVWriter((Writer)new OutputStreamWriter(outputStream, this.m_aCharset)).setSeparatorChar(this.m_cSeparatorChar).setQuoteChar(this.m_cQuoteChar).setEscapeChar(this.m_cEscapeChar).setLineEnd(this.m_sLineEnd).setAvoidFinalLineEnd(this.m_bAvoidFinalLineEnd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess exportRecords(@Nonnull IExportRecordProvider iExportRecordProvider, @Nonnull @WillClose OutputStream outputStream) {
        try {
            CommonsArrayList commonsArrayList;
            ValueEnforcer.notNull((Object)iExportRecordProvider, (String)"Provider");
            ValueEnforcer.notNull((Object)outputStream, (String)"OutputStream");
            if (this.m_bAvoidWriteEmpty) {
                commonsArrayList = new CommonsArrayList();
                iExportRecordProvider.forEachHeaderRecord(arg_0 -> ExporterCSV.lambda$exportRecords$0((ICommonsList)commonsArrayList, arg_0));
                iExportRecordProvider.forEachBodyRecord(arg_0 -> ExporterCSV.lambda$exportRecords$1((ICommonsList)commonsArrayList, arg_0));
                iExportRecordProvider.forEachFooterRecord(arg_0 -> ExporterCSV.lambda$exportRecords$2((ICommonsList)commonsArrayList, arg_0));
                if (commonsArrayList.isEmpty()) {
                    ESuccess eSuccess = ESuccess.FAILURE;
                    return eSuccess;
                }
                if (this.m_eBOM != null) {
                    outputStream.write(this.m_eBOM.getAllBytes());
                }
                try (CSVWriter cSVWriter = this.createCSVWriter(outputStream);){
                    cSVWriter.writeAll((List)commonsArrayList);
                }
            }
            if (this.m_eBOM != null) {
                outputStream.write(this.m_eBOM.getAllBytes());
            }
            commonsArrayList = this.createCSVWriter(outputStream);
            try {
                iExportRecordProvider.forEachHeaderRecord(arg_0 -> ExporterCSV.lambda$exportRecords$3((CSVWriter)commonsArrayList, arg_0));
                iExportRecordProvider.forEachBodyRecord(arg_0 -> ExporterCSV.lambda$exportRecords$4((CSVWriter)commonsArrayList, arg_0));
                iExportRecordProvider.forEachFooterRecord(arg_0 -> ExporterCSV.lambda$exportRecords$5((CSVWriter)commonsArrayList, arg_0));
            }
            finally {
                if (commonsArrayList != null) {
                    commonsArrayList.close();
                }
            }
            commonsArrayList = ESuccess.SUCCESS;
            return commonsArrayList;
        }
        catch (IOException iOException) {
            LOGGER.error("Error exporting to CSV", (Throwable)iOException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close((AutoCloseable)outputStream);
        }
    }

    private static /* synthetic */ void lambda$exportRecords$5(CSVWriter cSVWriter, IExportRecord iExportRecord) {
        cSVWriter.writeNext(ExporterCSV._getAsCSVRecord(iExportRecord));
    }

    private static /* synthetic */ void lambda$exportRecords$4(CSVWriter cSVWriter, IExportRecord iExportRecord) {
        cSVWriter.writeNext(ExporterCSV._getAsCSVRecord(iExportRecord));
    }

    private static /* synthetic */ void lambda$exportRecords$3(CSVWriter cSVWriter, IExportRecord iExportRecord) {
        cSVWriter.writeNext(ExporterCSV._getAsCSVRecord(iExportRecord));
    }

    private static /* synthetic */ void lambda$exportRecords$2(ICommonsList iCommonsList, IExportRecord iExportRecord) {
        iCommonsList.add(ExporterCSV._getAsCSVRecord(iExportRecord));
    }

    private static /* synthetic */ void lambda$exportRecords$1(ICommonsList iCommonsList, IExportRecord iExportRecord) {
        iCommonsList.add(ExporterCSV._getAsCSVRecord(iExportRecord));
    }

    private static /* synthetic */ void lambda$exportRecords$0(ICommonsList iCommonsList, IExportRecord iExportRecord) {
        iCommonsList.add(ExporterCSV._getAsCSVRecord(iExportRecord));
    }
}

