/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.text.display.IHasDisplayText;
import com.helger.photon.exchange.EExchangeFileTypeName;
import com.helger.photon.exchange.EExchangeFileTypeText;
import com.helger.photon.exchange.bulkexport.IExporter;
import com.helger.photon.exchange.bulkexport.format.ExporterCSV;
import com.helger.photon.exchange.bulkexport.format.ExporterExcel;
import com.helger.photon.exchange.bulkexport.format.ExporterJSON;
import com.helger.photon.exchange.bulkexport.format.ExporterXML;
import com.helger.poi.excel.EExcelVersion;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EExchangeFileType implements IHasID<String>,
IHasDisplayText
{
    CSV("csv", ".csv", CMimeType.TEXT_CSV, true, EExchangeFileTypeName.CSV){

        @Override
        @Nonnull
        public ExporterCSV createExporter() {
            return new ExporterCSV().setCharset(StandardCharsets.ISO_8859_1).setSeparatorChar(';');
        }
    }
    ,
    XLS("xls", EExcelVersion.XLS.getFileExtension(), EExcelVersion.XLS.getMimeType(), true, EExchangeFileTypeName.XLS){

        @Override
        @Nonnull
        public ExporterExcel createExporter() {
            return new ExporterExcel(EExcelVersion.XLS);
        }
    }
    ,
    XLSX("xlsx", EExcelVersion.XLSX.getFileExtension(), EExcelVersion.XLSX.getMimeType(), true, EExchangeFileTypeName.XLSX){

        @Override
        @Nonnull
        public ExporterExcel createExporter() {
            return new ExporterExcel(EExcelVersion.XLSX);
        }
    }
    ,
    XML("xml", ".xml", CMimeType.TEXT_XML, false, EExchangeFileTypeName.XML){

        @Override
        @Nonnull
        public ExporterXML createExporter() {
            return new ExporterXML();
        }
    }
    ,
    TXT("txt", ".txt", CMimeType.TEXT_PLAIN, true, EExchangeFileTypeName.TXT){

        @Override
        @Nullable
        public IExporter createExporter() {
            return null;
        }
    }
    ,
    JSON("json", ".json", CMimeType.APPLICATION_JSON, false, EExchangeFileTypeName.JSON){

        @Override
        @Nonnull
        public ExporterJSON createExporter() {
            return new ExporterJSON();
        }
    }
    ,
    JSON_SIMPLE("json-simple", ".json", CMimeType.APPLICATION_JSON, false, EExchangeFileTypeName.JSON_SIMPLE){

        @Override
        @Nonnull
        public ExporterJSON createExporter() {
            return new ExporterJSON().setEmitType(false);
        }
    };

    private final String m_sID;
    private final String m_sExt;
    private final IMimeType m_aMimeType;
    private final boolean m_bLineBased;
    private final EExchangeFileTypeName m_aName;

    private EExchangeFileType(@Nonnull String string2, String string3, @Nonnull IMimeType iMimeType, boolean bl, EExchangeFileTypeName eExchangeFileTypeName) {
        this.m_sID = string2;
        this.m_sExt = string3;
        this.m_aMimeType = iMimeType;
        this.m_bLineBased = bl;
        this.m_aName = eExchangeFileTypeName;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getFileExtension() {
        return this.m_sExt;
    }

    @Nonnull
    public IMimeType getMimeType() {
        return this.m_aMimeType;
    }

    public boolean isLineBased() {
        return this.m_bLineBased;
    }

    @Nullable
    public String getDisplayText(@Nonnull Locale locale) {
        return this.m_aName.getDisplayText(locale);
    }

    @Nullable
    public String getExportAsText(@Nonnull Locale locale) {
        return EExchangeFileTypeText.EXPORT_AS.getDisplayTextWithArgs(locale, new Object[]{this.getDisplayText(locale)});
    }

    @Nullable
    public String getSaveAsText(@Nonnull Locale locale) {
        return EExchangeFileTypeText.SAVE_AS.getDisplayTextWithArgs(locale, new Object[]{this.getDisplayText(locale)});
    }

    @Nullable
    public abstract IExporter createExporter();

    public boolean isExporterAvailable() {
        return this.createExporter() != null;
    }

    @Nullable
    public static EExchangeFileType getFromIDOrNull(@Nullable String string) {
        return (EExchangeFileType)EnumHelper.getFromIDOrNull(EExchangeFileType.class, (Object)string);
    }

    @Nullable
    public static EExchangeFileType getFromIDOrDefault(@Nullable String string, @Nullable EExchangeFileType eExchangeFileType) {
        return (EExchangeFileType)EnumHelper.getFromIDOrDefault(EExchangeFileType.class, (Object)string, (Enum)eExchangeFileType);
    }
}

