/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.exchange.bulkexport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.exchange.bulkexport.IExportRecord;
import com.helger.photon.exchange.bulkexport.IExportRecordProvider;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConstantExportRecordProvider
implements IExportRecordProvider {
    private final ICommonsList<IExportRecord> m_aHeader = new CommonsArrayList();
    private final ICommonsList<IExportRecord> m_aBody;
    private final ICommonsList<IExportRecord> m_aFooter = new CommonsArrayList();

    public ConstantExportRecordProvider(@Nonnull Iterable<? extends IExportRecord> iterable) {
        this(null, iterable, null);
    }

    public ConstantExportRecordProvider(@Nullable IExportRecord iExportRecord, @Nonnull Iterable<? extends IExportRecord> iterable) {
        this(iExportRecord, iterable, null);
    }

    public ConstantExportRecordProvider(@Nullable IExportRecord iExportRecord, @Nonnull Iterable<? extends IExportRecord> iterable, @Nullable IExportRecord iExportRecord2) {
        ValueEnforcer.notNull(iterable, (String)"Body");
        if (iExportRecord != null) {
            this.m_aHeader.add((Object)iExportRecord);
        }
        this.m_aBody = new CommonsArrayList(iterable);
        if (iExportRecord2 != null) {
            this.m_aFooter.add((Object)iExportRecord2);
        }
    }

    @Override
    public void forEachHeaderRecord(@Nonnull Consumer<? super IExportRecord> consumer) {
        this.m_aHeader.forEach(consumer);
    }

    @Override
    public void forEachBodyRecord(@Nonnull Consumer<? super IExportRecord> consumer) {
        this.m_aBody.forEach(consumer);
    }

    @Override
    public void forEachFooterRecord(@Nonnull Consumer<? super IExportRecord> consumer) {
        this.m_aFooter.forEach(consumer);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("header", this.m_aHeader).append("body", this.m_aBody).append("footer", this.m_aFooter).getToString();
    }
}

