/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dianubl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.dianubl.EDianUBLDocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class DianUBLDocumentTypes {
    private static final ICommonsMap<String, EDianUBLDocumentType> LOCAL_NAME_TO_DOC_TYPE = new CommonsHashMap();
    private static final DianUBLDocumentTypes INSTANCE;

    private DianUBLDocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return LOCAL_NAME_TO_DOC_TYPE.copyOfKeySet();
    }

    @Nullable
    public static EDianUBLDocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EDianUBLDocumentType)((Object)LOCAL_NAME_TO_DOC_TYPE.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EDianUBLDocumentType eDianUBLDocumentType = DianUBLDocumentTypes.getDocumentTypeOfLocalName(string);
        return eDianUBLDocumentType == null ? null : eDianUBLDocumentType.getImplementationClass();
    }

    @Nullable
    public static EDianUBLDocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return (EDianUBLDocumentType)((Object)ArrayHelper.findFirst((Object[])EDianUBLDocumentType.values(), eDianUBLDocumentType -> eDianUBLDocumentType.getImplementationClass().equals(clazz)));
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EDianUBLDocumentType eDianUBLDocumentType = DianUBLDocumentTypes.getDocumentTypeOfLocalName(string);
        return eDianUBLDocumentType == null ? null : eDianUBLDocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EDianUBLDocumentType eDianUBLDocumentType = DianUBLDocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eDianUBLDocumentType == null ? null : eDianUBLDocumentType.getSchema();
    }

    static {
        for (EDianUBLDocumentType eDianUBLDocumentType : EDianUBLDocumentType.values()) {
            String string = eDianUBLDocumentType.getLocalName();
            if (LOCAL_NAME_TO_DOC_TYPE.containsKey((Object)string)) {
                throw new IllegalArgumentException("The local name '" + string + "' is already mapped!");
            }
            LOCAL_NAME_TO_DOC_TYPE.put((Object)string, (Object)eDianUBLDocumentType);
        }
        INSTANCE = new DianUBLDocumentTypes();
    }
}

