/*
 * Decompiled with CFR 0.152.
 */
package com.helger.dianubl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.dianubl.CDianUBL;
import com.helger.ubl21.CUBL21;
import com.helger.ubl21.EUBL21DocumentType;
import dian.gov.co.facturaelectronica.structures_2_1.DianExtensionsType;
import java.util.Collection;
import javax.annotation.Nonnull;

public enum EDianUBLDocumentType {
    APPLICATION_RESPONSE(EUBL21DocumentType.APPLICATION_RESPONSE),
    ATTACHED_DOCUMENT(EUBL21DocumentType.ATTACHED_DOCUMENT),
    CREDIT_NOTE(EUBL21DocumentType.CREDIT_NOTE),
    DEBIT_NOTE(EUBL21DocumentType.DEBIT_NOTE),
    INVOICE(EUBL21DocumentType.INVOICE),
    DIAN_EXTENSIONS(DianExtensionsType.class, (ICommonsList<ClassPathResource>)new CommonsArrayList((Object[])new ClassPathResource[]{CUBL21.XSD_UNQUALIFIED_DATA_TYPES, CUBL21.XSD_COMMON_AGGREGATE_COMPONENTS, CDianUBL.XSD_DIAN_UBL_STRUCTURE}));

    private final Class<?> m_aImplClass;
    private final ICommonsList<ClassPathResource> m_aXSDs;

    @Nonnull
    private static ClassLoader _getCL() {
        return EDianUBLDocumentType.class.getClassLoader();
    }

    @Nonnull
    private static ICommonsList<ClassPathResource> _injectSTS(@Nonnull ICommonsList<ClassPathResource> iCommonsList) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (iCommonsList.size() > 1) {
            commonsArrayList.addAll((Collection)iCommonsList.subList(0, iCommonsList.size() - 1));
        }
        commonsArrayList.add((Object)CUBL21.XSD_UNQUALIFIED_DATA_TYPES);
        commonsArrayList.add((Object)CUBL21.XSD_COMMON_AGGREGATE_COMPONENTS);
        commonsArrayList.add((Object)CDianUBL.XSD_DIAN_UBL_STRUCTURE);
        commonsArrayList.add((Object)((ClassPathResource)iCommonsList.getLast()));
        return commonsArrayList;
    }

    private EDianUBLDocumentType(EUBL21DocumentType eUBL21DocumentType) {
        this.m_aImplClass = eUBL21DocumentType.getImplementationClass();
        this.m_aXSDs = eUBL21DocumentType.getAllXSDResources();
    }

    private EDianUBLDocumentType(Class<?> clazz, ICommonsList<ClassPathResource> iCommonsList) {
        this.m_aImplClass = clazz;
        this.m_aXSDs = iCommonsList;
    }

    @Nonnull
    public Class<?> getImplementationClass() {
        return this.m_aImplClass;
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<ClassPathResource> getAllXSDResources() {
        return (ICommonsList)this.m_aXSDs.getClone();
    }
}

