
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MaximumNumberNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.MinimumNumberNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.OptionsDescriptionType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Contract Extension. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to describe possible extensions to a contract.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Contract Extension&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ContractExtensionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ContractExtensionType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OptionsDescription" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumNumberNumeric" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumNumberNumeric" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OptionValidityPeriod" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Renewal" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ContractExtensionType", propOrder = {
    "optionsDescription",
    "minimumNumberNumeric",
    "maximumNumberNumeric",
    "optionValidityPeriod",
    "renewal"
})
@CodingStyleguideUnaware
public class ContractExtensionType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "OptionsDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<OptionsDescriptionType> optionsDescription;
    @XmlElement(name = "MinimumNumberNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumNumberNumericType minimumNumberNumeric;
    @XmlElement(name = "MaximumNumberNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumNumberNumericType maximumNumberNumeric;
    @XmlElement(name = "OptionValidityPeriod")
    private PeriodType optionValidityPeriod;
    @XmlElement(name = "Renewal")
    private List<RenewalType> renewal;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ContractExtensionType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Contract Extension. Options Description. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A description for the possible options that can be carried out during the execution of the contract.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Contract Extension&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Options Description&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the optionsDescription property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the optionsDescription property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getOptionsDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OptionsDescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<OptionsDescriptionType> getOptionsDescription() {
        if (optionsDescription == null) {
            optionsDescription = new ArrayList<OptionsDescriptionType>();
        }
        return this.optionsDescription;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Contract Extension. Minimum_ Number. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The fixed minimum number of contract extensions or renewals.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Contract Extension&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Minimum&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Number&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link MinimumNumberNumericType }
     *     
     */
    @Nullable
    public MinimumNumberNumericType getMinimumNumberNumeric() {
        return minimumNumberNumeric;
    }

    /**
     * Sets the value of the minimumNumberNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumNumberNumericType }
     *     
     */
    public void setMinimumNumberNumeric(
        @Nullable
        MinimumNumberNumericType value) {
        this.minimumNumberNumeric = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Contract Extension. Maximum_ Number. Numeric&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The maximum allowed number of contract extensions.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Contract Extension&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Maximum&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Number&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Numeric&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Numeric. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link MaximumNumberNumericType }
     *     
     */
    @Nullable
    public MaximumNumberNumericType getMaximumNumberNumeric() {
        return maximumNumberNumeric;
    }

    /**
     * Sets the value of the maximumNumberNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumNumberNumericType }
     *     
     */
    public void setMaximumNumberNumeric(
        @Nullable
        MaximumNumberNumericType value) {
        this.maximumNumberNumeric = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Contract Extension. Option Validity_ Period. Period&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The period during which the option for extending the contract is available.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Contract Extension&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Option Validity&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Period&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Period&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Period&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getOptionValidityPeriod() {
        return optionValidityPeriod;
    }

    /**
     * Sets the value of the optionValidityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setOptionValidityPeriod(
        @Nullable
        PeriodType value) {
        this.optionValidityPeriod = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Contract Extension. Renewal&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The period allowed for each contract extension.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Contract Extension&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Renewal&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Renewal&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Renewal&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the renewal property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the renewal property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRenewal().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RenewalType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RenewalType> getRenewal() {
        if (renewal == null) {
            renewal = new ArrayList<RenewalType>();
        }
        return this.renewal;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ContractExtensionType rhs = ((ContractExtensionType) o);
        if (!EqualsHelper.equals(maximumNumberNumeric, rhs.maximumNumberNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumNumberNumeric, rhs.minimumNumberNumeric)) {
            return false;
        }
        if (!EqualsHelper.equals(optionValidityPeriod, rhs.optionValidityPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(optionsDescription, rhs.optionsDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(renewal, rhs.renewal)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(maximumNumberNumeric).append(minimumNumberNumeric).append(optionValidityPeriod).append(optionsDescription).append(renewal).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("maximumNumberNumeric", maximumNumberNumeric).append("minimumNumberNumeric", minimumNumberNumeric).append("optionValidityPeriod", optionValidityPeriod).append("optionsDescription", optionsDescription).append("renewal", renewal).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setOptionsDescription(
        @Nullable
        final List<OptionsDescriptionType> aList) {
        optionsDescription = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRenewal(
        @Nullable
        final List<RenewalType> aList) {
        renewal = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasOptionsDescriptionEntries() {
        return (!getOptionsDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoOptionsDescriptionEntries() {
        return getOptionsDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getOptionsDescriptionCount() {
        return getOptionsDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public OptionsDescriptionType getOptionsDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOptionsDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addOptionsDescription(
        @Nonnull
        final OptionsDescriptionType elem) {
        getOptionsDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRenewalEntries() {
        return (!getRenewal().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRenewalEntries() {
        return getRenewal().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRenewalCount() {
        return getRenewal().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RenewalType getRenewalAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRenewal().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRenewal(
        @Nonnull
        final RenewalType elem) {
        getRenewal().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ContractExtensionType ret) {
        ret.maximumNumberNumeric = ((maximumNumberNumeric == null)?null:maximumNumberNumeric.clone());
        ret.minimumNumberNumeric = ((minimumNumberNumeric == null)?null:minimumNumberNumeric.clone());
        ret.optionValidityPeriod = ((optionValidityPeriod == null)?null:optionValidityPeriod.clone());
        if (optionsDescription == null) {
            ret.optionsDescription = null;
        } else {
            List<OptionsDescriptionType> retOptionsDescription = new ArrayList<OptionsDescriptionType>();
            for (OptionsDescriptionType aItem: getOptionsDescription()) {
                retOptionsDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.optionsDescription = retOptionsDescription;
        }
        if (renewal == null) {
            ret.renewal = null;
        } else {
            List<RenewalType> retRenewal = new ArrayList<RenewalType>();
            for (RenewalType aItem: getRenewal()) {
                retRenewal.add(((aItem == null)?null:aItem.clone()));
            }
            ret.renewal = retRenewal;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ContractExtensionType clone() {
        ContractExtensionType ret = new ContractExtensionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MinimumNumberNumericType and never <code>null</code>
     */
    @Nonnull
    public MinimumNumberNumericType setMinimumNumberNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MinimumNumberNumericType aObj = getMinimumNumberNumeric();
        if (aObj == null) {
            aObj = new MinimumNumberNumericType(valueParam);
            setMinimumNumberNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumNumberNumericType and never <code>null</code>
     */
    @Nonnull
    public MaximumNumberNumericType setMaximumNumberNumeric(
        @Nullable
        final BigDecimal valueParam) {
        MaximumNumberNumericType aObj = getMaximumNumberNumeric();
        if (aObj == null) {
            aObj = new MaximumNumberNumericType(valueParam);
            setMaximumNumberNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained MinimumNumberNumericType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumNumberNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMinimumNumberNumericValue() {
        MinimumNumberNumericType aObj = getMinimumNumberNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumNumberNumericType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumNumberNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumNumberNumericValue() {
        MaximumNumberNumericType aObj = getMaximumNumberNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

}
