
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_21;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.OversupplyQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.QuantityDiscrepancyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ReceivedDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ReceivedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.RejectActionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.RejectReasonCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.RejectReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.RejectedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ShortQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.ShortageActionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TimingComplaintCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.TimingComplaintType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_21.UUIDType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ABIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A class to define a line in a Receipt Advice.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;/ccts:Component&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ReceiptLineType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ReceiptLineType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UUID" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReceivedQuantity" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShortQuantity" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShortageActionCode" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectedQuantity" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectReasonCode" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectReason" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectActionCode" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}QuantityDiscrepancyCode" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OversupplyQuantity" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReceivedDate" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TimingComplaintCode" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TimingComplaint" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OrderLineReference" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DespatchLineReference" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentReference" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Item" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Shipment" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReceiptLineType", propOrder = {
    "id",
    "uuid",
    "note",
    "receivedQuantity",
    "shortQuantity",
    "shortageActionCode",
    "rejectedQuantity",
    "rejectReasonCode",
    "rejectReason",
    "rejectActionCode",
    "quantityDiscrepancyCode",
    "oversupplyQuantity",
    "receivedDate",
    "timingComplaintCode",
    "timingComplaint",
    "orderLineReference",
    "despatchLineReference",
    "documentReference",
    "item",
    "shipment"
})
@CodingStyleguideUnaware
public class ReceiptLineType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "UUID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UUIDType uuid;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "ReceivedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReceivedQuantityType receivedQuantity;
    @XmlElement(name = "ShortQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShortQuantityType shortQuantity;
    @XmlElement(name = "ShortageActionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShortageActionCodeType shortageActionCode;
    @XmlElement(name = "RejectedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RejectedQuantityType rejectedQuantity;
    @XmlElement(name = "RejectReasonCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RejectReasonCodeType rejectReasonCode;
    @XmlElement(name = "RejectReason", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<RejectReasonType> rejectReason;
    @XmlElement(name = "RejectActionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RejectActionCodeType rejectActionCode;
    @XmlElement(name = "QuantityDiscrepancyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityDiscrepancyCodeType quantityDiscrepancyCode;
    @XmlElement(name = "OversupplyQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OversupplyQuantityType oversupplyQuantity;
    @XmlElement(name = "ReceivedDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReceivedDateType receivedDate;
    @XmlElement(name = "TimingComplaintCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TimingComplaintCodeType timingComplaintCode;
    @XmlElement(name = "TimingComplaint", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TimingComplaintType timingComplaint;
    @XmlElement(name = "OrderLineReference")
    private OrderLineReferenceType orderLineReference;
    @XmlElement(name = "DespatchLineReference")
    private List<LineReferenceType> despatchLineReference;
    @XmlElement(name = "DocumentReference")
    private List<DocumentReferenceType> documentReference;
    @XmlElement(name = "Item")
    private List<ItemType> item;
    @XmlElement(name = "Shipment")
    private List<ShipmentType> shipment;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ReceiptLineType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An identifier for this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. UUID. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A universally unique identifier for this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;UUID&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Identifier. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link UUIDType }
     *     
     */
    @Nullable
    public UUIDType getUUID() {
        return uuid;
    }

    /**
     * Sets the value of the uuid property.
     * 
     * @param value
     *     allowed object is
     *     {@link UUIDType }
     *     
     */
    public void setUUID(
        @Nullable
        UUIDType value) {
        this.uuid = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Note. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;Free-form text conveying information that is not contained explicitly in other structures.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Note&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the note property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<NoteType>();
        }
        return this.note;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Received_ Quantity. Quantity&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The quantity received.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Received&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Quantity&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Quantity&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Quantity. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link ReceivedQuantityType }
     *     
     */
    @Nullable
    public ReceivedQuantityType getReceivedQuantity() {
        return receivedQuantity;
    }

    /**
     * Sets the value of the receivedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivedQuantityType }
     *     
     */
    public void setReceivedQuantity(
        @Nullable
        ReceivedQuantityType value) {
        this.receivedQuantity = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Short_ Quantity. Quantity&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The quantity received short; the difference between the quantity reported despatched and the quantity actually received.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Short&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Quantity&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Quantity&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Quantity. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link ShortQuantityType }
     *     
     */
    @Nullable
    public ShortQuantityType getShortQuantity() {
        return shortQuantity;
    }

    /**
     * Sets the value of the shortQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShortQuantityType }
     *     
     */
    public void setShortQuantity(
        @Nullable
        ShortQuantityType value) {
        this.shortQuantity = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Shortage Action Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the action that the delivery party wishes the despatch party to take as the result of a shortage.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Shortage Action Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link ShortageActionCodeType }
     *     
     */
    @Nullable
    public ShortageActionCodeType getShortageActionCode() {
        return shortageActionCode;
    }

    /**
     * Sets the value of the shortageActionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShortageActionCodeType }
     *     
     */
    public void setShortageActionCode(
        @Nullable
        ShortageActionCodeType value) {
        this.shortageActionCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Rejected_ Quantity. Quantity&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The quantity rejected.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Rejected&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Quantity&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Quantity&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Quantity. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link RejectedQuantityType }
     *     
     */
    @Nullable
    public RejectedQuantityType getRejectedQuantity() {
        return rejectedQuantity;
    }

    /**
     * Sets the value of the rejectedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link RejectedQuantityType }
     *     
     */
    public void setRejectedQuantity(
        @Nullable
        RejectedQuantityType value) {
        this.rejectedQuantity = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Reject Reason Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The reason for a rejection, expressed as a code.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Reject Reason Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link RejectReasonCodeType }
     *     
     */
    @Nullable
    public RejectReasonCodeType getRejectReasonCode() {
        return rejectReasonCode;
    }

    /**
     * Sets the value of the rejectReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RejectReasonCodeType }
     *     
     */
    public void setRejectReasonCode(
        @Nullable
        RejectReasonCodeType value) {
        this.rejectReasonCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Reject_ Reason. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The reason for a rejection, expressed as text.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Reject&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Reason&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the rejectReason property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the rejectReason property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRejectReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RejectReasonType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RejectReasonType> getRejectReason() {
        if (rejectReason == null) {
            rejectReason = new ArrayList<RejectReasonType>();
        }
        return this.rejectReason;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Reject Action Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the action that the delivery party wishes the despatch party to take as the result of a rejection.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Reject Action Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link RejectActionCodeType }
     *     
     */
    @Nullable
    public RejectActionCodeType getRejectActionCode() {
        return rejectActionCode;
    }

    /**
     * Sets the value of the rejectActionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RejectActionCodeType }
     *     
     */
    public void setRejectActionCode(
        @Nullable
        RejectActionCodeType value) {
        this.rejectActionCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Quantity Discrepancy Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A code signifying the type of a discrepancy in quantity.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Quantity Discrepancy Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link QuantityDiscrepancyCodeType }
     *     
     */
    @Nullable
    public QuantityDiscrepancyCodeType getQuantityDiscrepancyCode() {
        return quantityDiscrepancyCode;
    }

    /**
     * Sets the value of the quantityDiscrepancyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityDiscrepancyCodeType }
     *     
     */
    public void setQuantityDiscrepancyCode(
        @Nullable
        QuantityDiscrepancyCodeType value) {
        this.quantityDiscrepancyCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Oversupply_ Quantity. Quantity&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The quantity over-supplied, i.e., the quantity over and above the quantity ordered.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Oversupply&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Quantity&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Quantity&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Quantity. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link OversupplyQuantityType }
     *     
     */
    @Nullable
    public OversupplyQuantityType getOversupplyQuantity() {
        return oversupplyQuantity;
    }

    /**
     * Sets the value of the oversupplyQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link OversupplyQuantityType }
     *     
     */
    public void setOversupplyQuantity(
        @Nullable
        OversupplyQuantityType value) {
        this.oversupplyQuantity = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Received_ Date. Date&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The date on which the goods or services were received.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Received&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Date&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Date&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Date. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link ReceivedDateType }
     *     
     */
    @Nullable
    public ReceivedDateType getReceivedDate() {
        return receivedDate;
    }

    /**
     * Sets the value of the receivedDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivedDateType }
     *     
     */
    public void setReceivedDate(
        @Nullable
        ReceivedDateType value) {
        this.receivedDate = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Timing Complaint Code. Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A complaint about the timing of delivery, expressed as a code.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Timing Complaint Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link TimingComplaintCodeType }
     *     
     */
    @Nullable
    public TimingComplaintCodeType getTimingComplaintCode() {
        return timingComplaintCode;
    }

    /**
     * Sets the value of the timingComplaintCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimingComplaintCodeType }
     *     
     */
    public void setTimingComplaintCode(
        @Nullable
        TimingComplaintCodeType value) {
        this.timingComplaintCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;BBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Timing Complaint. Text&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A complaint about the timing of delivery, expressed as text.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Timing Complaint&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Text. Type&lt;/ccts:DataType&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link TimingComplaintType }
     *     
     */
    @Nullable
    public TimingComplaintType getTimingComplaint() {
        return timingComplaint;
    }

    /**
     * Sets the value of the timingComplaint property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimingComplaintType }
     *     
     */
    public void setTimingComplaint(
        @Nullable
        TimingComplaintType value) {
        this.timingComplaint = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Order Line Reference&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the order line associated with this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Order Line Reference&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Order Line Reference&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Order Line Reference&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link OrderLineReferenceType }
     *     
     */
    @Nullable
    public OrderLineReferenceType getOrderLineReference() {
        return orderLineReference;
    }

    /**
     * Sets the value of the orderLineReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrderLineReferenceType }
     *     
     */
    public void setOrderLineReference(
        @Nullable
        OrderLineReferenceType value) {
        this.orderLineReference = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Despatch_ Line Reference. Line Reference&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to a despatch line associated with this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTermQualifier&gt;Despatch&lt;/ccts:PropertyTermQualifier&gt;&lt;ccts:PropertyTerm&gt;Line Reference&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Line Reference&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Line Reference&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the despatchLineReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the despatchLineReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDespatchLineReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LineReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LineReferenceType> getDespatchLineReference() {
        if (despatchLineReference == null) {
            despatchLineReference = new ArrayList<LineReferenceType>();
        }
        return this.despatchLineReference;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Document Reference&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to a document associated with this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Document Reference&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Document Reference&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Document Reference&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the documentReference property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the documentReference property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getDocumentReference() {
        if (documentReference == null) {
            documentReference = new ArrayList<DocumentReferenceType>();
        }
        return this.documentReference;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Item&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;An item associated with this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Item&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Item&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Item&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the item property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the item property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemType> getItem() {
        if (item == null) {
            item = new ArrayList<ItemType>();
        }
        return this.item;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:Component xmlns:ccts="urn:un:unece:uncefact:documentation:2" xmlns="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:p366706_="http://java.sun.com/xml/ns/jaxb" xmlns:p44339_="http://java.sun.com/xml/ns/jaxb/xjc" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;ASBIE&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Receipt Line. Shipment&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A shipment associated with this receipt line.&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..n&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;Receipt Line&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Shipment&lt;/ccts:PropertyTerm&gt;&lt;ccts:AssociatedObjectClass&gt;Shipment&lt;/ccts:AssociatedObjectClass&gt;&lt;ccts:RepresentationTerm&gt;Shipment&lt;/ccts:RepresentationTerm&gt;&lt;/ccts:Component&gt;
     * </pre>
     * Gets the value of the shipment property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipment property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getShipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipmentType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipmentType> getShipment() {
        if (shipment == null) {
            shipment = new ArrayList<ShipmentType>();
        }
        return this.shipment;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ReceiptLineType rhs = ((ReceiptLineType) o);
        if (!EqualsHelper.equalsCollection(despatchLineReference, rhs.despatchLineReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(documentReference, rhs.documentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(item, rhs.item)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(orderLineReference, rhs.orderLineReference)) {
            return false;
        }
        if (!EqualsHelper.equals(oversupplyQuantity, rhs.oversupplyQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(quantityDiscrepancyCode, rhs.quantityDiscrepancyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedDate, rhs.receivedDate)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedQuantity, rhs.receivedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(rejectActionCode, rhs.rejectActionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(rejectReason, rhs.rejectReason)) {
            return false;
        }
        if (!EqualsHelper.equals(rejectReasonCode, rhs.rejectReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(rejectedQuantity, rhs.rejectedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipment, rhs.shipment)) {
            return false;
        }
        if (!EqualsHelper.equals(shortQuantity, rhs.shortQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(shortageActionCode, rhs.shortageActionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(timingComplaint, rhs.timingComplaint)) {
            return false;
        }
        if (!EqualsHelper.equals(timingComplaintCode, rhs.timingComplaintCode)) {
            return false;
        }
        if (!EqualsHelper.equals(uuid, rhs.uuid)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(despatchLineReference).append(documentReference).append(id).append(item).append(note).append(orderLineReference).append(oversupplyQuantity).append(quantityDiscrepancyCode).append(receivedDate).append(receivedQuantity).append(rejectActionCode).append(rejectReason).append(rejectReasonCode).append(rejectedQuantity).append(shipment).append(shortQuantity).append(shortageActionCode).append(timingComplaint).append(timingComplaintCode).append(uuid).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("despatchLineReference", despatchLineReference).append("documentReference", documentReference).append("id", id).append("item", item).append("note", note).append("orderLineReference", orderLineReference).append("oversupplyQuantity", oversupplyQuantity).append("quantityDiscrepancyCode", quantityDiscrepancyCode).append("receivedDate", receivedDate).append("receivedQuantity", receivedQuantity).append("rejectActionCode", rejectActionCode).append("rejectReason", rejectReason).append("rejectReasonCode", rejectReasonCode).append("rejectedQuantity", rejectedQuantity).append("shipment", shipment).append("shortQuantity", shortQuantity).append("shortageActionCode", shortageActionCode).append("timingComplaint", timingComplaint).append("timingComplaintCode", timingComplaintCode).append("uuid", uuid).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRejectReason(
        @Nullable
        final List<RejectReasonType> aList) {
        rejectReason = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDespatchLineReference(
        @Nullable
        final List<LineReferenceType> aList) {
        despatchLineReference = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        documentReference = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItem(
        @Nullable
        final List<ItemType> aList) {
        item = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipment(
        @Nullable
        final List<ShipmentType> aList) {
        shipment = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRejectReasonEntries() {
        return (!getRejectReason().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRejectReasonEntries() {
        return getRejectReason().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRejectReasonCount() {
        return getRejectReason().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RejectReasonType getRejectReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRejectReason().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRejectReason(
        @Nonnull
        final RejectReasonType elem) {
        getRejectReason().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDespatchLineReferenceEntries() {
        return (!getDespatchLineReference().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDespatchLineReferenceEntries() {
        return getDespatchLineReference().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDespatchLineReferenceCount() {
        return getDespatchLineReference().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LineReferenceType getDespatchLineReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDespatchLineReference().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDespatchLineReference(
        @Nonnull
        final LineReferenceType elem) {
        getDespatchLineReference().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDocumentReferenceEntries() {
        return (!getDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDocumentReferenceEntries() {
        return getDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDocumentReferenceCount() {
        return getDocumentReference().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemEntries() {
        return (!getItem().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemEntries() {
        return getItem().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemCount() {
        return getItem().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemType getItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItem().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItem(
        @Nonnull
        final ItemType elem) {
        getItem().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipmentEntries() {
        return (!getShipment().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipmentEntries() {
        return getShipment().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipmentCount() {
        return getShipment().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipmentType getShipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipment().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipment(
        @Nonnull
        final ShipmentType elem) {
        getShipment().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ReceiptLineType ret) {
        if (despatchLineReference == null) {
            ret.despatchLineReference = null;
        } else {
            List<LineReferenceType> retDespatchLineReference = new ArrayList<LineReferenceType>();
            for (LineReferenceType aItem: getDespatchLineReference()) {
                retDespatchLineReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.despatchLineReference = retDespatchLineReference;
        }
        if (documentReference == null) {
            ret.documentReference = null;
        } else {
            List<DocumentReferenceType> retDocumentReference = new ArrayList<DocumentReferenceType>();
            for (DocumentReferenceType aItem: getDocumentReference()) {
                retDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.documentReference = retDocumentReference;
        }
        ret.id = ((id == null)?null:id.clone());
        if (item == null) {
            ret.item = null;
        } else {
            List<ItemType> retItem = new ArrayList<ItemType>();
            for (ItemType aItem: getItem()) {
                retItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.item = retItem;
        }
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<NoteType>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        ret.orderLineReference = ((orderLineReference == null)?null:orderLineReference.clone());
        ret.oversupplyQuantity = ((oversupplyQuantity == null)?null:oversupplyQuantity.clone());
        ret.quantityDiscrepancyCode = ((quantityDiscrepancyCode == null)?null:quantityDiscrepancyCode.clone());
        ret.receivedDate = ((receivedDate == null)?null:receivedDate.clone());
        ret.receivedQuantity = ((receivedQuantity == null)?null:receivedQuantity.clone());
        ret.rejectActionCode = ((rejectActionCode == null)?null:rejectActionCode.clone());
        if (rejectReason == null) {
            ret.rejectReason = null;
        } else {
            List<RejectReasonType> retRejectReason = new ArrayList<RejectReasonType>();
            for (RejectReasonType aItem: getRejectReason()) {
                retRejectReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.rejectReason = retRejectReason;
        }
        ret.rejectReasonCode = ((rejectReasonCode == null)?null:rejectReasonCode.clone());
        ret.rejectedQuantity = ((rejectedQuantity == null)?null:rejectedQuantity.clone());
        if (shipment == null) {
            ret.shipment = null;
        } else {
            List<ShipmentType> retShipment = new ArrayList<ShipmentType>();
            for (ShipmentType aItem: getShipment()) {
                retShipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipment = retShipment;
        }
        ret.shortQuantity = ((shortQuantity == null)?null:shortQuantity.clone());
        ret.shortageActionCode = ((shortageActionCode == null)?null:shortageActionCode.clone());
        ret.timingComplaint = ((timingComplaint == null)?null:timingComplaint.clone());
        ret.timingComplaintCode = ((timingComplaintCode == null)?null:timingComplaintCode.clone());
        ret.uuid = ((uuid == null)?null:uuid.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ReceiptLineType clone() {
        ReceiptLineType ret = new ReceiptLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShortageActionCodeType and never <code>null</code>
     */
    @Nonnull
    public ShortageActionCodeType setShortageActionCode(
        @Nullable
        final String valueParam) {
        ShortageActionCodeType aObj = getShortageActionCode();
        if (aObj == null) {
            aObj = new ShortageActionCodeType(valueParam);
            setShortageActionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RejectReasonCodeType and never <code>null</code>
     */
    @Nonnull
    public RejectReasonCodeType setRejectReasonCode(
        @Nullable
        final String valueParam) {
        RejectReasonCodeType aObj = getRejectReasonCode();
        if (aObj == null) {
            aObj = new RejectReasonCodeType(valueParam);
            setRejectReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RejectActionCodeType and never <code>null</code>
     */
    @Nonnull
    public RejectActionCodeType setRejectActionCode(
        @Nullable
        final String valueParam) {
        RejectActionCodeType aObj = getRejectActionCode();
        if (aObj == null) {
            aObj = new RejectActionCodeType(valueParam);
            setRejectActionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityDiscrepancyCodeType and never <code>null</code>
     */
    @Nonnull
    public QuantityDiscrepancyCodeType setQuantityDiscrepancyCode(
        @Nullable
        final String valueParam) {
        QuantityDiscrepancyCodeType aObj = getQuantityDiscrepancyCode();
        if (aObj == null) {
            aObj = new QuantityDiscrepancyCodeType(valueParam);
            setQuantityDiscrepancyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimingComplaintCodeType and never <code>null</code>
     */
    @Nonnull
    public TimingComplaintCodeType setTimingComplaintCode(
        @Nullable
        final String valueParam) {
        TimingComplaintCodeType aObj = getTimingComplaintCode();
        if (aObj == null) {
            aObj = new TimingComplaintCodeType(valueParam);
            setTimingComplaintCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedDateType and never <code>null</code>
     */
    @Nonnull
    public ReceivedDateType setReceivedDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ReceivedDateType aObj = getReceivedDate();
        if (aObj == null) {
            aObj = new ReceivedDateType(valueParam);
            setReceivedDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedDateType and never <code>null</code>
     */
    @Nonnull
    public ReceivedDateType setReceivedDate(
        @Nullable
        final LocalDate valueParam) {
        ReceivedDateType aObj = getReceivedDate();
        if (aObj == null) {
            aObj = new ReceivedDateType(valueParam);
            setReceivedDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UUIDType and never <code>null</code>
     */
    @Nonnull
    public UUIDType setUUID(
        @Nullable
        final String valueParam) {
        UUIDType aObj = getUUID();
        if (aObj == null) {
            aObj = new UUIDType(valueParam);
            setUUID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedQuantityType and never <code>null</code>
     */
    @Nonnull
    public ReceivedQuantityType setReceivedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ReceivedQuantityType aObj = getReceivedQuantity();
        if (aObj == null) {
            aObj = new ReceivedQuantityType(valueParam);
            setReceivedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShortQuantityType and never <code>null</code>
     */
    @Nonnull
    public ShortQuantityType setShortQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ShortQuantityType aObj = getShortQuantity();
        if (aObj == null) {
            aObj = new ShortQuantityType(valueParam);
            setShortQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RejectedQuantityType and never <code>null</code>
     */
    @Nonnull
    public RejectedQuantityType setRejectedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        RejectedQuantityType aObj = getRejectedQuantity();
        if (aObj == null) {
            aObj = new RejectedQuantityType(valueParam);
            setRejectedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OversupplyQuantityType and never <code>null</code>
     */
    @Nonnull
    public OversupplyQuantityType setOversupplyQuantity(
        @Nullable
        final BigDecimal valueParam) {
        OversupplyQuantityType aObj = getOversupplyQuantity();
        if (aObj == null) {
            aObj = new OversupplyQuantityType(valueParam);
            setOversupplyQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimingComplaintType and never <code>null</code>
     */
    @Nonnull
    public TimingComplaintType setTimingComplaint(
        @Nullable
        final String valueParam) {
        TimingComplaintType aObj = getTimingComplaint();
        if (aObj == null) {
            aObj = new TimingComplaintType(valueParam);
            setTimingComplaint(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UUIDType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UUIDType object or <code>null</code>
     */
    @Nullable
    public String getUUIDValue() {
        UUIDType aObj = getUUID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedQuantityType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getReceivedQuantityValue() {
        ReceivedQuantityType aObj = getReceivedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShortQuantityType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShortQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getShortQuantityValue() {
        ShortQuantityType aObj = getShortQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShortageActionCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShortageActionCodeType object or <code>null</code>
     */
    @Nullable
    public String getShortageActionCodeValue() {
        ShortageActionCodeType aObj = getShortageActionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RejectedQuantityType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RejectedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRejectedQuantityValue() {
        RejectedQuantityType aObj = getRejectedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RejectReasonCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RejectReasonCodeType object or <code>null</code>
     */
    @Nullable
    public String getRejectReasonCodeValue() {
        RejectReasonCodeType aObj = getRejectReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RejectActionCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RejectActionCodeType object or <code>null</code>
     */
    @Nullable
    public String getRejectActionCodeValue() {
        RejectActionCodeType aObj = getRejectActionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityDiscrepancyCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityDiscrepancyCodeType object or <code>null</code>
     */
    @Nullable
    public String getQuantityDiscrepancyCodeValue() {
        QuantityDiscrepancyCodeType aObj = getQuantityDiscrepancyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OversupplyQuantityType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OversupplyQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getOversupplyQuantityValue() {
        OversupplyQuantityType aObj = getOversupplyQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getReceivedDateValue() {
        ReceivedDateType aObj = getReceivedDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getReceivedDateValueLocal() {
        ReceivedDateType aObj = getReceivedDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained TimingComplaintCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimingComplaintCodeType object or <code>null</code>
     */
    @Nullable
    public String getTimingComplaintCodeValue() {
        TimingComplaintCodeType aObj = getTimingComplaintCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TimingComplaintType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimingComplaintType object or <code>null</code>
     */
    @Nullable
    public String getTimingComplaintValue() {
        TimingComplaintType aObj = getTimingComplaint();
        return (aObj == null)?null:aObj.getValue();
    }

}
