/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ublpe;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.ublpe.EUBLPEDocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBLPEDocumentTypes {
    private static final ICommonsMap<String, EUBLPEDocumentType> s_aLocalName2DocType = new CommonsHashMap();
    private static final UBLPEDocumentTypes s_aInstance;

    private UBLPEDocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return s_aLocalName2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBLPEDocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EUBLPEDocumentType)((Object)s_aLocalName2DocType.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBLPEDocumentType eUBLPEDocumentType = UBLPEDocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBLPEDocumentType == null ? null : eUBLPEDocumentType.getImplementationClass();
    }

    @Nullable
    public static EUBLPEDocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return (EUBLPEDocumentType)((Object)ArrayHelper.findFirst((Object[])EUBLPEDocumentType.values(), eUBLPEDocumentType -> eUBLPEDocumentType.getImplementationClass().equals(clazz)));
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBLPEDocumentType eUBLPEDocumentType = UBLPEDocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBLPEDocumentType == null ? null : eUBLPEDocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EUBLPEDocumentType eUBLPEDocumentType = UBLPEDocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eUBLPEDocumentType == null ? null : eUBLPEDocumentType.getSchema();
    }

    static {
        for (EUBLPEDocumentType eUBLPEDocumentType : EUBLPEDocumentType.values()) {
            String string = eUBLPEDocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey((Object)string)) {
                throw new IllegalArgumentException("The local name '" + string + "' is already mapped!");
            }
            s_aLocalName2DocType.put((Object)string, (Object)eUBLPEDocumentType);
        }
        s_aInstance = new UBLPEDocumentTypes();
    }
}

