
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.CodeType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DictionaryEntryName xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;AccessCredential. Details&lt;/ccts:DictionaryEntryName&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Contains a&#13;
 * 					password or other token associated with the authentication of a user. &lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;This is&#13;
 * 					typically used in pre-provisioning a partner system with user account&#13;
 * 					information rather than in actual authentication processes (in which case the&#13;
 * 					appropriate token would typically be passed in a SOAP security header). Where&#13;
 * 					used, this components generally would be repeatable to allow for multiple&#13;
 * 					credentials or tokens. This also would generally be used in a context in which a&#13;
 * 					UserID was supplied. See UserID-element. See UserAccount-noun.&lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * 
 * <p>Java class for AccessCredentialType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AccessCredentialType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}AccessCredentialTypeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}AccessCredentialValue" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserArea" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AccessCredentialType", propOrder = {
    "accessCredentialTypeCode",
    "accessCredentialValue",
    "userArea"
})
@CodingStyleguideUnaware
public class AccessCredentialType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "AccessCredentialTypeCode")
    private CodeType accessCredentialTypeCode;
    @XmlElement(name = "AccessCredentialValue")
    private String accessCredentialValue;
    @XmlElement(name = "UserArea")
    private UserAreaType userArea;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AccessCredentialType() {
    }

    /**
     * Gets the value of the accessCredentialTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getAccessCredentialTypeCode() {
        return accessCredentialTypeCode;
    }

    /**
     * Sets the value of the accessCredentialTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setAccessCredentialTypeCode(
        @Nullable
        CodeType value) {
        this.accessCredentialTypeCode = value;
    }

    /**
     * Gets the value of the accessCredentialValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAccessCredentialValue() {
        return accessCredentialValue;
    }

    /**
     * Sets the value of the accessCredentialValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAccessCredentialValue(
        @Nullable
        String value) {
        this.accessCredentialValue = value;
    }

    /**
     * Gets the value of the userArea property.
     * 
     * @return
     *     possible object is
     *     {@link UserAreaType }
     *     
     */
    @Nullable
    public UserAreaType getUserArea() {
        return userArea;
    }

    /**
     * Sets the value of the userArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link UserAreaType }
     *     
     */
    public void setUserArea(
        @Nullable
        UserAreaType value) {
        this.userArea = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AccessCredentialType rhs = ((AccessCredentialType) o);
        if (!EqualsHelper.equals(accessCredentialTypeCode, rhs.accessCredentialTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(accessCredentialValue, rhs.accessCredentialValue)) {
            return false;
        }
        if (!EqualsHelper.equals(userArea, rhs.userArea)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(accessCredentialTypeCode).append(accessCredentialValue).append(userArea).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("accessCredentialTypeCode", accessCredentialTypeCode).append("accessCredentialValue", accessCredentialValue).append("userArea", userArea).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AccessCredentialType ret) {
        ret.accessCredentialTypeCode = ((accessCredentialTypeCode == null)?null:accessCredentialTypeCode.clone());
        ret.accessCredentialValue = accessCredentialValue;
        ret.userArea = ((userArea == null)?null:userArea.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public AccessCredentialType clone() {
        AccessCredentialType ret = new AccessCredentialType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setAccessCredentialTypeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getAccessCredentialTypeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setAccessCredentialTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getAccessCredentialTypeCodeValue() {
        CodeType aObj = getAccessCredentialTypeCode();
        return ((aObj == null)?null:aObj.getValue());
    }

}
