
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.TextType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;This&#13;
 * 					flexibly allows capture of information about a variety of communication channels&#13;
 * 					(telephone, email, fax, messaging, address, etc.). CommunicationABIEType is&#13;
 * 					logically derived from UN/CEFACT TBG17 ABIE CommunicationType as defined in the&#13;
 * 					Reusable Aggregate Business Information Entity (RUABIE) XML Schema file. Note&#13;
 * 					this version has been modified to meet HR Industry requirments. 1. Includes&#13;
 * 					effective dating attributes. 2. Preference, sequence, and effective dating are&#13;
 * 					handled in attributes rather than element. 3. Address based on OAGIS Address&#13;
 * 					type with exceptions: includes effective dating and current Indicator; uses HR&#13;
 * 					country code list. 4. Uses HR code lists for ChannelCode and UseCode. &lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Various uses&#13;
 * 					and options are supported. Note that Communication allows the capture of an&#13;
 * 					Address as a communication type. Note that not every use of Address is a&#13;
 * 					communication. For example, Residence Address and Domicle Address have uses in&#13;
 * 					the context of payroll tax calculation, benefits plan eligibility determination,&#13;
 * 					and employment screening that are distinct from usage of an address as a&#13;
 * 					communication means. IIn this case, the Address 'type' attribute would specify&#13;
 * 					the address as Residence or Domicile.&lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Residence&#13;
 * 					definition: The place of a person's general abode. A person's actual dwelling&#13;
 * 					place in fact. This may be a temporary residence or a long-term residence.&#13;
 * 					Residence Address is often a legal or official address for purposes of&#13;
 * 					determinations such as work eligibility, applicable payroll taxes, and benefits&#13;
 * 					program eligibility. This also is an address of of importance to processes such&#13;
 * 					as employment screening that make use of residence history to direct the scope&#13;
 * 					of screenings that may be conducted. &lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Domicile&#13;
 * 					definition: Black's Law Dictionary, Sixth Edition: "A person's legal home. That&#13;
 * 					place where a man has his true, fixed, and permanent home and principal&#13;
 * 					establishment, and to which whenever he is absent he has the intention of&#13;
 * 					returning (emphasis added)(Smith v. Smith, 206 Pa. Super. 310). A person may&#13;
 * 					have more than one residence but only one domicile. The legal domicile of a&#13;
 * 					person is important since it, rather than the actual residence, often controls&#13;
 * 					the jurisdiction of the taxing authorities and determines where a person may&#13;
 * 					exercise the privilege of voting and other legal rights and privileges." OED:&#13;
 * 					Domicile n. 2. Law. The place where one has his home or permanent residence, to&#13;
 * 					which, if absent, he has the intention of returning. In some cases Domicile&#13;
 * 					Address may be deterimined by, and have significance with repect to,&#13;
 * 					determinations of applicable taxes or tax reportin.&lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Formatted&#13;
 * 					telephone numbers should use the DialNumber element.&lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * 
 * <p>Java class for CommunicationABIEType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="CommunicationABIEType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}ChannelCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UseCode" minOccurs="0"/&gt;
 *         &lt;choice&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}CountryDialing" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}AreaDialing" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}DialNumber" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}Extension" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}Access" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;element ref="{http://www.hr-xml.org/3}Address" minOccurs="0"/&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}URI" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}HTMLPreferredIndicator" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;element ref="{http://www.openapplications.org/oagis/9}Text" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;/choice&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserArea" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{http://www.hr-xml.org/3}EffectiveDateAttributeGroup"/&gt;
 *       &lt;attribute name="sequence" type="{http://www.openapplications.org/oagis/9}PositiveIntegerNumericType" /&gt;
 *       &lt;attribute name="preferredIndicator" type="{http://www.openapplications.org/oagis/9}IndicatorType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CommunicationABIEType", propOrder = {
    "channelCode",
    "useCode",
    "countryDialing",
    "areaDialing",
    "dialNumber",
    "extension",
    "access",
    "address",
    "uri",
    "htmlPreferredIndicator",
    "text",
    "userArea"
})
@CodingStyleguideUnaware
public class CommunicationABIEType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ChannelCode")
    private ChannelCodeType channelCode;
    @XmlElement(name = "UseCode")
    private UseCodeType useCode;
    @XmlElement(name = "CountryDialing", namespace = "http://www.openapplications.org/oagis/9")
    private TextType countryDialing;
    @XmlElement(name = "AreaDialing", namespace = "http://www.openapplications.org/oagis/9")
    private TextType areaDialing;
    @XmlElement(name = "DialNumber", namespace = "http://www.openapplications.org/oagis/9")
    private TextType dialNumber;
    @XmlElement(name = "Extension", namespace = "http://www.openapplications.org/oagis/9")
    private TextType extension;
    @XmlElement(name = "Access", namespace = "http://www.openapplications.org/oagis/9")
    private TextType access;
    @XmlElement(name = "Address")
    private AddressType address;
    @XmlElement(name = "URI", namespace = "http://www.openapplications.org/oagis/9")
    @XmlSchemaType(name = "anyURI")
    private String uri;
    @XmlElement(name = "HTMLPreferredIndicator", namespace = "http://www.openapplications.org/oagis/9")
    private Boolean htmlPreferredIndicator;
    @XmlElement(name = "Text", namespace = "http://www.openapplications.org/oagis/9")
    private List<TextType> text;
    @XmlElement(name = "UserArea")
    private UserAreaType userArea;
    @XmlAttribute(name = "sequence")
    private BigInteger sequence;
    @XmlAttribute(name = "preferredIndicator")
    private Boolean preferredIndicator;
    @XmlAttribute(name = "validFrom")
    private List<String> validFrom;
    @XmlAttribute(name = "validTo")
    private List<String> validTo;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CommunicationABIEType() {
    }

    /**
     * Gets the value of the channelCode property.
     * 
     * @return
     *     possible object is
     *     {@link ChannelCodeType }
     *     
     */
    @Nullable
    public ChannelCodeType getChannelCode() {
        return channelCode;
    }

    /**
     * Sets the value of the channelCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ChannelCodeType }
     *     
     */
    public void setChannelCode(
        @Nullable
        ChannelCodeType value) {
        this.channelCode = value;
    }

    /**
     * Gets the value of the useCode property.
     * 
     * @return
     *     possible object is
     *     {@link UseCodeType }
     *     
     */
    @Nullable
    public UseCodeType getUseCode() {
        return useCode;
    }

    /**
     * Sets the value of the useCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link UseCodeType }
     *     
     */
    public void setUseCode(
        @Nullable
        UseCodeType value) {
        this.useCode = value;
    }

    /**
     * Gets the value of the countryDialing property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getCountryDialing() {
        return countryDialing;
    }

    /**
     * Sets the value of the countryDialing property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setCountryDialing(
        @Nullable
        TextType value) {
        this.countryDialing = value;
    }

    /**
     * Gets the value of the areaDialing property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getAreaDialing() {
        return areaDialing;
    }

    /**
     * Sets the value of the areaDialing property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setAreaDialing(
        @Nullable
        TextType value) {
        this.areaDialing = value;
    }

    /**
     * Gets the value of the dialNumber property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getDialNumber() {
        return dialNumber;
    }

    /**
     * Sets the value of the dialNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setDialNumber(
        @Nullable
        TextType value) {
        this.dialNumber = value;
    }

    /**
     * Gets the value of the extension property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getExtension() {
        return extension;
    }

    /**
     * Sets the value of the extension property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setExtension(
        @Nullable
        TextType value) {
        this.extension = value;
    }

    /**
     * Gets the value of the access property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getAccess() {
        return access;
    }

    /**
     * Sets the value of the access property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setAccess(
        @Nullable
        TextType value) {
        this.access = value;
    }

    /**
     * Gets the value of the address property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getAddress() {
        return address;
    }

    /**
     * Sets the value of the address property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setAddress(
        @Nullable
        AddressType value) {
        this.address = value;
    }

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getURI() {
        return uri;
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setURI(
        @Nullable
        String value) {
        this.uri = value;
    }

    /**
     * Gets the value of the htmlPreferredIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isHTMLPreferredIndicator() {
        return htmlPreferredIndicator;
    }

    /**
     * Sets the value of the htmlPreferredIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setHTMLPreferredIndicator(
        @Nullable
        Boolean value) {
        this.htmlPreferredIndicator = value;
    }

    /**
     * Gets the value of the text property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the text property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getText().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getText() {
        if (text == null) {
            text = new ArrayList<TextType>();
        }
        return this.text;
    }

    /**
     * Gets the value of the userArea property.
     * 
     * @return
     *     possible object is
     *     {@link UserAreaType }
     *     
     */
    @Nullable
    public UserAreaType getUserArea() {
        return userArea;
    }

    /**
     * Sets the value of the userArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link UserAreaType }
     *     
     */
    public void setUserArea(
        @Nullable
        UserAreaType value) {
        this.userArea = value;
    }

    /**
     * Gets the value of the sequence property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getSequence() {
        return sequence;
    }

    /**
     * Sets the value of the sequence property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setSequence(
        @Nullable
        BigInteger value) {
        this.sequence = value;
    }

    /**
     * Gets the value of the preferredIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isPreferredIndicator() {
        return preferredIndicator;
    }

    /**
     * Sets the value of the preferredIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPreferredIndicator(
        @Nullable
        Boolean value) {
        this.preferredIndicator = value;
    }

    /**
     * Gets the value of the validFrom property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validFrom property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidFrom().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getValidFrom() {
        if (validFrom == null) {
            validFrom = new ArrayList<String>();
        }
        return this.validFrom;
    }

    /**
     * Gets the value of the validTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getValidTo() {
        if (validTo == null) {
            validTo = new ArrayList<String>();
        }
        return this.validTo;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final CommunicationABIEType rhs = ((CommunicationABIEType) o);
        if (!EqualsHelper.equals(access, rhs.access)) {
            return false;
        }
        if (!EqualsHelper.equals(address, rhs.address)) {
            return false;
        }
        if (!EqualsHelper.equals(areaDialing, rhs.areaDialing)) {
            return false;
        }
        if (!EqualsHelper.equals(channelCode, rhs.channelCode)) {
            return false;
        }
        if (!EqualsHelper.equals(countryDialing, rhs.countryDialing)) {
            return false;
        }
        if (!EqualsHelper.equals(dialNumber, rhs.dialNumber)) {
            return false;
        }
        if (!EqualsHelper.equals(extension, rhs.extension)) {
            return false;
        }
        if (!EqualsHelper.equals(htmlPreferredIndicator, rhs.htmlPreferredIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(preferredIndicator, rhs.preferredIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(sequence, rhs.sequence)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(text, rhs.text)) {
            return false;
        }
        if (!EqualsHelper.equals(uri, rhs.uri)) {
            return false;
        }
        if (!EqualsHelper.equals(useCode, rhs.useCode)) {
            return false;
        }
        if (!EqualsHelper.equals(userArea, rhs.userArea)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(validFrom, rhs.validFrom)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(validTo, rhs.validTo)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(access).append(address).append(areaDialing).append(channelCode).append(countryDialing).append(dialNumber).append(extension).append(htmlPreferredIndicator).append(preferredIndicator).append(sequence).append(text).append(uri).append(useCode).append(userArea).append(validFrom).append(validTo).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("access", access).append("address", address).append("areaDialing", areaDialing).append("channelCode", channelCode).append("countryDialing", countryDialing).append("dialNumber", dialNumber).append("extension", extension).append("htmlPreferredIndicator", htmlPreferredIndicator).append("preferredIndicator", preferredIndicator).append("sequence", sequence).append("text", text).append("uri", uri).append("useCode", useCode).append("userArea", userArea).append("validFrom", validFrom).append("validTo", validTo).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setText(
        @Nullable
        final List<TextType> aList) {
        text = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValidFrom(
        @Nullable
        final List<String> aList) {
        validFrom = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValidTo(
        @Nullable
        final List<String> aList) {
        validTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTextEntries() {
        return (!getText().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTextEntries() {
        return getText().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTextCount() {
        return getText().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getTextAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getText().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addText(
        @Nonnull
        final TextType elem) {
        getText().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValidFromEntries() {
        return (!getValidFrom().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValidFromEntries() {
        return getValidFrom().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValidFromCount() {
        return getValidFrom().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getValidFromAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValidFrom().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValidFrom(
        @Nonnull
        final String elem) {
        getValidFrom().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValidToEntries() {
        return (!getValidTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValidToEntries() {
        return getValidTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValidToCount() {
        return getValidTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getValidToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValidTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValidTo(
        @Nonnull
        final String elem) {
        getValidTo().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CommunicationABIEType ret) {
        ret.access = ((access == null)?null:access.clone());
        ret.address = ((address == null)?null:address.clone());
        ret.areaDialing = ((areaDialing == null)?null:areaDialing.clone());
        ret.channelCode = ((channelCode == null)?null:channelCode.clone());
        ret.countryDialing = ((countryDialing == null)?null:countryDialing.clone());
        ret.dialNumber = ((dialNumber == null)?null:dialNumber.clone());
        ret.extension = ((extension == null)?null:extension.clone());
        ret.htmlPreferredIndicator = htmlPreferredIndicator;
        ret.preferredIndicator = preferredIndicator;
        ret.sequence = sequence;
        if (text == null) {
            ret.text = null;
        } else {
            List<TextType> retText = new ArrayList<TextType>();
            for (TextType aItem: getText()) {
                retText.add(((aItem == null)?null:aItem.clone()));
            }
            ret.text = retText;
        }
        ret.uri = uri;
        ret.useCode = ((useCode == null)?null:useCode.clone());
        ret.userArea = ((userArea == null)?null:userArea.clone());
        if (validFrom == null) {
            ret.validFrom = null;
        } else {
            List<String> retValidFrom = new ArrayList<String>();
            for (String aItem: getValidFrom()) {
                retValidFrom.add(aItem);
            }
            ret.validFrom = retValidFrom;
        }
        if (validTo == null) {
            ret.validTo = null;
        } else {
            List<String> retValidTo = new ArrayList<String>();
            for (String aItem: getValidTo()) {
                retValidTo.add(aItem);
            }
            ret.validTo = retValidTo;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CommunicationABIEType clone() {
        CommunicationABIEType ret = new CommunicationABIEType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ChannelCodeType and never <code>null</code>
     */
    @Nonnull
    public ChannelCodeType setChannelCode(
        @Nullable
        final String valueParam) {
        ChannelCodeType aObj = getChannelCode();
        if (aObj == null) {
            aObj = new ChannelCodeType(valueParam);
            setChannelCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UseCodeType and never <code>null</code>
     */
    @Nonnull
    public UseCodeType setUseCode(
        @Nullable
        final String valueParam) {
        UseCodeType aObj = getUseCode();
        if (aObj == null) {
            aObj = new UseCodeType(valueParam);
            setUseCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setCountryDialing(
        @Nullable
        final String valueParam) {
        TextType aObj = getCountryDialing();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setCountryDialing(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setAreaDialing(
        @Nullable
        final String valueParam) {
        TextType aObj = getAreaDialing();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setAreaDialing(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setDialNumber(
        @Nullable
        final String valueParam) {
        TextType aObj = getDialNumber();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setDialNumber(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setExtension(
        @Nullable
        final String valueParam) {
        TextType aObj = getExtension();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setExtension(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setAccess(
        @Nullable
        final String valueParam) {
        TextType aObj = getAccess();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setAccess(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained ChannelCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ChannelCodeType object or <code>null</code>
     */
    @Nullable
    public String getChannelCodeValue() {
        ChannelCodeType aObj = getChannelCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained UseCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UseCodeType object or <code>null</code>
     */
    @Nullable
    public String getUseCodeValue() {
        UseCodeType aObj = getUseCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getCountryDialingValue() {
        TextType aObj = getCountryDialing();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getAreaDialingValue() {
        TextType aObj = getAreaDialing();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getDialNumberValue() {
        TextType aObj = getDialNumber();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getExtensionValue() {
        TextType aObj = getExtension();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getAccessValue() {
        TextType aObj = getAccess();
        return ((aObj == null)?null:aObj.getValue());
    }

}
