
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.TextType;


/**
 * <p>Java class for PersonContactType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PersonContactType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PersonID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PersonName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}RoleName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}Communication" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserArea" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="contactTypeCode" type="{http://www.openapplications.org/oagis/9}StringType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonContactType", propOrder = {
    "personID",
    "personName",
    "roleName",
    "communication",
    "userArea"
})
@CodingStyleguideUnaware
public class PersonContactType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PersonID")
    private IdentifierType personID;
    @XmlElement(name = "PersonName")
    private PersonNameType personName;
    @XmlElement(name = "RoleName")
    private List<TextType> roleName;
    @XmlElement(name = "Communication")
    private List<CommunicationABIEType> communication;
    @XmlElement(name = "UserArea")
    private UserAreaType userArea;
    @XmlAttribute(name = "contactTypeCode")
    private String contactTypeCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PersonContactType() {
    }

    /**
     * Gets the value of the personID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getPersonID() {
        return personID;
    }

    /**
     * Sets the value of the personID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setPersonID(
        @Nullable
        IdentifierType value) {
        this.personID = value;
    }

    /**
     * Gets the value of the personName property.
     * 
     * @return
     *     possible object is
     *     {@link PersonNameType }
     *     
     */
    @Nullable
    public PersonNameType getPersonName() {
        return personName;
    }

    /**
     * Sets the value of the personName property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonNameType }
     *     
     */
    public void setPersonName(
        @Nullable
        PersonNameType value) {
        this.personName = value;
    }

    /**
     * Gets the value of the roleName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the roleName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRoleName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TextType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TextType> getRoleName() {
        if (roleName == null) {
            roleName = new ArrayList<TextType>();
        }
        return this.roleName;
    }

    /**
     * Gets the value of the communication property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the communication property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCommunication().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommunicationABIEType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommunicationABIEType> getCommunication() {
        if (communication == null) {
            communication = new ArrayList<CommunicationABIEType>();
        }
        return this.communication;
    }

    /**
     * Gets the value of the userArea property.
     * 
     * @return
     *     possible object is
     *     {@link UserAreaType }
     *     
     */
    @Nullable
    public UserAreaType getUserArea() {
        return userArea;
    }

    /**
     * Sets the value of the userArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link UserAreaType }
     *     
     */
    public void setUserArea(
        @Nullable
        UserAreaType value) {
        this.userArea = value;
    }

    /**
     * Gets the value of the contactTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getContactTypeCode() {
        return contactTypeCode;
    }

    /**
     * Sets the value of the contactTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setContactTypeCode(
        @Nullable
        String value) {
        this.contactTypeCode = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PersonContactType rhs = ((PersonContactType) o);
        if (!EqualsHelper.equalsCollection(communication, rhs.communication)) {
            return false;
        }
        if (!EqualsHelper.equals(contactTypeCode, rhs.contactTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(personID, rhs.personID)) {
            return false;
        }
        if (!EqualsHelper.equals(personName, rhs.personName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(roleName, rhs.roleName)) {
            return false;
        }
        if (!EqualsHelper.equals(userArea, rhs.userArea)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(communication).append(contactTypeCode).append(personID).append(personName).append(roleName).append(userArea).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("communication", communication).append("contactTypeCode", contactTypeCode).append("personID", personID).append("personName", personName).append("roleName", roleName).append("userArea", userArea).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRoleName(
        @Nullable
        final List<TextType> aList) {
        roleName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommunication(
        @Nullable
        final List<CommunicationABIEType> aList) {
        communication = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRoleNameEntries() {
        return (!getRoleName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRoleNameEntries() {
        return getRoleName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRoleNameCount() {
        return getRoleName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TextType getRoleNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRoleName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRoleName(
        @Nonnull
        final TextType elem) {
        getRoleName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommunicationEntries() {
        return (!getCommunication().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommunicationEntries() {
        return getCommunication().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommunicationCount() {
        return getCommunication().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommunicationABIEType getCommunicationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommunication().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommunication(
        @Nonnull
        final CommunicationABIEType elem) {
        getCommunication().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PersonContactType ret) {
        if (communication == null) {
            ret.communication = null;
        } else {
            List<CommunicationABIEType> retCommunication = new ArrayList<CommunicationABIEType>();
            for (CommunicationABIEType aItem: getCommunication()) {
                retCommunication.add(((aItem == null)?null:aItem.clone()));
            }
            ret.communication = retCommunication;
        }
        ret.contactTypeCode = contactTypeCode;
        ret.personID = ((personID == null)?null:personID.clone());
        ret.personName = ((personName == null)?null:personName.clone());
        if (roleName == null) {
            ret.roleName = null;
        } else {
            List<TextType> retRoleName = new ArrayList<TextType>();
            for (TextType aItem: getRoleName()) {
                retRoleName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.roleName = retRoleName;
        }
        ret.userArea = ((userArea == null)?null:userArea.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonContactType clone() {
        PersonContactType ret = new PersonContactType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setPersonID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getPersonID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setPersonID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getPersonIDValue() {
        IdentifierType aObj = getPersonID();
        return ((aObj == null)?null:aObj.getValue());
    }

}
