
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.CodeType;
import org.openapplications.oagis._9.NameType;
import org.openapplications.oagis._9.TextType;


/**
 * <p>Java class for PersonNameBaseType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PersonNameBaseType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}FormattedName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}LegalName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}GivenName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PreferredName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}MiddleName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}FamilyName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}FormerFamilyName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PreferredSalutationCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}GenerationAffixCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}QualificationAffixCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}TitleAffixCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PersonNameInitials" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonNameBaseType", propOrder = {
    "formattedName",
    "legalName",
    "givenName",
    "preferredName",
    "middleName",
    "familyName",
    "formerFamilyName",
    "preferredSalutationCode",
    "generationAffixCode",
    "qualificationAffixCode",
    "titleAffixCode",
    "personNameInitials"
})
@XmlSeeAlso({
    PersonNameType.class,
    AlternateScriptPersonNameType.class
})
@CodingStyleguideUnaware
public class PersonNameBaseType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "FormattedName")
    private FormattedNameType formattedName;
    @XmlElement(name = "LegalName")
    private FormattedNameType legalName;
    @XmlElement(name = "GivenName", namespace = "http://www.openapplications.org/oagis/9")
    private List<NameType> givenName;
    @XmlElement(name = "PreferredName")
    private TextType preferredName;
    @XmlElement(name = "MiddleName")
    private MiddleNameType middleName;
    @XmlElement(name = "FamilyName")
    private List<FamilyNameType> familyName;
    @XmlElement(name = "FormerFamilyName")
    private FamilyNameType formerFamilyName;
    @XmlElement(name = "PreferredSalutationCode")
    private CodeType preferredSalutationCode;
    @XmlElement(name = "GenerationAffixCode")
    private CodeType generationAffixCode;
    @XmlElement(name = "QualificationAffixCode")
    private List<CodeType> qualificationAffixCode;
    @XmlElement(name = "TitleAffixCode")
    private List<CodeType> titleAffixCode;
    @XmlElement(name = "PersonNameInitials")
    private TextType personNameInitials;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PersonNameBaseType() {
    }

    /**
     * Gets the value of the formattedName property.
     * 
     * @return
     *     possible object is
     *     {@link FormattedNameType }
     *     
     */
    @Nullable
    public FormattedNameType getFormattedName() {
        return formattedName;
    }

    /**
     * Sets the value of the formattedName property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormattedNameType }
     *     
     */
    public void setFormattedName(
        @Nullable
        FormattedNameType value) {
        this.formattedName = value;
    }

    /**
     * Gets the value of the legalName property.
     * 
     * @return
     *     possible object is
     *     {@link FormattedNameType }
     *     
     */
    @Nullable
    public FormattedNameType getLegalName() {
        return legalName;
    }

    /**
     * Sets the value of the legalName property.
     * 
     * @param value
     *     allowed object is
     *     {@link FormattedNameType }
     *     
     */
    public void setLegalName(
        @Nullable
        FormattedNameType value) {
        this.legalName = value;
    }

    /**
     * Gets the value of the givenName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the givenName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGivenName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getGivenName() {
        if (givenName == null) {
            givenName = new ArrayList<NameType>();
        }
        return this.givenName;
    }

    /**
     * Gets the value of the preferredName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPreferredName() {
        return preferredName;
    }

    /**
     * Sets the value of the preferredName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPreferredName(
        @Nullable
        TextType value) {
        this.preferredName = value;
    }

    /**
     * Gets the value of the middleName property.
     * 
     * @return
     *     possible object is
     *     {@link MiddleNameType }
     *     
     */
    @Nullable
    public MiddleNameType getMiddleName() {
        return middleName;
    }

    /**
     * Sets the value of the middleName property.
     * 
     * @param value
     *     allowed object is
     *     {@link MiddleNameType }
     *     
     */
    public void setMiddleName(
        @Nullable
        MiddleNameType value) {
        this.middleName = value;
    }

    /**
     * Gets the value of the familyName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the familyName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFamilyName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FamilyNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FamilyNameType> getFamilyName() {
        if (familyName == null) {
            familyName = new ArrayList<FamilyNameType>();
        }
        return this.familyName;
    }

    /**
     * Gets the value of the formerFamilyName property.
     * 
     * @return
     *     possible object is
     *     {@link FamilyNameType }
     *     
     */
    @Nullable
    public FamilyNameType getFormerFamilyName() {
        return formerFamilyName;
    }

    /**
     * Sets the value of the formerFamilyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link FamilyNameType }
     *     
     */
    public void setFormerFamilyName(
        @Nullable
        FamilyNameType value) {
        this.formerFamilyName = value;
    }

    /**
     * Gets the value of the preferredSalutationCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getPreferredSalutationCode() {
        return preferredSalutationCode;
    }

    /**
     * Sets the value of the preferredSalutationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setPreferredSalutationCode(
        @Nullable
        CodeType value) {
        this.preferredSalutationCode = value;
    }

    /**
     * Gets the value of the generationAffixCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getGenerationAffixCode() {
        return generationAffixCode;
    }

    /**
     * Sets the value of the generationAffixCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setGenerationAffixCode(
        @Nullable
        CodeType value) {
        this.generationAffixCode = value;
    }

    /**
     * Gets the value of the qualificationAffixCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the qualificationAffixCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQualificationAffixCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getQualificationAffixCode() {
        if (qualificationAffixCode == null) {
            qualificationAffixCode = new ArrayList<CodeType>();
        }
        return this.qualificationAffixCode;
    }

    /**
     * Gets the value of the titleAffixCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the titleAffixCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTitleAffixCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getTitleAffixCode() {
        if (titleAffixCode == null) {
            titleAffixCode = new ArrayList<CodeType>();
        }
        return this.titleAffixCode;
    }

    /**
     * Gets the value of the personNameInitials property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPersonNameInitials() {
        return personNameInitials;
    }

    /**
     * Sets the value of the personNameInitials property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPersonNameInitials(
        @Nullable
        TextType value) {
        this.personNameInitials = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PersonNameBaseType rhs = ((PersonNameBaseType) o);
        if (!EqualsHelper.equalsCollection(familyName, rhs.familyName)) {
            return false;
        }
        if (!EqualsHelper.equals(formattedName, rhs.formattedName)) {
            return false;
        }
        if (!EqualsHelper.equals(formerFamilyName, rhs.formerFamilyName)) {
            return false;
        }
        if (!EqualsHelper.equals(generationAffixCode, rhs.generationAffixCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(givenName, rhs.givenName)) {
            return false;
        }
        if (!EqualsHelper.equals(legalName, rhs.legalName)) {
            return false;
        }
        if (!EqualsHelper.equals(middleName, rhs.middleName)) {
            return false;
        }
        if (!EqualsHelper.equals(personNameInitials, rhs.personNameInitials)) {
            return false;
        }
        if (!EqualsHelper.equals(preferredName, rhs.preferredName)) {
            return false;
        }
        if (!EqualsHelper.equals(preferredSalutationCode, rhs.preferredSalutationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qualificationAffixCode, rhs.qualificationAffixCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(titleAffixCode, rhs.titleAffixCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(familyName).append(formattedName).append(formerFamilyName).append(generationAffixCode).append(givenName).append(legalName).append(middleName).append(personNameInitials).append(preferredName).append(preferredSalutationCode).append(qualificationAffixCode).append(titleAffixCode).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("familyName", familyName).append("formattedName", formattedName).append("formerFamilyName", formerFamilyName).append("generationAffixCode", generationAffixCode).append("givenName", givenName).append("legalName", legalName).append("middleName", middleName).append("personNameInitials", personNameInitials).append("preferredName", preferredName).append("preferredSalutationCode", preferredSalutationCode).append("qualificationAffixCode", qualificationAffixCode).append("titleAffixCode", titleAffixCode).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGivenName(
        @Nullable
        final List<NameType> aList) {
        givenName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFamilyName(
        @Nullable
        final List<FamilyNameType> aList) {
        familyName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQualificationAffixCode(
        @Nullable
        final List<CodeType> aList) {
        qualificationAffixCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTitleAffixCode(
        @Nullable
        final List<CodeType> aList) {
        titleAffixCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGivenNameEntries() {
        return (!getGivenName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGivenNameEntries() {
        return getGivenName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGivenNameCount() {
        return getGivenName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getGivenNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGivenName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGivenName(
        @Nonnull
        final NameType elem) {
        getGivenName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFamilyNameEntries() {
        return (!getFamilyName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFamilyNameEntries() {
        return getFamilyName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFamilyNameCount() {
        return getFamilyName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FamilyNameType getFamilyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFamilyName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFamilyName(
        @Nonnull
        final FamilyNameType elem) {
        getFamilyName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQualificationAffixCodeEntries() {
        return (!getQualificationAffixCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQualificationAffixCodeEntries() {
        return getQualificationAffixCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQualificationAffixCodeCount() {
        return getQualificationAffixCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getQualificationAffixCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQualificationAffixCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQualificationAffixCode(
        @Nonnull
        final CodeType elem) {
        getQualificationAffixCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTitleAffixCodeEntries() {
        return (!getTitleAffixCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTitleAffixCodeEntries() {
        return getTitleAffixCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTitleAffixCodeCount() {
        return getTitleAffixCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getTitleAffixCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTitleAffixCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTitleAffixCode(
        @Nonnull
        final CodeType elem) {
        getTitleAffixCode().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PersonNameBaseType ret) {
        if (familyName == null) {
            ret.familyName = null;
        } else {
            List<FamilyNameType> retFamilyName = new ArrayList<FamilyNameType>();
            for (FamilyNameType aItem: getFamilyName()) {
                retFamilyName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.familyName = retFamilyName;
        }
        ret.formattedName = ((formattedName == null)?null:formattedName.clone());
        ret.formerFamilyName = ((formerFamilyName == null)?null:formerFamilyName.clone());
        ret.generationAffixCode = ((generationAffixCode == null)?null:generationAffixCode.clone());
        if (givenName == null) {
            ret.givenName = null;
        } else {
            List<NameType> retGivenName = new ArrayList<NameType>();
            for (NameType aItem: getGivenName()) {
                retGivenName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.givenName = retGivenName;
        }
        ret.legalName = ((legalName == null)?null:legalName.clone());
        ret.middleName = ((middleName == null)?null:middleName.clone());
        ret.personNameInitials = ((personNameInitials == null)?null:personNameInitials.clone());
        ret.preferredName = ((preferredName == null)?null:preferredName.clone());
        ret.preferredSalutationCode = ((preferredSalutationCode == null)?null:preferredSalutationCode.clone());
        if (qualificationAffixCode == null) {
            ret.qualificationAffixCode = null;
        } else {
            List<CodeType> retQualificationAffixCode = new ArrayList<CodeType>();
            for (CodeType aItem: getQualificationAffixCode()) {
                retQualificationAffixCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.qualificationAffixCode = retQualificationAffixCode;
        }
        if (titleAffixCode == null) {
            ret.titleAffixCode = null;
        } else {
            List<CodeType> retTitleAffixCode = new ArrayList<CodeType>();
            for (CodeType aItem: getTitleAffixCode()) {
                retTitleAffixCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.titleAffixCode = retTitleAffixCode;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonNameBaseType clone() {
        PersonNameBaseType ret = new PersonNameBaseType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setPreferredSalutationCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getPreferredSalutationCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setPreferredSalutationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setGenerationAffixCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getGenerationAffixCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setGenerationAffixCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FormattedNameType and never <code>null</code>
     */
    @Nonnull
    public FormattedNameType setFormattedName(
        @Nullable
        final String valueParam) {
        FormattedNameType aObj = getFormattedName();
        if (aObj == null) {
            aObj = new FormattedNameType(valueParam);
            setFormattedName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FormattedNameType and never <code>null</code>
     */
    @Nonnull
    public FormattedNameType setLegalName(
        @Nullable
        final String valueParam) {
        FormattedNameType aObj = getLegalName();
        if (aObj == null) {
            aObj = new FormattedNameType(valueParam);
            setLegalName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPreferredName(
        @Nullable
        final String valueParam) {
        TextType aObj = getPreferredName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPreferredName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MiddleNameType and never <code>null</code>
     */
    @Nonnull
    public MiddleNameType setMiddleName(
        @Nullable
        final String valueParam) {
        MiddleNameType aObj = getMiddleName();
        if (aObj == null) {
            aObj = new MiddleNameType(valueParam);
            setMiddleName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FamilyNameType and never <code>null</code>
     */
    @Nonnull
    public FamilyNameType setFormerFamilyName(
        @Nullable
        final String valueParam) {
        FamilyNameType aObj = getFormerFamilyName();
        if (aObj == null) {
            aObj = new FamilyNameType(valueParam);
            setFormerFamilyName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPersonNameInitials(
        @Nullable
        final String valueParam) {
        TextType aObj = getPersonNameInitials();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPersonNameInitials(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained FormattedNameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FormattedNameType object or <code>null</code>
     */
    @Nullable
    public String getFormattedNameValue() {
        FormattedNameType aObj = getFormattedName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained FormattedNameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FormattedNameType object or <code>null</code>
     */
    @Nullable
    public String getLegalNameValue() {
        FormattedNameType aObj = getLegalName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPreferredNameValue() {
        TextType aObj = getPreferredName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained MiddleNameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MiddleNameType object or <code>null</code>
     */
    @Nullable
    public String getMiddleNameValue() {
        MiddleNameType aObj = getMiddleName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained FamilyNameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FamilyNameType object or <code>null</code>
     */
    @Nullable
    public String getFormerFamilyNameValue() {
        FamilyNameType aObj = getFormerFamilyName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getPreferredSalutationCodeValue() {
        CodeType aObj = getPreferredSalutationCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getGenerationAffixCodeValue() {
        CodeType aObj = getGenerationAffixCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPersonNameInitialsValue() {
        TextType aObj = getPersonNameInitials();
        return ((aObj == null)?null:aObj.getValue());
    }

}
