
package tr.gov.efatura.useraccount;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.BusinessObjectDocumentType;


/**
 *  Used to request processing of the UserAccount noun by a receiving
 * 				application or party. UserAccount Contains a set of information used to establish
 * 				and maintain user accounts for an application or system. Process is an "Action
 * 				Verb". ActionExpression(s) represent and communicate data management instructions.
 * 				XPath is the default expression language. The actionCode attribute (Add, Change,
 * 				Delete, Replace) specifies the action to be taken by the receiver. The data entities
 * 				being managed are represented as elements of the UserAccount noun in the BOD
 * 				instance. 
 * 
 * <p>Java class for ProcessUserAccountType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ProcessUserAccountType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.openapplications.org/oagis/9}BusinessObjectDocumentType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="DataArea" type="{http://www.hr-xml.org/3}ProcessUserAccountDataAreaType"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ProcessUserAccountType", propOrder = {
    "dataArea"
})
@CodingStyleguideUnaware
public class ProcessUserAccountType
    extends BusinessObjectDocumentType
{

    @XmlElement(name = "DataArea", required = true)
    private ProcessUserAccountDataAreaType dataArea;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public ProcessUserAccountType() {
    }

    /**
     * Gets the value of the dataArea property.
     * 
     * @return
     *     possible object is
     *     {@link ProcessUserAccountDataAreaType }
     *     
     */
    @Nullable
    public ProcessUserAccountDataAreaType getDataArea() {
        return dataArea;
    }

    /**
     * Sets the value of the dataArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProcessUserAccountDataAreaType }
     *     
     */
    public void setDataArea(
        @Nullable
        ProcessUserAccountDataAreaType value) {
        this.dataArea = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final ProcessUserAccountType rhs = ((ProcessUserAccountType) o);
        if (!EqualsHelper.equals(dataArea, rhs.dataArea)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(dataArea).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("dataArea", dataArea).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ProcessUserAccountType ret) {
        super.cloneTo(ret);
        ret.dataArea = ((dataArea == null)?null:dataArea.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ProcessUserAccountType clone() {
        ProcessUserAccountType ret = new ProcessUserAccountType();
        cloneTo(ret);
        return ret;
    }

}
