
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DictionaryEntryName xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;User&#13;
 * 					Account. Details&lt;/ccts:DictionaryEntryName&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Contains a&#13;
 * 					set of information used to establish and maintain user accounts for an&#13;
 * 					application or system.&lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * 
 * <p>Java class for UserAccountType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="UserAccountType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;group ref="{http://www.hr-xml.org/3}DocumentIDGroup" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}DocumentSequence" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}VersionID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}Party" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PartyReportingIDs" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}FreeFormEffectivePeriod" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}AccessCredential" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PersonName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}Communication" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserRole" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}AuthorizedWorkScope" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}ProhibitedWorkScope" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}AccountConfiguration" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}Notification" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}GoverningAgreementID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}SecurityQuestionInformation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserArea" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{http://www.hr-xml.org/3}EffectiveDateAttributeGroup"/&gt;
 *       &lt;attribute name="languageCode" type="{http://www.hr-xml.org/3}LanguageCodeContentType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UserAccountType", propOrder = {
    "documentID",
    "alternateDocumentID",
    "documentSequence",
    "versionID",
    "party",
    "partyReportingIDs",
    "freeFormEffectivePeriod",
    "userID",
    "accessCredential",
    "personName",
    "communication",
    "userRole",
    "authorizedWorkScope",
    "prohibitedWorkScope",
    "accountConfiguration",
    "notification",
    "governingAgreementID",
    "securityQuestionInformation",
    "userArea"
})
@CodingStyleguideUnaware
public class UserAccountType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "DocumentID")
    private tr.gov.efatura.useraccount.IdentifierType documentID;
    @XmlElement(name = "AlternateDocumentID")
    private List<tr.gov.efatura.useraccount.IdentifierType> alternateDocumentID;
    @XmlElement(name = "DocumentSequence")
    @XmlSchemaType(name = "positiveInteger")
    private BigInteger documentSequence;
    @XmlElement(name = "VersionID")
    private tr.gov.efatura.useraccount.IdentifierType versionID;
    @XmlElement(name = "Party")
    private PartyType party;
    @XmlElement(name = "PartyReportingIDs")
    private List<IDSetType> partyReportingIDs;
    @XmlElement(name = "FreeFormEffectivePeriod")
    private FreeFormEffectivePeriodType freeFormEffectivePeriod;
    @XmlElement(name = "UserID")
    private tr.gov.efatura.useraccount.IdentifierType userID;
    @XmlElement(name = "AccessCredential")
    private List<AccessCredentialType> accessCredential;
    @XmlElement(name = "PersonName")
    private PersonNameType personName;
    @XmlElement(name = "Communication")
    private List<CommunicationABIEType> communication;
    @XmlElement(name = "UserRole")
    private List<UserRoleType> userRole;
    @XmlElement(name = "AuthorizedWorkScope")
    private List<WorkScopeType> authorizedWorkScope;
    @XmlElement(name = "ProhibitedWorkScope")
    private List<WorkScopeType> prohibitedWorkScope;
    @XmlElement(name = "AccountConfiguration")
    private AccountConfigurationType accountConfiguration;
    @XmlElement(name = "Notification")
    private List<NotificationType> notification;
    @XmlElement(name = "GoverningAgreementID")
    private List<org.openapplications.oagis._9.IdentifierType> governingAgreementID;
    @XmlElement(name = "SecurityQuestionInformation")
    private List<SecurityQuestionInformationType> securityQuestionInformation;
    @XmlElement(name = "UserArea")
    private UserAreaType userArea;
    @XmlAttribute(name = "languageCode")
    private String languageCode;
    @XmlAttribute(name = "validFrom")
    private List<String> validFrom;
    @XmlAttribute(name = "validTo")
    private List<String> validTo;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public UserAccountType() {
    }

    /**
     * Gets the value of the documentID property.
     * 
     * @return
     *     possible object is
     *     {@link tr.gov.efatura.useraccount.IdentifierType }
     *     
     */
    @Nullable
    public tr.gov.efatura.useraccount.IdentifierType getDocumentID() {
        return documentID;
    }

    /**
     * Sets the value of the documentID property.
     * 
     * @param value
     *     allowed object is
     *     {@link tr.gov.efatura.useraccount.IdentifierType }
     *     
     */
    public void setDocumentID(
        @Nullable
        tr.gov.efatura.useraccount.IdentifierType value) {
        this.documentID = value;
    }

    /**
     * Gets the value of the alternateDocumentID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the alternateDocumentID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternateDocumentID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link tr.gov.efatura.useraccount.IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<tr.gov.efatura.useraccount.IdentifierType> getAlternateDocumentID() {
        if (alternateDocumentID == null) {
            alternateDocumentID = new ArrayList<tr.gov.efatura.useraccount.IdentifierType>();
        }
        return this.alternateDocumentID;
    }

    /**
     * Gets the value of the documentSequence property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getDocumentSequence() {
        return documentSequence;
    }

    /**
     * Sets the value of the documentSequence property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setDocumentSequence(
        @Nullable
        BigInteger value) {
        this.documentSequence = value;
    }

    /**
     * Gets the value of the versionID property.
     * 
     * @return
     *     possible object is
     *     {@link tr.gov.efatura.useraccount.IdentifierType }
     *     
     */
    @Nullable
    public tr.gov.efatura.useraccount.IdentifierType getVersionID() {
        return versionID;
    }

    /**
     * Sets the value of the versionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link tr.gov.efatura.useraccount.IdentifierType }
     *     
     */
    public void setVersionID(
        @Nullable
        tr.gov.efatura.useraccount.IdentifierType value) {
        this.versionID = value;
    }

    /**
     * Gets the value of the party property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getParty() {
        return party;
    }

    /**
     * Sets the value of the party property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setParty(
        @Nullable
        PartyType value) {
        this.party = value;
    }

    /**
     * Gets the value of the partyReportingIDs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyReportingIDs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPartyReportingIDs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDSetType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDSetType> getPartyReportingIDs() {
        if (partyReportingIDs == null) {
            partyReportingIDs = new ArrayList<IDSetType>();
        }
        return this.partyReportingIDs;
    }

    /**
     * Gets the value of the freeFormEffectivePeriod property.
     * 
     * @return
     *     possible object is
     *     {@link FreeFormEffectivePeriodType }
     *     
     */
    @Nullable
    public FreeFormEffectivePeriodType getFreeFormEffectivePeriod() {
        return freeFormEffectivePeriod;
    }

    /**
     * Sets the value of the freeFormEffectivePeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link FreeFormEffectivePeriodType }
     *     
     */
    public void setFreeFormEffectivePeriod(
        @Nullable
        FreeFormEffectivePeriodType value) {
        this.freeFormEffectivePeriod = value;
    }

    /**
     * An identifier for the user. Usually, a person ID, such as an
     * 						employee ID.
     * 
     * @return
     *     possible object is
     *     {@link tr.gov.efatura.useraccount.IdentifierType }
     *     
     */
    @Nullable
    public tr.gov.efatura.useraccount.IdentifierType getUserID() {
        return userID;
    }

    /**
     * Sets the value of the userID property.
     * 
     * @param value
     *     allowed object is
     *     {@link tr.gov.efatura.useraccount.IdentifierType }
     *     
     */
    public void setUserID(
        @Nullable
        tr.gov.efatura.useraccount.IdentifierType value) {
        this.userID = value;
    }

    /**
     * Contains a password or other token associated with the
     * 						authentication of a user. This is used in pre-provisioning a partner system
     * 						with user account information rather than in actual authentication processes
     * 						(in which case the appropriate token would typically be passed in a SOAP
     * 						security header). This component is repeatable to allow for multiple
     * 						credentials or tokens. Gets the value of the accessCredential property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the accessCredential property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAccessCredential().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AccessCredentialType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AccessCredentialType> getAccessCredential() {
        if (accessCredential == null) {
            accessCredential = new ArrayList<AccessCredentialType>();
        }
        return this.accessCredential;
    }

    /**
     * The User's actual name.
     * 
     * @return
     *     possible object is
     *     {@link PersonNameType }
     *     
     */
    @Nullable
    public PersonNameType getPersonName() {
        return personName;
    }

    /**
     * Sets the value of the personName property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonNameType }
     *     
     */
    public void setPersonName(
        @Nullable
        PersonNameType value) {
        this.personName = value;
    }

    /**
     * Contact information related to the Users.Gets the value of the communication property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the communication property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCommunication().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommunicationABIEType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommunicationABIEType> getCommunication() {
        if (communication == null) {
            communication = new ArrayList<CommunicationABIEType>();
        }
        return this.communication;
    }

    /**
     * The designated role(s) associated with the user with regard
     * 						to the account. For example, "recruiter," "compliance officer," "HR
     * 						manager," etc.Gets the value of the userRole property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the userRole property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getUserRole().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link UserRoleType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<UserRoleType> getUserRole() {
        if (userRole == null) {
            userRole = new ArrayList<UserRoleType>();
        }
        return this.userRole;
    }

    /**
     * A user's authorized scope of work.Gets the value of the authorizedWorkScope property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the authorizedWorkScope property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAuthorizedWorkScope().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkScopeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkScopeType> getAuthorizedWorkScope() {
        if (authorizedWorkScope == null) {
            authorizedWorkScope = new ArrayList<WorkScopeType>();
        }
        return this.authorizedWorkScope;
    }

    /**
     * A prohibited scope of work for a user.Gets the value of the prohibitedWorkScope property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the prohibitedWorkScope property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getProhibitedWorkScope().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WorkScopeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WorkScopeType> getProhibitedWorkScope() {
        if (prohibitedWorkScope == null) {
            prohibitedWorkScope = new ArrayList<WorkScopeType>();
        }
        return this.prohibitedWorkScope;
    }

    /**
     * Gets the value of the accountConfiguration property.
     * 
     * @return
     *     possible object is
     *     {@link AccountConfigurationType }
     *     
     */
    @Nullable
    public AccountConfigurationType getAccountConfiguration() {
        return accountConfiguration;
    }

    /**
     * Sets the value of the accountConfiguration property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountConfigurationType }
     *     
     */
    public void setAccountConfiguration(
        @Nullable
        AccountConfigurationType value) {
        this.accountConfiguration = value;
    }

    /**
     * Gets the value of the notification property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the notification property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNotification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NotificationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NotificationType> getNotification() {
        if (notification == null) {
            notification = new ArrayList<NotificationType>();
        }
        return this.notification;
    }

    /**
     * Gets the value of the governingAgreementID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the governingAgreementID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getGoverningAgreementID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link org.openapplications.oagis._9.IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<org.openapplications.oagis._9.IdentifierType> getGoverningAgreementID() {
        if (governingAgreementID == null) {
            governingAgreementID = new ArrayList<org.openapplications.oagis._9.IdentifierType>();
        }
        return this.governingAgreementID;
    }

    /**
     * Gets the value of the securityQuestionInformation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the securityQuestionInformation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSecurityQuestionInformation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SecurityQuestionInformationType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SecurityQuestionInformationType> getSecurityQuestionInformation() {
        if (securityQuestionInformation == null) {
            securityQuestionInformation = new ArrayList<SecurityQuestionInformationType>();
        }
        return this.securityQuestionInformation;
    }

    /**
     * Gets the value of the userArea property.
     * 
     * @return
     *     possible object is
     *     {@link UserAreaType }
     *     
     */
    @Nullable
    public UserAreaType getUserArea() {
        return userArea;
    }

    /**
     * Sets the value of the userArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link UserAreaType }
     *     
     */
    public void setUserArea(
        @Nullable
        UserAreaType value) {
        this.userArea = value;
    }

    /**
     * Gets the value of the languageCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLanguageCode() {
        return languageCode;
    }

    /**
     * Sets the value of the languageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLanguageCode(
        @Nullable
        String value) {
        this.languageCode = value;
    }

    /**
     * Gets the value of the validFrom property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validFrom property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidFrom().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getValidFrom() {
        if (validFrom == null) {
            validFrom = new ArrayList<String>();
        }
        return this.validFrom;
    }

    /**
     * Gets the value of the validTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getValidTo() {
        if (validTo == null) {
            validTo = new ArrayList<String>();
        }
        return this.validTo;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final UserAccountType rhs = ((UserAccountType) o);
        if (!EqualsHelper.equalsCollection(accessCredential, rhs.accessCredential)) {
            return false;
        }
        if (!EqualsHelper.equals(accountConfiguration, rhs.accountConfiguration)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(alternateDocumentID, rhs.alternateDocumentID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(authorizedWorkScope, rhs.authorizedWorkScope)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(communication, rhs.communication)) {
            return false;
        }
        if (!EqualsHelper.equals(documentID, rhs.documentID)) {
            return false;
        }
        if (!EqualsHelper.equals(documentSequence, rhs.documentSequence)) {
            return false;
        }
        if (!EqualsHelper.equals(freeFormEffectivePeriod, rhs.freeFormEffectivePeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(governingAgreementID, rhs.governingAgreementID)) {
            return false;
        }
        if (!EqualsHelper.equals(languageCode, rhs.languageCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(notification, rhs.notification)) {
            return false;
        }
        if (!EqualsHelper.equals(party, rhs.party)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyReportingIDs, rhs.partyReportingIDs)) {
            return false;
        }
        if (!EqualsHelper.equals(personName, rhs.personName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(prohibitedWorkScope, rhs.prohibitedWorkScope)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(securityQuestionInformation, rhs.securityQuestionInformation)) {
            return false;
        }
        if (!EqualsHelper.equals(userArea, rhs.userArea)) {
            return false;
        }
        if (!EqualsHelper.equals(userID, rhs.userID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(userRole, rhs.userRole)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(validFrom, rhs.validFrom)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(validTo, rhs.validTo)) {
            return false;
        }
        if (!EqualsHelper.equals(versionID, rhs.versionID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(accessCredential).append(accountConfiguration).append(alternateDocumentID).append(authorizedWorkScope).append(communication).append(documentID).append(documentSequence).append(freeFormEffectivePeriod).append(governingAgreementID).append(languageCode).append(notification).append(party).append(partyReportingIDs).append(personName).append(prohibitedWorkScope).append(securityQuestionInformation).append(userArea).append(userID).append(userRole).append(validFrom).append(validTo).append(versionID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("accessCredential", accessCredential).append("accountConfiguration", accountConfiguration).append("alternateDocumentID", alternateDocumentID).append("authorizedWorkScope", authorizedWorkScope).append("communication", communication).append("documentID", documentID).append("documentSequence", documentSequence).append("freeFormEffectivePeriod", freeFormEffectivePeriod).append("governingAgreementID", governingAgreementID).append("languageCode", languageCode).append("notification", notification).append("party", party).append("partyReportingIDs", partyReportingIDs).append("personName", personName).append("prohibitedWorkScope", prohibitedWorkScope).append("securityQuestionInformation", securityQuestionInformation).append("userArea", userArea).append("userID", userID).append("userRole", userRole).append("validFrom", validFrom).append("validTo", validTo).append("versionID", versionID).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAlternateDocumentID(
        @Nullable
        final List<tr.gov.efatura.useraccount.IdentifierType> aList) {
        alternateDocumentID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyReportingIDs(
        @Nullable
        final List<IDSetType> aList) {
        partyReportingIDs = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAccessCredential(
        @Nullable
        final List<AccessCredentialType> aList) {
        accessCredential = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommunication(
        @Nullable
        final List<CommunicationABIEType> aList) {
        communication = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setUserRole(
        @Nullable
        final List<UserRoleType> aList) {
        userRole = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAuthorizedWorkScope(
        @Nullable
        final List<WorkScopeType> aList) {
        authorizedWorkScope = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProhibitedWorkScope(
        @Nullable
        final List<WorkScopeType> aList) {
        prohibitedWorkScope = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNotification(
        @Nullable
        final List<NotificationType> aList) {
        notification = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGoverningAgreementID(
        @Nullable
        final List<org.openapplications.oagis._9.IdentifierType> aList) {
        governingAgreementID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSecurityQuestionInformation(
        @Nullable
        final List<SecurityQuestionInformationType> aList) {
        securityQuestionInformation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValidFrom(
        @Nullable
        final List<String> aList) {
        validFrom = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValidTo(
        @Nullable
        final List<String> aList) {
        validTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAlternateDocumentIDEntries() {
        return (!getAlternateDocumentID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAlternateDocumentIDEntries() {
        return getAlternateDocumentID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAlternateDocumentIDCount() {
        return getAlternateDocumentID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public tr.gov.efatura.useraccount.IdentifierType getAlternateDocumentIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAlternateDocumentID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAlternateDocumentID(
        @Nonnull
        final tr.gov.efatura.useraccount.IdentifierType elem) {
        getAlternateDocumentID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyReportingIDsEntries() {
        return (!getPartyReportingIDs().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyReportingIDsEntries() {
        return getPartyReportingIDs().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyReportingIDsCount() {
        return getPartyReportingIDs().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDSetType getPartyReportingIDsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyReportingIDs().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyReportingIDs(
        @Nonnull
        final IDSetType elem) {
        getPartyReportingIDs().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAccessCredentialEntries() {
        return (!getAccessCredential().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAccessCredentialEntries() {
        return getAccessCredential().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAccessCredentialCount() {
        return getAccessCredential().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AccessCredentialType getAccessCredentialAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAccessCredential().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAccessCredential(
        @Nonnull
        final AccessCredentialType elem) {
        getAccessCredential().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommunicationEntries() {
        return (!getCommunication().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommunicationEntries() {
        return getCommunication().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommunicationCount() {
        return getCommunication().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommunicationABIEType getCommunicationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommunication().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommunication(
        @Nonnull
        final CommunicationABIEType elem) {
        getCommunication().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasUserRoleEntries() {
        return (!getUserRole().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoUserRoleEntries() {
        return getUserRole().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getUserRoleCount() {
        return getUserRole().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public UserRoleType getUserRoleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getUserRole().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addUserRole(
        @Nonnull
        final UserRoleType elem) {
        getUserRole().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAuthorizedWorkScopeEntries() {
        return (!getAuthorizedWorkScope().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAuthorizedWorkScopeEntries() {
        return getAuthorizedWorkScope().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAuthorizedWorkScopeCount() {
        return getAuthorizedWorkScope().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkScopeType getAuthorizedWorkScopeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAuthorizedWorkScope().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAuthorizedWorkScope(
        @Nonnull
        final WorkScopeType elem) {
        getAuthorizedWorkScope().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProhibitedWorkScopeEntries() {
        return (!getProhibitedWorkScope().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProhibitedWorkScopeEntries() {
        return getProhibitedWorkScope().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProhibitedWorkScopeCount() {
        return getProhibitedWorkScope().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WorkScopeType getProhibitedWorkScopeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProhibitedWorkScope().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProhibitedWorkScope(
        @Nonnull
        final WorkScopeType elem) {
        getProhibitedWorkScope().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNotificationEntries() {
        return (!getNotification().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNotificationEntries() {
        return getNotification().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNotificationCount() {
        return getNotification().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NotificationType getNotificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNotification().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNotification(
        @Nonnull
        final NotificationType elem) {
        getNotification().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGoverningAgreementIDEntries() {
        return (!getGoverningAgreementID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGoverningAgreementIDEntries() {
        return getGoverningAgreementID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGoverningAgreementIDCount() {
        return getGoverningAgreementID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public org.openapplications.oagis._9.IdentifierType getGoverningAgreementIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGoverningAgreementID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGoverningAgreementID(
        @Nonnull
        final org.openapplications.oagis._9.IdentifierType elem) {
        getGoverningAgreementID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSecurityQuestionInformationEntries() {
        return (!getSecurityQuestionInformation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSecurityQuestionInformationEntries() {
        return getSecurityQuestionInformation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSecurityQuestionInformationCount() {
        return getSecurityQuestionInformation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SecurityQuestionInformationType getSecurityQuestionInformationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSecurityQuestionInformation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSecurityQuestionInformation(
        @Nonnull
        final SecurityQuestionInformationType elem) {
        getSecurityQuestionInformation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValidFromEntries() {
        return (!getValidFrom().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValidFromEntries() {
        return getValidFrom().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValidFromCount() {
        return getValidFrom().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getValidFromAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValidFrom().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValidFrom(
        @Nonnull
        final String elem) {
        getValidFrom().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValidToEntries() {
        return (!getValidTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValidToEntries() {
        return getValidTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValidToCount() {
        return getValidTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getValidToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValidTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValidTo(
        @Nonnull
        final String elem) {
        getValidTo().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        UserAccountType ret) {
        if (accessCredential == null) {
            ret.accessCredential = null;
        } else {
            List<AccessCredentialType> retAccessCredential = new ArrayList<AccessCredentialType>();
            for (AccessCredentialType aItem: getAccessCredential()) {
                retAccessCredential.add(((aItem == null)?null:aItem.clone()));
            }
            ret.accessCredential = retAccessCredential;
        }
        ret.accountConfiguration = ((accountConfiguration == null)?null:accountConfiguration.clone());
        if (alternateDocumentID == null) {
            ret.alternateDocumentID = null;
        } else {
            List<tr.gov.efatura.useraccount.IdentifierType> retAlternateDocumentID = new ArrayList<tr.gov.efatura.useraccount.IdentifierType>();
            for (tr.gov.efatura.useraccount.IdentifierType aItem: getAlternateDocumentID()) {
                retAlternateDocumentID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.alternateDocumentID = retAlternateDocumentID;
        }
        if (authorizedWorkScope == null) {
            ret.authorizedWorkScope = null;
        } else {
            List<WorkScopeType> retAuthorizedWorkScope = new ArrayList<WorkScopeType>();
            for (WorkScopeType aItem: getAuthorizedWorkScope()) {
                retAuthorizedWorkScope.add(((aItem == null)?null:aItem.clone()));
            }
            ret.authorizedWorkScope = retAuthorizedWorkScope;
        }
        if (communication == null) {
            ret.communication = null;
        } else {
            List<CommunicationABIEType> retCommunication = new ArrayList<CommunicationABIEType>();
            for (CommunicationABIEType aItem: getCommunication()) {
                retCommunication.add(((aItem == null)?null:aItem.clone()));
            }
            ret.communication = retCommunication;
        }
        ret.documentID = ((documentID == null)?null:documentID.clone());
        ret.documentSequence = documentSequence;
        ret.freeFormEffectivePeriod = ((freeFormEffectivePeriod == null)?null:freeFormEffectivePeriod.clone());
        if (governingAgreementID == null) {
            ret.governingAgreementID = null;
        } else {
            List<org.openapplications.oagis._9.IdentifierType> retGoverningAgreementID = new ArrayList<org.openapplications.oagis._9.IdentifierType>();
            for (org.openapplications.oagis._9.IdentifierType aItem: getGoverningAgreementID()) {
                retGoverningAgreementID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.governingAgreementID = retGoverningAgreementID;
        }
        ret.languageCode = languageCode;
        if (notification == null) {
            ret.notification = null;
        } else {
            List<NotificationType> retNotification = new ArrayList<NotificationType>();
            for (NotificationType aItem: getNotification()) {
                retNotification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.notification = retNotification;
        }
        ret.party = ((party == null)?null:party.clone());
        if (partyReportingIDs == null) {
            ret.partyReportingIDs = null;
        } else {
            List<IDSetType> retPartyReportingIDs = new ArrayList<IDSetType>();
            for (IDSetType aItem: getPartyReportingIDs()) {
                retPartyReportingIDs.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyReportingIDs = retPartyReportingIDs;
        }
        ret.personName = ((personName == null)?null:personName.clone());
        if (prohibitedWorkScope == null) {
            ret.prohibitedWorkScope = null;
        } else {
            List<WorkScopeType> retProhibitedWorkScope = new ArrayList<WorkScopeType>();
            for (WorkScopeType aItem: getProhibitedWorkScope()) {
                retProhibitedWorkScope.add(((aItem == null)?null:aItem.clone()));
            }
            ret.prohibitedWorkScope = retProhibitedWorkScope;
        }
        if (securityQuestionInformation == null) {
            ret.securityQuestionInformation = null;
        } else {
            List<SecurityQuestionInformationType> retSecurityQuestionInformation = new ArrayList<SecurityQuestionInformationType>();
            for (SecurityQuestionInformationType aItem: getSecurityQuestionInformation()) {
                retSecurityQuestionInformation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.securityQuestionInformation = retSecurityQuestionInformation;
        }
        ret.userArea = ((userArea == null)?null:userArea.clone());
        ret.userID = ((userID == null)?null:userID.clone());
        if (userRole == null) {
            ret.userRole = null;
        } else {
            List<UserRoleType> retUserRole = new ArrayList<UserRoleType>();
            for (UserRoleType aItem: getUserRole()) {
                retUserRole.add(((aItem == null)?null:aItem.clone()));
            }
            ret.userRole = retUserRole;
        }
        if (validFrom == null) {
            ret.validFrom = null;
        } else {
            List<String> retValidFrom = new ArrayList<String>();
            for (String aItem: getValidFrom()) {
                retValidFrom.add(aItem);
            }
            ret.validFrom = retValidFrom;
        }
        if (validTo == null) {
            ret.validTo = null;
        } else {
            List<String> retValidTo = new ArrayList<String>();
            for (String aItem: getValidTo()) {
                retValidTo.add(aItem);
            }
            ret.validTo = retValidTo;
        }
        ret.versionID = ((versionID == null)?null:versionID.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public UserAccountType clone() {
        UserAccountType ret = new UserAccountType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public tr.gov.efatura.useraccount.IdentifierType setDocumentID(
        @Nullable
        final String valueParam) {
        tr.gov.efatura.useraccount.IdentifierType aObj = getDocumentID();
        if (aObj == null) {
            aObj = new tr.gov.efatura.useraccount.IdentifierType(valueParam);
            setDocumentID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public tr.gov.efatura.useraccount.IdentifierType setVersionID(
        @Nullable
        final String valueParam) {
        tr.gov.efatura.useraccount.IdentifierType aObj = getVersionID();
        if (aObj == null) {
            aObj = new tr.gov.efatura.useraccount.IdentifierType(valueParam);
            setVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public tr.gov.efatura.useraccount.IdentifierType setUserID(
        @Nullable
        final String valueParam) {
        tr.gov.efatura.useraccount.IdentifierType aObj = getUserID();
        if (aObj == null) {
            aObj = new tr.gov.efatura.useraccount.IdentifierType(valueParam);
            setUserID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getDocumentIDValue() {
        tr.gov.efatura.useraccount.IdentifierType aObj = getDocumentID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getVersionIDValue() {
        tr.gov.efatura.useraccount.IdentifierType aObj = getVersionID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getUserIDValue() {
        tr.gov.efatura.useraccount.IdentifierType aObj = getUserID();
        return ((aObj == null)?null:aObj.getValue());
    }

}
