/*
 * Decompiled with CFR 0.152.
 */
package com.helger.ubltr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.ubltr.EUBLTRDocumentType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.validation.Schema;

@Immutable
public final class UBLTRDocumentTypes {
    private static final ICommonsMap<String, EUBLTRDocumentType> s_aLocalName2DocType = new CommonsHashMap();
    private static final UBLTRDocumentTypes s_aInstance;

    private UBLTRDocumentTypes() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllLocalNames() {
        return s_aLocalName2DocType.copyOfKeySet();
    }

    @Nullable
    public static EUBLTRDocumentType getDocumentTypeOfLocalName(@Nullable String string) {
        return (EUBLTRDocumentType)((Object)s_aLocalName2DocType.get((Object)string));
    }

    @Nullable
    public static Class<?> getImplementationClassOfLocalName(@Nullable String string) {
        EUBLTRDocumentType eUBLTRDocumentType = UBLTRDocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBLTRDocumentType == null ? null : eUBLTRDocumentType.getImplementationClass();
    }

    @Nullable
    public static EUBLTRDocumentType getDocumentTypeOfImplementationClass(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return (EUBLTRDocumentType)((Object)ArrayHelper.findFirst((Object[])EUBLTRDocumentType.values(), eUBLTRDocumentType -> eUBLTRDocumentType.getImplementationClass().equals(clazz)));
    }

    @Nullable
    public static Schema getSchemaOfLocalName(@Nullable String string) {
        EUBLTRDocumentType eUBLTRDocumentType = UBLTRDocumentTypes.getDocumentTypeOfLocalName(string);
        return eUBLTRDocumentType == null ? null : eUBLTRDocumentType.getSchema();
    }

    @Nullable
    public static Schema getSchemaOfImplementationClass(@Nullable Class<?> clazz) {
        EUBLTRDocumentType eUBLTRDocumentType = UBLTRDocumentTypes.getDocumentTypeOfImplementationClass(clazz);
        return eUBLTRDocumentType == null ? null : eUBLTRDocumentType.getSchema();
    }

    static {
        for (EUBLTRDocumentType eUBLTRDocumentType : EUBLTRDocumentType.values()) {
            String string = eUBLTRDocumentType.getLocalName();
            if (s_aLocalName2DocType.containsKey((Object)string)) {
                throw new IllegalArgumentException("The local name '" + string + "' is already mapped!");
            }
            s_aLocalName2DocType.put((Object)string, (Object)eUBLTRDocumentType);
        }
        s_aInstance = new UBLTRDocumentTypes();
    }
}

