
package org.openapplications.oagis._9;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import tr.gov.efatura.useraccount.CancelUserAccountType;
import tr.gov.efatura.useraccount.ProcessUserAccountType;


/**
 * Is the schema based inheritance for all BODs. The logical model would also include the DataArea.
 * 
 * <p>Java class for BusinessObjectDocumentType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="BusinessObjectDocumentType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}ApplicationArea"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="releaseID" use="required" type="{http://www.openapplications.org/oagis/9}NormalizedStringType" /&gt;
 *       &lt;attribute name="versionID" type="{http://www.openapplications.org/oagis/9}NormalizedStringType" /&gt;
 *       &lt;attribute name="systemEnvironmentCode" type="{http://www.openapplications.org/oagis/9}SystemEnvironmentCodeContentType" default="Production" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BusinessObjectDocumentType", propOrder = {
    "applicationArea"
})
@XmlSeeAlso({
    ProcessUserAccountType.class,
    CancelUserAccountType.class
})
@CodingStyleguideUnaware
public class BusinessObjectDocumentType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ApplicationArea", required = true)
    private ApplicationAreaType applicationArea;
    @XmlAttribute(name = "releaseID", required = true)
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    private String releaseID;
    @XmlAttribute(name = "versionID")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    private String versionID;
    @XmlAttribute(name = "systemEnvironmentCode")
    private String systemEnvironmentCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public BusinessObjectDocumentType() {
    }

    /**
     * Gets the value of the applicationArea property.
     * 
     * @return
     *     possible object is
     *     {@link ApplicationAreaType }
     *     
     */
    @Nullable
    public ApplicationAreaType getApplicationArea() {
        return applicationArea;
    }

    /**
     * Sets the value of the applicationArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link ApplicationAreaType }
     *     
     */
    public void setApplicationArea(
        @Nullable
        ApplicationAreaType value) {
        this.applicationArea = value;
    }

    /**
     * Gets the value of the releaseID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getReleaseID() {
        return releaseID;
    }

    /**
     * Sets the value of the releaseID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setReleaseID(
        @Nullable
        String value) {
        this.releaseID = value;
    }

    /**
     * Gets the value of the versionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVersionID() {
        return versionID;
    }

    /**
     * Sets the value of the versionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersionID(
        @Nullable
        String value) {
        this.versionID = value;
    }

    /**
     * Gets the value of the systemEnvironmentCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSystemEnvironmentCode() {
        if (systemEnvironmentCode == null) {
            return "Production";
        } else {
            return systemEnvironmentCode;
        }
    }

    /**
     * Sets the value of the systemEnvironmentCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSystemEnvironmentCode(
        @Nullable
        String value) {
        this.systemEnvironmentCode = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BusinessObjectDocumentType rhs = ((BusinessObjectDocumentType) o);
        if (!EqualsHelper.equals(applicationArea, rhs.applicationArea)) {
            return false;
        }
        if (!EqualsHelper.equals(releaseID, rhs.releaseID)) {
            return false;
        }
        if (!EqualsHelper.equals(systemEnvironmentCode, rhs.systemEnvironmentCode)) {
            return false;
        }
        if (!EqualsHelper.equals(versionID, rhs.versionID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(applicationArea).append(releaseID).append(systemEnvironmentCode).append(versionID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("applicationArea", applicationArea).append("releaseID", releaseID).append("systemEnvironmentCode", systemEnvironmentCode).append("versionID", versionID).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        BusinessObjectDocumentType ret) {
        ret.applicationArea = ((applicationArea == null)?null:applicationArea.clone());
        ret.releaseID = releaseID;
        ret.systemEnvironmentCode = systemEnvironmentCode;
        ret.versionID = versionID;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BusinessObjectDocumentType clone() {
        BusinessObjectDocumentType ret = new BusinessObjectDocumentType();
        cloneTo(ret);
        return ret;
    }

}
