
package org.openapplications.oagis._9;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * Identifies the sender of the given BOD instance
 * 
 * <p>Java class for SenderType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SenderType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}LogicalID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}ComponentID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}TaskID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}ReferenceID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}ConfirmationCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}AuthorizationID" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SenderType", propOrder = {
    "logicalID",
    "componentID",
    "taskID",
    "referenceID",
    "confirmationCode",
    "authorizationID"
})
@CodingStyleguideUnaware
public class SenderType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "LogicalID")
    private IdentifierType logicalID;
    @XmlElement(name = "ComponentID")
    private IdentifierType componentID;
    @XmlElement(name = "TaskID")
    private IdentifierType taskID;
    @XmlElement(name = "ReferenceID")
    private IdentifierType referenceID;
    @XmlElement(name = "ConfirmationCode")
    private ConfirmationResponseCodeType confirmationCode;
    @XmlElement(name = "AuthorizationID")
    private IdentifierType authorizationID;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public SenderType() {
    }

    /**
     * Gets the value of the logicalID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getLogicalID() {
        return logicalID;
    }

    /**
     * Sets the value of the logicalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setLogicalID(
        @Nullable
        IdentifierType value) {
        this.logicalID = value;
    }

    /**
     * Gets the value of the componentID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getComponentID() {
        return componentID;
    }

    /**
     * Sets the value of the componentID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setComponentID(
        @Nullable
        IdentifierType value) {
        this.componentID = value;
    }

    /**
     * Gets the value of the taskID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getTaskID() {
        return taskID;
    }

    /**
     * Sets the value of the taskID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setTaskID(
        @Nullable
        IdentifierType value) {
        this.taskID = value;
    }

    /**
     * Gets the value of the referenceID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getReferenceID() {
        return referenceID;
    }

    /**
     * Sets the value of the referenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setReferenceID(
        @Nullable
        IdentifierType value) {
        this.referenceID = value;
    }

    /**
     * Gets the value of the confirmationCode property.
     * 
     * @return
     *     possible object is
     *     {@link ConfirmationResponseCodeType }
     *     
     */
    @Nullable
    public ConfirmationResponseCodeType getConfirmationCode() {
        return confirmationCode;
    }

    /**
     * Sets the value of the confirmationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConfirmationResponseCodeType }
     *     
     */
    public void setConfirmationCode(
        @Nullable
        ConfirmationResponseCodeType value) {
        this.confirmationCode = value;
    }

    /**
     * Gets the value of the authorizationID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getAuthorizationID() {
        return authorizationID;
    }

    /**
     * Sets the value of the authorizationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setAuthorizationID(
        @Nullable
        IdentifierType value) {
        this.authorizationID = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SenderType rhs = ((SenderType) o);
        if (!EqualsHelper.equals(authorizationID, rhs.authorizationID)) {
            return false;
        }
        if (!EqualsHelper.equals(componentID, rhs.componentID)) {
            return false;
        }
        if (!EqualsHelper.equals(confirmationCode, rhs.confirmationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(logicalID, rhs.logicalID)) {
            return false;
        }
        if (!EqualsHelper.equals(referenceID, rhs.referenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(taskID, rhs.taskID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(authorizationID).append(componentID).append(confirmationCode).append(logicalID).append(referenceID).append(taskID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("authorizationID", authorizationID).append("componentID", componentID).append("confirmationCode", confirmationCode).append("logicalID", logicalID).append("referenceID", referenceID).append("taskID", taskID).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SenderType ret) {
        ret.authorizationID = ((authorizationID == null)?null:authorizationID.clone());
        ret.componentID = ((componentID == null)?null:componentID.clone());
        ret.confirmationCode = ((confirmationCode == null)?null:confirmationCode.clone());
        ret.logicalID = ((logicalID == null)?null:logicalID.clone());
        ret.referenceID = ((referenceID == null)?null:referenceID.clone());
        ret.taskID = ((taskID == null)?null:taskID.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SenderType clone() {
        SenderType ret = new SenderType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ConfirmationResponseCodeType and never <code>null</code>
     */
    @Nonnull
    public ConfirmationResponseCodeType setConfirmationCode(
        @Nullable
        final String valueParam) {
        ConfirmationResponseCodeType aObj = getConfirmationCode();
        if (aObj == null) {
            aObj = new ConfirmationResponseCodeType(valueParam);
            setConfirmationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setLogicalID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getLogicalID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setLogicalID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setComponentID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getComponentID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setComponentID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setTaskID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getTaskID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setTaskID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setReferenceID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getReferenceID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setReferenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setAuthorizationID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getAuthorizationID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setAuthorizationID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getLogicalIDValue() {
        IdentifierType aObj = getLogicalID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getComponentIDValue() {
        IdentifierType aObj = getComponentID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getTaskIDValue() {
        IdentifierType aObj = getTaskID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getReferenceIDValue() {
        IdentifierType aObj = getReferenceID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained ConfirmationResponseCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ConfirmationResponseCodeType object or <code>null</code>
     */
    @Nullable
    public String getConfirmationCodeValue() {
        ConfirmationResponseCodeType aObj = getConfirmationCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getAuthorizationIDValue() {
        IdentifierType aObj = getAuthorizationID();
        return ((aObj == null)?null:aObj.getValue());
    }

}
