
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.CodeType;
import org.openapplications.oagis._9.CountrySubDivisionCodeType;
import org.openapplications.oagis._9.DeliveryPointCodeType;
import org.openapplications.oagis._9.NameType;
import org.openapplications.oagis._9.PreferenceType;
import org.openapplications.oagis._9.SequencedTextType;
import org.openapplications.oagis._9.StatusType;
import org.openapplications.oagis._9.TextType;


/**
 * Address BaseType
 * 				provides the information about the address or semantic address of an associated
 * 					entity.
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Based on OAGIS AddressBaseType. Exception:CountryCode uses the HR country code&#13;
 * 					list.&lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt; Example values&#13;
 * 					are: "Residence Address" Residence Address is a primary, legal address that is&#13;
 * 					related to a party. For a person, the Home Residence Address is used by an&#13;
 * 					employer for payroll, taxation, and benefit program eligibility. "Postal&#13;
 * 					Address" Set of precise and complete information on the basis of which an item&#13;
 * 					can be forwarded and delivered to an addressee. An address will be considered a&#13;
 * 					postal address only if it is explicitly collected as such. "Delivery Address"&#13;
 * 					Delivery Address is an address which is to be used to physically deliver the&#13;
 * 					related object. "Bill To" An address to which invoices are sent. "Accounts&#13;
 * 					Recievable" An address to which payments are set. &lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * 
 * <p>Java class for AddressBaseType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AddressBaseType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}ID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}FormatCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}AttentionOfName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}CareOfName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;choice&gt;
 *           &lt;element ref="{http://www.openapplications.org/oagis/9}AddressLine" maxOccurs="unbounded" minOccurs="0"/&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}LineOne" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}LineTwo" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}LineThree" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}LineFour" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}LineFive" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *           &lt;sequence&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}BuildingNumber" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}BuildingName" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}StreetName" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}Unit" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}Floor" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}PostOfficeBox" minOccurs="0"/&gt;
 *             &lt;element ref="{http://www.openapplications.org/oagis/9}DeliveryPointCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *           &lt;/sequence&gt;
 *         &lt;/choice&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}CitySubDivisionName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}CityName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}CountrySubDivisionCode" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}CountryCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}PostalCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}Status" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.openapplications.org/oagis/9}Preference" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="languageCode" type="{http://www.hr-xml.org/3}LanguageCodeContentType" /&gt;
 *       &lt;attribute name="type" type="{http://www.openapplications.org/oagis/9}NormalizedStringType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AddressBaseType", propOrder = {
    "id",
    "formatCode",
    "attentionOfName",
    "careOfName",
    "addressLine",
    "lineOne",
    "lineTwo",
    "lineThree",
    "lineFour",
    "lineFive",
    "buildingNumber",
    "buildingName",
    "streetName",
    "unit",
    "floor",
    "postOfficeBox",
    "deliveryPointCode",
    "citySubDivisionName",
    "cityName",
    "countrySubDivisionCode",
    "countryCode",
    "postalCode",
    "status",
    "preference"
})
@XmlSeeAlso({
    AddressType.class
})
@CodingStyleguideUnaware
public abstract class AddressBaseType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "ID")
    private List<IdentifierType> id;
    @XmlElement(name = "FormatCode", namespace = "http://www.openapplications.org/oagis/9")
    private CodeType formatCode;
    @XmlElement(name = "AttentionOfName", namespace = "http://www.openapplications.org/oagis/9")
    private List<NameType> attentionOfName;
    @XmlElement(name = "CareOfName", namespace = "http://www.openapplications.org/oagis/9")
    private List<NameType> careOfName;
    @XmlElement(name = "AddressLine", namespace = "http://www.openapplications.org/oagis/9")
    private List<SequencedTextType> addressLine;
    @XmlElement(name = "LineOne", namespace = "http://www.openapplications.org/oagis/9")
    private TextType lineOne;
    @XmlElement(name = "LineTwo", namespace = "http://www.openapplications.org/oagis/9")
    private TextType lineTwo;
    @XmlElement(name = "LineThree", namespace = "http://www.openapplications.org/oagis/9")
    private TextType lineThree;
    @XmlElement(name = "LineFour", namespace = "http://www.openapplications.org/oagis/9")
    private TextType lineFour;
    @XmlElement(name = "LineFive", namespace = "http://www.openapplications.org/oagis/9")
    private TextType lineFive;
    @XmlElement(name = "BuildingNumber", namespace = "http://www.openapplications.org/oagis/9")
    private TextType buildingNumber;
    @XmlElement(name = "BuildingName", namespace = "http://www.openapplications.org/oagis/9")
    private NameType buildingName;
    @XmlElement(name = "StreetName", namespace = "http://www.openapplications.org/oagis/9")
    private NameType streetName;
    @XmlElement(name = "Unit", namespace = "http://www.openapplications.org/oagis/9")
    private TextType unit;
    @XmlElement(name = "Floor", namespace = "http://www.openapplications.org/oagis/9")
    private TextType floor;
    @XmlElement(name = "PostOfficeBox", namespace = "http://www.openapplications.org/oagis/9")
    private TextType postOfficeBox;
    @XmlElement(name = "DeliveryPointCode", namespace = "http://www.openapplications.org/oagis/9")
    private List<DeliveryPointCodeType> deliveryPointCode;
    @XmlElement(name = "CitySubDivisionName", namespace = "http://www.openapplications.org/oagis/9")
    private List<NameType> citySubDivisionName;
    @XmlElement(name = "CityName", namespace = "http://www.openapplications.org/oagis/9")
    private NameType cityName;
    @XmlElement(name = "CountrySubDivisionCode", namespace = "http://www.openapplications.org/oagis/9")
    private List<CountrySubDivisionCodeType> countrySubDivisionCode;
    @XmlElement(name = "CountryCode")
    private CountryCodeType countryCode;
    @XmlElement(name = "PostalCode", namespace = "http://www.openapplications.org/oagis/9")
    private CodeType postalCode;
    @XmlElement(name = "Status", namespace = "http://www.openapplications.org/oagis/9")
    private StatusType status;
    @XmlElement(name = "Preference", namespace = "http://www.openapplications.org/oagis/9")
    private PreferenceType preference;
    @XmlAttribute(name = "languageCode")
    private String languageCode;
    @XmlAttribute(name = "type")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    private String type;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public AddressBaseType() {
    }

    /**
     * Gets the value of the id property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the id property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getID() {
        if (id == null) {
            id = new ArrayList<IdentifierType>();
        }
        return this.id;
    }

    /**
     * Gets the value of the formatCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getFormatCode() {
        return formatCode;
    }

    /**
     * Sets the value of the formatCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setFormatCode(
        @Nullable
        CodeType value) {
        this.formatCode = value;
    }

    /**
     * Gets the value of the attentionOfName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attentionOfName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAttentionOfName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getAttentionOfName() {
        if (attentionOfName == null) {
            attentionOfName = new ArrayList<NameType>();
        }
        return this.attentionOfName;
    }

    /**
     * Gets the value of the careOfName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the careOfName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCareOfName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getCareOfName() {
        if (careOfName == null) {
            careOfName = new ArrayList<NameType>();
        }
        return this.careOfName;
    }

    /**
     * Gets the value of the addressLine property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the addressLine property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAddressLine().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SequencedTextType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SequencedTextType> getAddressLine() {
        if (addressLine == null) {
            addressLine = new ArrayList<SequencedTextType>();
        }
        return this.addressLine;
    }

    /**
     * Gets the value of the lineOne property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineOne() {
        return lineOne;
    }

    /**
     * Sets the value of the lineOne property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineOne(
        @Nullable
        TextType value) {
        this.lineOne = value;
    }

    /**
     * Gets the value of the lineTwo property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineTwo() {
        return lineTwo;
    }

    /**
     * Sets the value of the lineTwo property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineTwo(
        @Nullable
        TextType value) {
        this.lineTwo = value;
    }

    /**
     * Gets the value of the lineThree property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineThree() {
        return lineThree;
    }

    /**
     * Sets the value of the lineThree property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineThree(
        @Nullable
        TextType value) {
        this.lineThree = value;
    }

    /**
     * Gets the value of the lineFour property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineFour() {
        return lineFour;
    }

    /**
     * Sets the value of the lineFour property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineFour(
        @Nullable
        TextType value) {
        this.lineFour = value;
    }

    /**
     * Gets the value of the lineFive property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getLineFive() {
        return lineFive;
    }

    /**
     * Sets the value of the lineFive property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setLineFive(
        @Nullable
        TextType value) {
        this.lineFive = value;
    }

    /**
     * Gets the value of the buildingNumber property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getBuildingNumber() {
        return buildingNumber;
    }

    /**
     * Sets the value of the buildingNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setBuildingNumber(
        @Nullable
        TextType value) {
        this.buildingNumber = value;
    }

    /**
     * Gets the value of the buildingName property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getBuildingName() {
        return buildingName;
    }

    /**
     * Sets the value of the buildingName property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setBuildingName(
        @Nullable
        NameType value) {
        this.buildingName = value;
    }

    /**
     * Gets the value of the streetName property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getStreetName() {
        return streetName;
    }

    /**
     * Sets the value of the streetName property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setStreetName(
        @Nullable
        NameType value) {
        this.streetName = value;
    }

    /**
     * Gets the value of the unit property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getUnit() {
        return unit;
    }

    /**
     * Sets the value of the unit property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setUnit(
        @Nullable
        TextType value) {
        this.unit = value;
    }

    /**
     * Gets the value of the floor property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getFloor() {
        return floor;
    }

    /**
     * Sets the value of the floor property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setFloor(
        @Nullable
        TextType value) {
        this.floor = value;
    }

    /**
     * Gets the value of the postOfficeBox property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPostOfficeBox() {
        return postOfficeBox;
    }

    /**
     * Sets the value of the postOfficeBox property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPostOfficeBox(
        @Nullable
        TextType value) {
        this.postOfficeBox = value;
    }

    /**
     * Gets the value of the deliveryPointCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the deliveryPointCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDeliveryPointCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DeliveryPointCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DeliveryPointCodeType> getDeliveryPointCode() {
        if (deliveryPointCode == null) {
            deliveryPointCode = new ArrayList<DeliveryPointCodeType>();
        }
        return this.deliveryPointCode;
    }

    /**
     * Gets the value of the citySubDivisionName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the citySubDivisionName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCitySubDivisionName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getCitySubDivisionName() {
        if (citySubDivisionName == null) {
            citySubDivisionName = new ArrayList<NameType>();
        }
        return this.citySubDivisionName;
    }

    /**
     * Gets the value of the cityName property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getCityName() {
        return cityName;
    }

    /**
     * Sets the value of the cityName property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setCityName(
        @Nullable
        NameType value) {
        this.cityName = value;
    }

    /**
     * Gets the value of the countrySubDivisionCode property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the countrySubDivisionCode property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCountrySubDivisionCode().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CountrySubDivisionCodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CountrySubDivisionCodeType> getCountrySubDivisionCode() {
        if (countrySubDivisionCode == null) {
            countrySubDivisionCode = new ArrayList<CountrySubDivisionCodeType>();
        }
        return this.countrySubDivisionCode;
    }

    /**
     * Gets the value of the countryCode property.
     * 
     * @return
     *     possible object is
     *     {@link CountryCodeType }
     *     
     */
    @Nullable
    public CountryCodeType getCountryCode() {
        return countryCode;
    }

    /**
     * Sets the value of the countryCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CountryCodeType }
     *     
     */
    public void setCountryCode(
        @Nullable
        CountryCodeType value) {
        this.countryCode = value;
    }

    /**
     * Gets the value of the postalCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getPostalCode() {
        return postalCode;
    }

    /**
     * Sets the value of the postalCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setPostalCode(
        @Nullable
        CodeType value) {
        this.postalCode = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link StatusType }
     *     
     */
    @Nullable
    public StatusType getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link StatusType }
     *     
     */
    public void setStatus(
        @Nullable
        StatusType value) {
        this.status = value;
    }

    /**
     * Gets the value of the preference property.
     * 
     * @return
     *     possible object is
     *     {@link PreferenceType }
     *     
     */
    @Nullable
    public PreferenceType getPreference() {
        return preference;
    }

    /**
     * Sets the value of the preference property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreferenceType }
     *     
     */
    public void setPreference(
        @Nullable
        PreferenceType value) {
        this.preference = value;
    }

    /**
     * Gets the value of the languageCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getLanguageCode() {
        return languageCode;
    }

    /**
     * Sets the value of the languageCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLanguageCode(
        @Nullable
        String value) {
        this.languageCode = value;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setType(
        @Nullable
        String value) {
        this.type = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final AddressBaseType rhs = ((AddressBaseType) o);
        if (!EqualsHelper.equalsCollection(addressLine, rhs.addressLine)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(attentionOfName, rhs.attentionOfName)) {
            return false;
        }
        if (!EqualsHelper.equals(buildingName, rhs.buildingName)) {
            return false;
        }
        if (!EqualsHelper.equals(buildingNumber, rhs.buildingNumber)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(careOfName, rhs.careOfName)) {
            return false;
        }
        if (!EqualsHelper.equals(cityName, rhs.cityName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(citySubDivisionName, rhs.citySubDivisionName)) {
            return false;
        }
        if (!EqualsHelper.equals(countryCode, rhs.countryCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(countrySubDivisionCode, rhs.countrySubDivisionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(deliveryPointCode, rhs.deliveryPointCode)) {
            return false;
        }
        if (!EqualsHelper.equals(floor, rhs.floor)) {
            return false;
        }
        if (!EqualsHelper.equals(formatCode, rhs.formatCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(languageCode, rhs.languageCode)) {
            return false;
        }
        if (!EqualsHelper.equals(lineFive, rhs.lineFive)) {
            return false;
        }
        if (!EqualsHelper.equals(lineFour, rhs.lineFour)) {
            return false;
        }
        if (!EqualsHelper.equals(lineOne, rhs.lineOne)) {
            return false;
        }
        if (!EqualsHelper.equals(lineThree, rhs.lineThree)) {
            return false;
        }
        if (!EqualsHelper.equals(lineTwo, rhs.lineTwo)) {
            return false;
        }
        if (!EqualsHelper.equals(postOfficeBox, rhs.postOfficeBox)) {
            return false;
        }
        if (!EqualsHelper.equals(postalCode, rhs.postalCode)) {
            return false;
        }
        if (!EqualsHelper.equals(preference, rhs.preference)) {
            return false;
        }
        if (!EqualsHelper.equals(status, rhs.status)) {
            return false;
        }
        if (!EqualsHelper.equals(streetName, rhs.streetName)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equals(unit, rhs.unit)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(addressLine).append(attentionOfName).append(buildingName).append(buildingNumber).append(careOfName).append(cityName).append(citySubDivisionName).append(countryCode).append(countrySubDivisionCode).append(deliveryPointCode).append(floor).append(formatCode).append(id).append(languageCode).append(lineFive).append(lineFour).append(lineOne).append(lineThree).append(lineTwo).append(postOfficeBox).append(postalCode).append(preference).append(status).append(streetName).append(type).append(unit).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("addressLine", addressLine).append("attentionOfName", attentionOfName).append("buildingName", buildingName).append("buildingNumber", buildingNumber).append("careOfName", careOfName).append("cityName", cityName).append("citySubDivisionName", citySubDivisionName).append("countryCode", countryCode).append("countrySubDivisionCode", countrySubDivisionCode).append("deliveryPointCode", deliveryPointCode).append("floor", floor).append("formatCode", formatCode).append("id", id).append("languageCode", languageCode).append("lineFive", lineFive).append("lineFour", lineFour).append("lineOne", lineOne).append("lineThree", lineThree).append("lineTwo", lineTwo).append("postOfficeBox", postOfficeBox).append("postalCode", postalCode).append("preference", preference).append("status", status).append("streetName", streetName).append("type", type).append("unit", unit).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setID(
        @Nullable
        final List<IdentifierType> aList) {
        id = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAttentionOfName(
        @Nullable
        final List<NameType> aList) {
        attentionOfName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCareOfName(
        @Nullable
        final List<NameType> aList) {
        careOfName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAddressLine(
        @Nullable
        final List<SequencedTextType> aList) {
        addressLine = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDeliveryPointCode(
        @Nullable
        final List<DeliveryPointCodeType> aList) {
        deliveryPointCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCitySubDivisionName(
        @Nullable
        final List<NameType> aList) {
        citySubDivisionName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCountrySubDivisionCode(
        @Nullable
        final List<CountrySubDivisionCodeType> aList) {
        countrySubDivisionCode = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIDEntries() {
        return (!getID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIDEntries() {
        return getID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIDCount() {
        return getID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addID(
        @Nonnull
        final IdentifierType elem) {
        getID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAttentionOfNameEntries() {
        return (!getAttentionOfName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAttentionOfNameEntries() {
        return getAttentionOfName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAttentionOfNameCount() {
        return getAttentionOfName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getAttentionOfNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAttentionOfName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAttentionOfName(
        @Nonnull
        final NameType elem) {
        getAttentionOfName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCareOfNameEntries() {
        return (!getCareOfName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCareOfNameEntries() {
        return getCareOfName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCareOfNameCount() {
        return getCareOfName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getCareOfNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCareOfName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCareOfName(
        @Nonnull
        final NameType elem) {
        getCareOfName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAddressLineEntries() {
        return (!getAddressLine().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAddressLineEntries() {
        return getAddressLine().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAddressLineCount() {
        return getAddressLine().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SequencedTextType getAddressLineAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAddressLine().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAddressLine(
        @Nonnull
        final SequencedTextType elem) {
        getAddressLine().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDeliveryPointCodeEntries() {
        return (!getDeliveryPointCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDeliveryPointCodeEntries() {
        return getDeliveryPointCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDeliveryPointCodeCount() {
        return getDeliveryPointCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DeliveryPointCodeType getDeliveryPointCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDeliveryPointCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDeliveryPointCode(
        @Nonnull
        final DeliveryPointCodeType elem) {
        getDeliveryPointCode().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCitySubDivisionNameEntries() {
        return (!getCitySubDivisionName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCitySubDivisionNameEntries() {
        return getCitySubDivisionName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCitySubDivisionNameCount() {
        return getCitySubDivisionName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getCitySubDivisionNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCitySubDivisionName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCitySubDivisionName(
        @Nonnull
        final NameType elem) {
        getCitySubDivisionName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCountrySubDivisionCodeEntries() {
        return (!getCountrySubDivisionCode().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCountrySubDivisionCodeEntries() {
        return getCountrySubDivisionCode().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCountrySubDivisionCodeCount() {
        return getCountrySubDivisionCode().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CountrySubDivisionCodeType getCountrySubDivisionCodeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCountrySubDivisionCode().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCountrySubDivisionCode(
        @Nonnull
        final CountrySubDivisionCodeType elem) {
        getCountrySubDivisionCode().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        AddressBaseType ret) {
        if (addressLine == null) {
            ret.addressLine = null;
        } else {
            List<SequencedTextType> retAddressLine = new ArrayList<SequencedTextType>();
            for (SequencedTextType aItem: getAddressLine()) {
                retAddressLine.add(((aItem == null)?null:aItem.clone()));
            }
            ret.addressLine = retAddressLine;
        }
        if (attentionOfName == null) {
            ret.attentionOfName = null;
        } else {
            List<NameType> retAttentionOfName = new ArrayList<NameType>();
            for (NameType aItem: getAttentionOfName()) {
                retAttentionOfName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.attentionOfName = retAttentionOfName;
        }
        ret.buildingName = ((buildingName == null)?null:buildingName.clone());
        ret.buildingNumber = ((buildingNumber == null)?null:buildingNumber.clone());
        if (careOfName == null) {
            ret.careOfName = null;
        } else {
            List<NameType> retCareOfName = new ArrayList<NameType>();
            for (NameType aItem: getCareOfName()) {
                retCareOfName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.careOfName = retCareOfName;
        }
        ret.cityName = ((cityName == null)?null:cityName.clone());
        if (citySubDivisionName == null) {
            ret.citySubDivisionName = null;
        } else {
            List<NameType> retCitySubDivisionName = new ArrayList<NameType>();
            for (NameType aItem: getCitySubDivisionName()) {
                retCitySubDivisionName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.citySubDivisionName = retCitySubDivisionName;
        }
        ret.countryCode = ((countryCode == null)?null:countryCode.clone());
        if (countrySubDivisionCode == null) {
            ret.countrySubDivisionCode = null;
        } else {
            List<CountrySubDivisionCodeType> retCountrySubDivisionCode = new ArrayList<CountrySubDivisionCodeType>();
            for (CountrySubDivisionCodeType aItem: getCountrySubDivisionCode()) {
                retCountrySubDivisionCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.countrySubDivisionCode = retCountrySubDivisionCode;
        }
        if (deliveryPointCode == null) {
            ret.deliveryPointCode = null;
        } else {
            List<DeliveryPointCodeType> retDeliveryPointCode = new ArrayList<DeliveryPointCodeType>();
            for (DeliveryPointCodeType aItem: getDeliveryPointCode()) {
                retDeliveryPointCode.add(((aItem == null)?null:aItem.clone()));
            }
            ret.deliveryPointCode = retDeliveryPointCode;
        }
        ret.floor = ((floor == null)?null:floor.clone());
        ret.formatCode = ((formatCode == null)?null:formatCode.clone());
        if (id == null) {
            ret.id = null;
        } else {
            List<IdentifierType> retID = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getID()) {
                retID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.id = retID;
        }
        ret.languageCode = languageCode;
        ret.lineFive = ((lineFive == null)?null:lineFive.clone());
        ret.lineFour = ((lineFour == null)?null:lineFour.clone());
        ret.lineOne = ((lineOne == null)?null:lineOne.clone());
        ret.lineThree = ((lineThree == null)?null:lineThree.clone());
        ret.lineTwo = ((lineTwo == null)?null:lineTwo.clone());
        ret.postOfficeBox = ((postOfficeBox == null)?null:postOfficeBox.clone());
        ret.postalCode = ((postalCode == null)?null:postalCode.clone());
        ret.preference = ((preference == null)?null:preference.clone());
        ret.status = ((status == null)?null:status.clone());
        ret.streetName = ((streetName == null)?null:streetName.clone());
        ret.type = type;
        ret.unit = ((unit == null)?null:unit.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public abstract AddressBaseType clone();

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CountryCodeType and never <code>null</code>
     */
    @Nonnull
    public CountryCodeType setCountryCode(
        @Nullable
        final String valueParam) {
        CountryCodeType aObj = getCountryCode();
        if (aObj == null) {
            aObj = new CountryCodeType(valueParam);
            setCountryCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setFormatCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getFormatCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setFormatCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setPostalCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getPostalCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setPostalCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineOne(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineOne();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineOne(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineTwo(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineTwo();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineTwo(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineThree(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineThree();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineThree(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineFour(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineFour();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineFour(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setLineFive(
        @Nullable
        final String valueParam) {
        TextType aObj = getLineFive();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setLineFive(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setBuildingNumber(
        @Nullable
        final String valueParam) {
        TextType aObj = getBuildingNumber();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setBuildingNumber(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setUnit(
        @Nullable
        final String valueParam) {
        TextType aObj = getUnit();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setUnit(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setFloor(
        @Nullable
        final String valueParam) {
        TextType aObj = getFloor();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setFloor(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPostOfficeBox(
        @Nullable
        final String valueParam) {
        TextType aObj = getPostOfficeBox();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPostOfficeBox(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setBuildingName(
        @Nullable
        final String valueParam) {
        NameType aObj = getBuildingName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setBuildingName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setStreetName(
        @Nullable
        final String valueParam) {
        NameType aObj = getStreetName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setStreetName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setCityName(
        @Nullable
        final String valueParam) {
        NameType aObj = getCityName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setCityName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getFormatCodeValue() {
        CodeType aObj = getFormatCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineOneValue() {
        TextType aObj = getLineOne();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineTwoValue() {
        TextType aObj = getLineTwo();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineThreeValue() {
        TextType aObj = getLineThree();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineFourValue() {
        TextType aObj = getLineFour();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getLineFiveValue() {
        TextType aObj = getLineFive();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getBuildingNumberValue() {
        TextType aObj = getBuildingNumber();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getBuildingNameValue() {
        NameType aObj = getBuildingName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getStreetNameValue() {
        NameType aObj = getStreetName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getUnitValue() {
        TextType aObj = getUnit();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getFloorValue() {
        TextType aObj = getFloor();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPostOfficeBoxValue() {
        TextType aObj = getPostOfficeBox();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getCityNameValue() {
        NameType aObj = getCityName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CountryCodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CountryCodeType object or <code>null</code>
     */
    @Nullable
    public String getCountryCodeValue() {
        CountryCodeType aObj = getCountryCode();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getPostalCodeValue() {
        CodeType aObj = getPostalCode();
        return ((aObj == null)?null:aObj.getValue());
    }

}
