
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.TextType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DictionaryEntryName xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Party. Details&lt;/ccts:DictionaryEntryName&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Contains a&#13;
 * 					set of information about a Party necessary to execute and administer a given&#13;
 * 					request or business activity. A party is an individual or entity having a role&#13;
 * 					in a business activity and having obligations and/or entitlements deriving from&#13;
 * 					that role that are contractually binding or legally significant.&#13;
 * 				&lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * 
 * <p>Java class for BasePartyType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="BasePartyType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PartyID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PartyLegalID" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PartyTaxID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PartyName" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PartyReportingIDs" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}Communication" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}PersonContact" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attribute name="agencyRoleCode" type="{http://www.hr-xml.org/3}AgencyRoleCodeContentType" /&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "BasePartyType", propOrder = {
    "partyID",
    "partyLegalID",
    "partyTaxID",
    "partyName",
    "partyReportingIDs",
    "communication",
    "personContact"
})
@XmlSeeAlso({
    PartyType.class
})
@CodingStyleguideUnaware
public class BasePartyType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "PartyID")
    private List<IdentifierType> partyID;
    @XmlElement(name = "PartyLegalID")
    private List<IdentifierType> partyLegalID;
    @XmlElement(name = "PartyTaxID")
    private IdentifierType partyTaxID;
    @XmlElement(name = "PartyName")
    private TextType partyName;
    @XmlElement(name = "PartyReportingIDs")
    private List<IDSetType> partyReportingIDs;
    @XmlElement(name = "Communication")
    private List<CommunicationABIEType> communication;
    @XmlElement(name = "PersonContact")
    private List<PersonContactType> personContact;
    @XmlAttribute(name = "agencyRoleCode")
    private String agencyRoleCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public BasePartyType() {
    }

    /**
     * Gets the value of the partyID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPartyID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getPartyID() {
        if (partyID == null) {
            partyID = new ArrayList<IdentifierType>();
        }
        return this.partyID;
    }

    /**
     * Gets the value of the partyLegalID property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyLegalID property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPartyLegalID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IdentifierType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IdentifierType> getPartyLegalID() {
        if (partyLegalID == null) {
            partyLegalID = new ArrayList<IdentifierType>();
        }
        return this.partyLegalID;
    }

    /**
     * Gets the value of the partyTaxID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getPartyTaxID() {
        return partyTaxID;
    }

    /**
     * Sets the value of the partyTaxID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setPartyTaxID(
        @Nullable
        IdentifierType value) {
        this.partyTaxID = value;
    }

    /**
     * Gets the value of the partyName property.
     * 
     * @return
     *     possible object is
     *     {@link TextType }
     *     
     */
    @Nullable
    public TextType getPartyName() {
        return partyName;
    }

    /**
     * Sets the value of the partyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link TextType }
     *     
     */
    public void setPartyName(
        @Nullable
        TextType value) {
        this.partyName = value;
    }

    /**
     * Gets the value of the partyReportingIDs property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyReportingIDs property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPartyReportingIDs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDSetType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDSetType> getPartyReportingIDs() {
        if (partyReportingIDs == null) {
            partyReportingIDs = new ArrayList<IDSetType>();
        }
        return this.partyReportingIDs;
    }

    /**
     * Gets the value of the communication property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the communication property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCommunication().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommunicationABIEType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommunicationABIEType> getCommunication() {
        if (communication == null) {
            communication = new ArrayList<CommunicationABIEType>();
        }
        return this.communication;
    }

    /**
     * Gets the value of the personContact property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personContact property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPersonContact().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonContactType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonContactType> getPersonContact() {
        if (personContact == null) {
            personContact = new ArrayList<PersonContactType>();
        }
        return this.personContact;
    }

    /**
     * Gets the value of the agencyRoleCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAgencyRoleCode() {
        return agencyRoleCode;
    }

    /**
     * Sets the value of the agencyRoleCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAgencyRoleCode(
        @Nullable
        String value) {
        this.agencyRoleCode = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final BasePartyType rhs = ((BasePartyType) o);
        if (!EqualsHelper.equals(agencyRoleCode, rhs.agencyRoleCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(communication, rhs.communication)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyID, rhs.partyID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyLegalID, rhs.partyLegalID)) {
            return false;
        }
        if (!EqualsHelper.equals(partyName, rhs.partyName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyReportingIDs, rhs.partyReportingIDs)) {
            return false;
        }
        if (!EqualsHelper.equals(partyTaxID, rhs.partyTaxID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personContact, rhs.personContact)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(agencyRoleCode).append(communication).append(partyID).append(partyLegalID).append(partyName).append(partyReportingIDs).append(partyTaxID).append(personContact).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("agencyRoleCode", agencyRoleCode).append("communication", communication).append("partyID", partyID).append("partyLegalID", partyLegalID).append("partyName", partyName).append("partyReportingIDs", partyReportingIDs).append("partyTaxID", partyTaxID).append("personContact", personContact).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyID(
        @Nullable
        final List<IdentifierType> aList) {
        partyID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyLegalID(
        @Nullable
        final List<IdentifierType> aList) {
        partyLegalID = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyReportingIDs(
        @Nullable
        final List<IDSetType> aList) {
        partyReportingIDs = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommunication(
        @Nullable
        final List<CommunicationABIEType> aList) {
        communication = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonContact(
        @Nullable
        final List<PersonContactType> aList) {
        personContact = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyIDEntries() {
        return (!getPartyID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyIDEntries() {
        return getPartyID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyIDCount() {
        return getPartyID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getPartyIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyID(
        @Nonnull
        final IdentifierType elem) {
        getPartyID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyLegalIDEntries() {
        return (!getPartyLegalID().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyLegalIDEntries() {
        return getPartyLegalID().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyLegalIDCount() {
        return getPartyLegalID().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IdentifierType getPartyLegalIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyLegalID().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyLegalID(
        @Nonnull
        final IdentifierType elem) {
        getPartyLegalID().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyReportingIDsEntries() {
        return (!getPartyReportingIDs().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyReportingIDsEntries() {
        return getPartyReportingIDs().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyReportingIDsCount() {
        return getPartyReportingIDs().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDSetType getPartyReportingIDsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyReportingIDs().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyReportingIDs(
        @Nonnull
        final IDSetType elem) {
        getPartyReportingIDs().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommunicationEntries() {
        return (!getCommunication().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommunicationEntries() {
        return getCommunication().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommunicationCount() {
        return getCommunication().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommunicationABIEType getCommunicationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommunication().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommunication(
        @Nonnull
        final CommunicationABIEType elem) {
        getCommunication().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonContactEntries() {
        return (!getPersonContact().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonContactEntries() {
        return getPersonContact().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonContactCount() {
        return getPersonContact().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonContactType getPersonContactAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonContact().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonContact(
        @Nonnull
        final PersonContactType elem) {
        getPersonContact().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        BasePartyType ret) {
        ret.agencyRoleCode = agencyRoleCode;
        if (communication == null) {
            ret.communication = null;
        } else {
            List<CommunicationABIEType> retCommunication = new ArrayList<CommunicationABIEType>();
            for (CommunicationABIEType aItem: getCommunication()) {
                retCommunication.add(((aItem == null)?null:aItem.clone()));
            }
            ret.communication = retCommunication;
        }
        if (partyID == null) {
            ret.partyID = null;
        } else {
            List<IdentifierType> retPartyID = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getPartyID()) {
                retPartyID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyID = retPartyID;
        }
        if (partyLegalID == null) {
            ret.partyLegalID = null;
        } else {
            List<IdentifierType> retPartyLegalID = new ArrayList<IdentifierType>();
            for (IdentifierType aItem: getPartyLegalID()) {
                retPartyLegalID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyLegalID = retPartyLegalID;
        }
        ret.partyName = ((partyName == null)?null:partyName.clone());
        if (partyReportingIDs == null) {
            ret.partyReportingIDs = null;
        } else {
            List<IDSetType> retPartyReportingIDs = new ArrayList<IDSetType>();
            for (IDSetType aItem: getPartyReportingIDs()) {
                retPartyReportingIDs.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyReportingIDs = retPartyReportingIDs;
        }
        ret.partyTaxID = ((partyTaxID == null)?null:partyTaxID.clone());
        if (personContact == null) {
            ret.personContact = null;
        } else {
            List<PersonContactType> retPersonContact = new ArrayList<PersonContactType>();
            for (PersonContactType aItem: getPersonContact()) {
                retPersonContact.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personContact = retPersonContact;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public BasePartyType clone() {
        BasePartyType ret = new BasePartyType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setPartyTaxID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getPartyTaxID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setPartyTaxID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TextType and never <code>null</code>
     */
    @Nonnull
    public TextType setPartyName(
        @Nullable
        final String valueParam) {
        TextType aObj = getPartyName();
        if (aObj == null) {
            aObj = new TextType(valueParam);
            setPartyName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getPartyTaxIDValue() {
        IdentifierType aObj = getPartyTaxID();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TextType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TextType object or <code>null</code>
     */
    @Nullable
    public String getPartyNameValue() {
        TextType aObj = getPartyName();
        return ((aObj == null)?null:aObj.getValue());
    }

}
