
package tr.gov.efatura.useraccount;

import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.TextType;


/**
 *  This contains the name or names that generally would be inherited or
 * 				indicative of a person's family. In Western contexts, this is what is commonly
 * 				referred to as a "last name." If a person has multiple family names, the order in
 * 				which the names appear is deemed significant. Generally, that order should
 * 				correspond to the order in which the names would appear in a typical formatted
 * 				representation. The order may be specifically identified by the sequence. A
 * 				"primary" family name may be indicated using the attribute supplied for this
 * 				purpose. Where multiple family names are presented, only a single name may be
 * 				designated as primary = "true" Note that the attribute "prefix" may optionally
 * 				contain a part of the person’s name that precedes the family name. For example: Van
 * 				den, Von, Al, de, etc. Some implementers may choose not to represent a prefix
 * 				separately from a Family Name. However, it may be desirable to do so for a number of
 * 				reasons: 1. name sorting. For example, to support sorting on first letter of prefix
 * 				and then by first letter of the family name. 2. formatting. For example, depending
 * 				on the cultural context in which the name is presented, the type of delimiter (e.g.,
 * 				a space or a hyphen) between the prefix and the family name (or whether a delimiter
 * 				appears at) all may depend on the "alphabet" and/or cultural context in which the
 * 				name is presented.
 * 
 * <p>Java class for FamilyNameType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="FamilyNameType"&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.openapplications.org/oagis/9&gt;TextType"&gt;
 *       &lt;attribute name="primaryIndicator" type="{http://www.openapplications.org/oagis/9}IndicatorType" /&gt;
 *       &lt;attribute name="sequence" type="{http://www.openapplications.org/oagis/9}PositiveIntegerNumericType" /&gt;
 *       &lt;attribute name="prefix" type="{http://www.openapplications.org/oagis/9}StringType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FamilyNameType")
@CodingStyleguideUnaware
public class FamilyNameType
    extends TextType
{

    @XmlAttribute(name = "primaryIndicator")
    private Boolean primaryIndicator;
    @XmlAttribute(name = "sequence")
    private BigInteger sequence;
    @XmlAttribute(name = "prefix")
    private String prefix;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public FamilyNameType() {
    }

    /**
     * Constructor for value of type String calling super class constructor.<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public FamilyNameType(
        @Nullable
        final String valueParam) {
        super(valueParam);
    }

    /**
     * Gets the value of the primaryIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isPrimaryIndicator() {
        return primaryIndicator;
    }

    /**
     * Sets the value of the primaryIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setPrimaryIndicator(
        @Nullable
        Boolean value) {
        this.primaryIndicator = value;
    }

    /**
     * Gets the value of the sequence property.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Nullable
    public BigInteger getSequence() {
        return sequence;
    }

    /**
     * Sets the value of the sequence property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     */
    public void setSequence(
        @Nullable
        BigInteger value) {
        this.sequence = value;
    }

    /**
     * Gets the value of the prefix property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getPrefix() {
        return prefix;
    }

    /**
     * Sets the value of the prefix property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPrefix(
        @Nullable
        String value) {
        this.prefix = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final FamilyNameType rhs = ((FamilyNameType) o);
        if (!EqualsHelper.equals(prefix, rhs.prefix)) {
            return false;
        }
        if (!EqualsHelper.equals(primaryIndicator, rhs.primaryIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(sequence, rhs.sequence)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(prefix).append(primaryIndicator).append(sequence).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("prefix", prefix).append("primaryIndicator", primaryIndicator).append("sequence", sequence).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FamilyNameType ret) {
        super.cloneTo(ret);
        ret.prefix = prefix;
        ret.primaryIndicator = primaryIndicator;
        ret.sequence = sequence;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FamilyNameType clone() {
        FamilyNameType ret = new FamilyNameType();
        cloneTo(ret);
        return ret;
    }

}
