
package tr.gov.efatura.useraccount;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.TextType;


/**
 * This is a formatted presentation of a name (for example, a person
 * 				name) that might alternatively presented as discretely fielded components or it
 * 				could otherwise be a name that has alternative formatted representations. The
 * 				formatCode is an optional attribute available to specify the applicable "mask" or
 * 				type of format presentation to which the contents conforms. For example, in the case
 * 				of the FormattedName of person formatCodes could be items such as: "Family Name,
 * 				Given Name" "Given Name, Middle Initial, Family Name" "First Initial, Family Name"
 * 				"Given Name, Last Initial" "Nick Name, Family Name" 
 * 
 * <p>Java class for FormattedNameType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="FormattedNameType"&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.openapplications.org/oagis/9&gt;TextType"&gt;
 *       &lt;attribute name="formatCode" type="{http://www.openapplications.org/oagis/9}NormalizedStringType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "FormattedNameType")
@CodingStyleguideUnaware
public class FormattedNameType
    extends TextType
{

    @XmlAttribute(name = "formatCode")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    private String formatCode;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public FormattedNameType() {
    }

    /**
     * Constructor for value of type String calling super class constructor.<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public FormattedNameType(
        @Nullable
        final String valueParam) {
        super(valueParam);
    }

    /**
     * Gets the value of the formatCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getFormatCode() {
        return formatCode;
    }

    /**
     * Sets the value of the formatCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFormatCode(
        @Nullable
        String value) {
        this.formatCode = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final FormattedNameType rhs = ((FormattedNameType) o);
        if (!EqualsHelper.equals(formatCode, rhs.formatCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(formatCode).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("formatCode", formatCode).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        FormattedNameType ret) {
        super.cloneTo(ret);
        ret.formatCode = formatCode;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public FormattedNameType clone() {
        FormattedNameType ret = new FormattedNameType();
        cloneTo(ret);
        return ret;
    }

}
