
package tr.gov.efatura.useraccount;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.TextType;


/**
 *  This is a second "given name" or sometimes depending on cultural
 * 				context, representative of family relationships. A middle name can have a prefix.
 * 				For example, in Saudi names the word "Bin" means "son of" and would be a common
 * 				prefix to a middle name usually representing the first name of the person's father.
 * 				Some implementers may choose not to represent a prefix separately from a middle
 * 				name. However, it may be desirable to do so for a number of reasons: 1. name
 * 				sorting. For example, to support sorting on first letter of prefix and then by first
 * 				letter of the middle name. 2. formatting. For example, depending on the cultural
 * 				context in which the name is presented, the type of delimiter (e.g., a space or a
 * 				hyphen) between the prefix and the family name (or whether a delimiter appears at)
 * 				all may depend on the "alphabet" and/or cultural context in which the name is
 * 				presented.
 * 
 * <p>Java class for MiddleNameType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="MiddleNameType"&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.openapplications.org/oagis/9&gt;TextType"&gt;
 *       &lt;attribute name="prefix" type="{http://www.openapplications.org/oagis/9}StringType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MiddleNameType")
@CodingStyleguideUnaware
public class MiddleNameType
    extends TextType
{

    @XmlAttribute(name = "prefix")
    private String prefix;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public MiddleNameType() {
    }

    /**
     * Constructor for value of type String calling super class constructor.<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public MiddleNameType(
        @Nullable
        final String valueParam) {
        super(valueParam);
    }

    /**
     * Gets the value of the prefix property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getPrefix() {
        return prefix;
    }

    /**
     * Sets the value of the prefix property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPrefix(
        @Nullable
        String value) {
        this.prefix = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final MiddleNameType rhs = ((MiddleNameType) o);
        if (!EqualsHelper.equals(prefix, rhs.prefix)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(prefix).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("prefix", prefix).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        MiddleNameType ret) {
        super.cloneTo(ret);
        ret.prefix = prefix;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public MiddleNameType clone() {
        MiddleNameType ret = new MiddleNameType();
        cloneTo(ret);
        return ret;
    }

}
