
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.CodeType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DictionaryEntryName xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Notification. Details&lt;/ccts:DictionaryEntryName&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Contains&#13;
 * 					details on preferred or primary notification methods associated with a&#13;
 * 					particular scope of work or function. See&#13;
 * 					NotificationScopeCode-element.&lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;This is used in&#13;
 * 					pre-provisioning a partner system with user account information. See&#13;
 * 					UserAccount-noun.&lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * 
 * <p>Java class for NotificationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="NotificationType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}NotificationScopeCode" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UseDefaultIndicator" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}NotificationMethod" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserArea" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "NotificationType", propOrder = {
    "notificationScopeCode",
    "useDefaultIndicator",
    "notificationMethod",
    "userArea"
})
@CodingStyleguideUnaware
public class NotificationType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "NotificationScopeCode")
    private CodeType notificationScopeCode;
    @XmlElement(name = "UseDefaultIndicator")
    private Boolean useDefaultIndicator;
    @XmlElement(name = "NotificationMethod")
    private List<CommunicationABIEType> notificationMethod;
    @XmlElement(name = "UserArea")
    private UserAreaType userArea;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public NotificationType() {
    }

    /**
     * Gets the value of the notificationScopeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getNotificationScopeCode() {
        return notificationScopeCode;
    }

    /**
     * Sets the value of the notificationScopeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setNotificationScopeCode(
        @Nullable
        CodeType value) {
        this.notificationScopeCode = value;
    }

    /**
     * Gets the value of the useDefaultIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isUseDefaultIndicator() {
        return useDefaultIndicator;
    }

    /**
     * Sets the value of the useDefaultIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setUseDefaultIndicator(
        @Nullable
        Boolean value) {
        this.useDefaultIndicator = value;
    }

    /**
     * Gets the value of the notificationMethod property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the notificationMethod property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getNotificationMethod().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommunicationABIEType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommunicationABIEType> getNotificationMethod() {
        if (notificationMethod == null) {
            notificationMethod = new ArrayList<CommunicationABIEType>();
        }
        return this.notificationMethod;
    }

    /**
     * Gets the value of the userArea property.
     * 
     * @return
     *     possible object is
     *     {@link UserAreaType }
     *     
     */
    @Nullable
    public UserAreaType getUserArea() {
        return userArea;
    }

    /**
     * Sets the value of the userArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link UserAreaType }
     *     
     */
    public void setUserArea(
        @Nullable
        UserAreaType value) {
        this.userArea = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final NotificationType rhs = ((NotificationType) o);
        if (!EqualsHelper.equalsCollection(notificationMethod, rhs.notificationMethod)) {
            return false;
        }
        if (!EqualsHelper.equals(notificationScopeCode, rhs.notificationScopeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(useDefaultIndicator, rhs.useDefaultIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(userArea, rhs.userArea)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(notificationMethod).append(notificationScopeCode).append(useDefaultIndicator).append(userArea).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("notificationMethod", notificationMethod).append("notificationScopeCode", notificationScopeCode).append("useDefaultIndicator", useDefaultIndicator).append("userArea", userArea).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNotificationMethod(
        @Nullable
        final List<CommunicationABIEType> aList) {
        notificationMethod = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNotificationMethodEntries() {
        return (!getNotificationMethod().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNotificationMethodEntries() {
        return getNotificationMethod().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNotificationMethodCount() {
        return getNotificationMethod().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommunicationABIEType getNotificationMethodAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNotificationMethod().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNotificationMethod(
        @Nonnull
        final CommunicationABIEType elem) {
        getNotificationMethod().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        NotificationType ret) {
        if (notificationMethod == null) {
            ret.notificationMethod = null;
        } else {
            List<CommunicationABIEType> retNotificationMethod = new ArrayList<CommunicationABIEType>();
            for (CommunicationABIEType aItem: getNotificationMethod()) {
                retNotificationMethod.add(((aItem == null)?null:aItem.clone()));
            }
            ret.notificationMethod = retNotificationMethod;
        }
        ret.notificationScopeCode = ((notificationScopeCode == null)?null:notificationScopeCode.clone());
        ret.useDefaultIndicator = useDefaultIndicator;
        ret.userArea = ((userArea == null)?null:userArea.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public NotificationType clone() {
        NotificationType ret = new NotificationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setNotificationScopeCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getNotificationScopeCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setNotificationScopeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getNotificationScopeCodeValue() {
        CodeType aObj = getNotificationScopeCode();
        return ((aObj == null)?null:aObj.getValue());
    }

}
