
package tr.gov.efatura.useraccount;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DictionaryEntryName xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Person Name. Details&lt;/ccts:DictionaryEntryName&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:DefinitionText xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;A&#13;
 * 					collection of data representing a person name. &lt;/ccts:DefinitionText&gt;
 * </pre>
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ccts:UsageRule xmlns:ccts="urn:un:unece:uncefact:documentation:1.1" xmlns="http://www.hr-xml.org/3" xmlns:oa="http://www.openapplications.org/oagis/9" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;Various uses&#13;
 * 					and options are supported. The person name model is intended to be useful across&#13;
 * 					many cultural contexts. The ordering and presentation of given names and family&#13;
 * 					names may vary by cultural custom. A person name can be represented as a&#13;
 * 					formatted string "Mr. John L Smith III, Phd" or represented as discretely&#13;
 * 					fielded data or both. An option to present a name in an alternative "alphabet"&#13;
 * 					or script is supported. For example the same name might be presented using&#13;
 * 					Roman, Kanji, Arabic, or other character sets. Note the term "script" versus&#13;
 * 					"character set" is used so as not to confuse this issue with concepts such as&#13;
 * 					"character encoding". &lt;/ccts:UsageRule&gt;
 * </pre>
 * 
 * 
 * <p>Java class for PersonNameType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PersonNameType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.hr-xml.org/3}PersonNameBaseType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}AlternateScriptPersonName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}UserArea" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{http://www.hr-xml.org/3}EffectiveDateAttributeGroup"/&gt;
 *       &lt;attribute name="scriptCode" type="{http://www.openapplications.org/oagis/9}NormalizedStringType" /&gt;
 *       &lt;attribute name="nameTypeCode" type="{http://www.hr-xml.org/3}NameTypeCodeContentType" /&gt;
 *       &lt;attribute name="legalNameIndicator" type="{http://www.openapplications.org/oagis/9}IndicatorType" /&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonNameType", propOrder = {
    "alternateScriptPersonName",
    "userArea"
})
@CodingStyleguideUnaware
public class PersonNameType
    extends PersonNameBaseType
{

    @XmlElement(name = "AlternateScriptPersonName")
    private List<AlternateScriptPersonNameType> alternateScriptPersonName;
    @XmlElement(name = "UserArea")
    private UserAreaType userArea;
    @XmlAttribute(name = "scriptCode")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    private String scriptCode;
    @XmlAttribute(name = "nameTypeCode")
    private String nameTypeCode;
    @XmlAttribute(name = "legalNameIndicator")
    private Boolean legalNameIndicator;
    @XmlAttribute(name = "validFrom")
    private List<String> validFrom;
    @XmlAttribute(name = "validTo")
    private List<String> validTo;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PersonNameType() {
    }

    /**
     * Gets the value of the alternateScriptPersonName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the alternateScriptPersonName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAlternateScriptPersonName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AlternateScriptPersonNameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AlternateScriptPersonNameType> getAlternateScriptPersonName() {
        if (alternateScriptPersonName == null) {
            alternateScriptPersonName = new ArrayList<AlternateScriptPersonNameType>();
        }
        return this.alternateScriptPersonName;
    }

    /**
     * Gets the value of the userArea property.
     * 
     * @return
     *     possible object is
     *     {@link UserAreaType }
     *     
     */
    @Nullable
    public UserAreaType getUserArea() {
        return userArea;
    }

    /**
     * Sets the value of the userArea property.
     * 
     * @param value
     *     allowed object is
     *     {@link UserAreaType }
     *     
     */
    public void setUserArea(
        @Nullable
        UserAreaType value) {
        this.userArea = value;
    }

    /**
     * Gets the value of the scriptCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getScriptCode() {
        return scriptCode;
    }

    /**
     * Sets the value of the scriptCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setScriptCode(
        @Nullable
        String value) {
        this.scriptCode = value;
    }

    /**
     * Gets the value of the nameTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getNameTypeCode() {
        return nameTypeCode;
    }

    /**
     * Sets the value of the nameTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNameTypeCode(
        @Nullable
        String value) {
        this.nameTypeCode = value;
    }

    /**
     * Gets the value of the legalNameIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isLegalNameIndicator() {
        return legalNameIndicator;
    }

    /**
     * Sets the value of the legalNameIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setLegalNameIndicator(
        @Nullable
        Boolean value) {
        this.legalNameIndicator = value;
    }

    /**
     * Gets the value of the validFrom property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validFrom property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidFrom().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getValidFrom() {
        if (validFrom == null) {
            validFrom = new ArrayList<String>();
        }
        return this.validFrom;
    }

    /**
     * Gets the value of the validTo property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validTo property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValidTo().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<String> getValidTo() {
        if (validTo == null) {
            validTo = new ArrayList<String>();
        }
        return this.validTo;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final PersonNameType rhs = ((PersonNameType) o);
        if (!EqualsHelper.equalsCollection(alternateScriptPersonName, rhs.alternateScriptPersonName)) {
            return false;
        }
        if (!EqualsHelper.equals(legalNameIndicator, rhs.legalNameIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(nameTypeCode, rhs.nameTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(scriptCode, rhs.scriptCode)) {
            return false;
        }
        if (!EqualsHelper.equals(userArea, rhs.userArea)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(validFrom, rhs.validFrom)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(validTo, rhs.validTo)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(alternateScriptPersonName).append(legalNameIndicator).append(nameTypeCode).append(scriptCode).append(userArea).append(validFrom).append(validTo).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("alternateScriptPersonName", alternateScriptPersonName).append("legalNameIndicator", legalNameIndicator).append("nameTypeCode", nameTypeCode).append("scriptCode", scriptCode).append("userArea", userArea).append("validFrom", validFrom).append("validTo", validTo).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAlternateScriptPersonName(
        @Nullable
        final List<AlternateScriptPersonNameType> aList) {
        alternateScriptPersonName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValidFrom(
        @Nullable
        final List<String> aList) {
        validFrom = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValidTo(
        @Nullable
        final List<String> aList) {
        validTo = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAlternateScriptPersonNameEntries() {
        return (!getAlternateScriptPersonName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAlternateScriptPersonNameEntries() {
        return getAlternateScriptPersonName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAlternateScriptPersonNameCount() {
        return getAlternateScriptPersonName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AlternateScriptPersonNameType getAlternateScriptPersonNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAlternateScriptPersonName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAlternateScriptPersonName(
        @Nonnull
        final AlternateScriptPersonNameType elem) {
        getAlternateScriptPersonName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValidFromEntries() {
        return (!getValidFrom().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValidFromEntries() {
        return getValidFrom().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValidFromCount() {
        return getValidFrom().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getValidFromAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValidFrom().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValidFrom(
        @Nonnull
        final String elem) {
        getValidFrom().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValidToEntries() {
        return (!getValidTo().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValidToEntries() {
        return getValidTo().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValidToCount() {
        return getValidTo().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public String getValidToAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValidTo().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValidTo(
        @Nonnull
        final String elem) {
        getValidTo().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PersonNameType ret) {
        super.cloneTo(ret);
        if (alternateScriptPersonName == null) {
            ret.alternateScriptPersonName = null;
        } else {
            List<AlternateScriptPersonNameType> retAlternateScriptPersonName = new ArrayList<AlternateScriptPersonNameType>();
            for (AlternateScriptPersonNameType aItem: getAlternateScriptPersonName()) {
                retAlternateScriptPersonName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.alternateScriptPersonName = retAlternateScriptPersonName;
        }
        ret.legalNameIndicator = legalNameIndicator;
        ret.nameTypeCode = nameTypeCode;
        ret.scriptCode = scriptCode;
        ret.userArea = ((userArea == null)?null:userArea.clone());
        if (validFrom == null) {
            ret.validFrom = null;
        } else {
            List<String> retValidFrom = new ArrayList<String>();
            for (String aItem: getValidFrom()) {
                retValidFrom.add(aItem);
            }
            ret.validFrom = retValidFrom;
        }
        if (validTo == null) {
            ret.validTo = null;
        } else {
            List<String> retValidTo = new ArrayList<String>();
            for (String aItem: getValidTo()) {
                retValidTo.add(aItem);
            }
            ret.validTo = retValidTo;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonNameType clone() {
        PersonNameType ret = new PersonNameType();
        cloneTo(ret);
        return ret;
    }

}
