
package tr.gov.efatura.useraccount;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import org.openapplications.oagis._9.IdentifierType;


/**
 * Contains information on a security question (For example, what is
 * 				your mother's maiden name?) the answer to which is known or set by the user.
 * 				Security questions sometimes are used to support password resets or other
 * 				authentication tasks.
 * 
 * <p>Java class for SecurityQuestionInformationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="SecurityQuestionInformationType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}SecurityQuestionID" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}SecurityQuestion" minOccurs="0"/&gt;
 *         &lt;element ref="{http://www.hr-xml.org/3}SecurityQuestionAnswer" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SecurityQuestionInformationType", propOrder = {
    "securityQuestionID",
    "securityQuestion",
    "securityQuestionAnswer"
})
@CodingStyleguideUnaware
public class SecurityQuestionInformationType implements Serializable, IExplicitlyCloneable
{

    @XmlElement(name = "SecurityQuestionID")
    private IdentifierType securityQuestionID;
    @XmlElement(name = "SecurityQuestion")
    private String securityQuestion;
    @XmlElement(name = "SecurityQuestionAnswer")
    private String securityQuestionAnswer;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public SecurityQuestionInformationType() {
    }

    /**
     * Gets the value of the securityQuestionID property.
     * 
     * @return
     *     possible object is
     *     {@link IdentifierType }
     *     
     */
    @Nullable
    public IdentifierType getSecurityQuestionID() {
        return securityQuestionID;
    }

    /**
     * Sets the value of the securityQuestionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link IdentifierType }
     *     
     */
    public void setSecurityQuestionID(
        @Nullable
        IdentifierType value) {
        this.securityQuestionID = value;
    }

    /**
     * Gets the value of the securityQuestion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSecurityQuestion() {
        return securityQuestion;
    }

    /**
     * Sets the value of the securityQuestion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSecurityQuestion(
        @Nullable
        String value) {
        this.securityQuestion = value;
    }

    /**
     * Gets the value of the securityQuestionAnswer property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getSecurityQuestionAnswer() {
        return securityQuestionAnswer;
    }

    /**
     * Sets the value of the securityQuestionAnswer property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSecurityQuestionAnswer(
        @Nullable
        String value) {
        this.securityQuestionAnswer = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SecurityQuestionInformationType rhs = ((SecurityQuestionInformationType) o);
        if (!EqualsHelper.equals(securityQuestion, rhs.securityQuestion)) {
            return false;
        }
        if (!EqualsHelper.equals(securityQuestionAnswer, rhs.securityQuestionAnswer)) {
            return false;
        }
        if (!EqualsHelper.equals(securityQuestionID, rhs.securityQuestionID)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(securityQuestion).append(securityQuestionAnswer).append(securityQuestionID).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("securityQuestion", securityQuestion).append("securityQuestionAnswer", securityQuestionAnswer).append("securityQuestionID", securityQuestionID).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SecurityQuestionInformationType ret) {
        ret.securityQuestion = securityQuestion;
        ret.securityQuestionAnswer = securityQuestionAnswer;
        ret.securityQuestionID = ((securityQuestionID == null)?null:securityQuestionID.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SecurityQuestionInformationType clone() {
        SecurityQuestionInformationType ret = new SecurityQuestionInformationType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IdentifierType and never <code>null</code>
     */
    @Nonnull
    public IdentifierType setSecurityQuestionID(
        @Nullable
        final String valueParam) {
        IdentifierType aObj = getSecurityQuestionID();
        if (aObj == null) {
            aObj = new IdentifierType(valueParam);
            setSecurityQuestionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IdentifierType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IdentifierType object or <code>null</code>
     */
    @Nullable
    public String getSecurityQuestionIDValue() {
        IdentifierType aObj = getSecurityQuestionID();
        return ((aObj == null)?null:aObj.getValue());
    }

}
