/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.data.EEmailAttachmentDisposition;
import com.helger.smtp.data.EmailAttachmentDataSource;
import com.helger.smtp.data.IEmailAttachment;
import jakarta.activation.FileTypeMap;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailAttachment
implements IEmailAttachment {
    public static final EEmailAttachmentDisposition DEFAULT_DISPOSITION = EEmailAttachmentDisposition.ATTACHMENT;
    private final String m_sFilename;
    private final IHasInputStream m_aInputStreamProvider;
    private final Charset m_aCharset;
    private final String m_sContentType;
    private final EEmailAttachmentDisposition m_eDisposition;

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray) {
        this(string, byArray, (Charset)null);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nullable Charset charset) {
        this(string, byArray, charset, DEFAULT_DISPOSITION);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nullable Charset charset, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this(string, byArray, charset, FileTypeMap.getDefaultFileTypeMap().getContentType(string), eEmailAttachmentDisposition);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nullable Charset charset, @Nullable String string2, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this(string, (IHasInputStream)new ByteArrayInputStreamProvider(byArray), charset, string2, eEmailAttachmentDisposition);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull IHasInputStream iHasInputStream) {
        this(string, iHasInputStream, (Charset)null);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull IHasInputStream iHasInputStream, @Nullable Charset charset) {
        this(string, iHasInputStream, charset, DEFAULT_DISPOSITION);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull IHasInputStream iHasInputStream, @Nullable Charset charset, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this(string, iHasInputStream, charset, FileTypeMap.getDefaultFileTypeMap().getContentType(string), eEmailAttachmentDisposition);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull IHasInputStream iHasInputStream, @Nullable Charset charset, @Nullable String string2, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this.m_sFilename = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"Filename");
        this.m_aInputStreamProvider = (IHasInputStream)ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        this.m_aCharset = charset;
        this.m_sContentType = string2;
        this.m_eDisposition = (EEmailAttachmentDisposition)((Object)ValueEnforcer.notNull((Object)((Object)eEmailAttachmentDisposition), (String)"Disposition"));
    }

    @Override
    @Nonnull
    @Nonempty
    public String getFilename() {
        return this.m_sFilename;
    }

    @Override
    @Nonnull
    public IHasInputStream getInputStreamProvider() {
        return this.m_aInputStreamProvider;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    @Override
    @Nonnull
    public EEmailAttachmentDisposition getDisposition() {
        return this.m_eDisposition;
    }

    @Override
    @Nonnull
    public EmailAttachmentDataSource getAsDataSource() {
        return new EmailAttachmentDataSource(this.m_aInputStreamProvider, this.m_sFilename, this.m_sContentType, this.m_eDisposition);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAttachment emailAttachment = (EmailAttachment)object;
        return this.m_sFilename.equals(emailAttachment.m_sFilename) && EqualsHelper.equals((Object)this.m_aCharset, (Object)emailAttachment.m_aCharset) && EqualsHelper.equals((Object)this.m_sContentType, (Object)emailAttachment.m_sContentType) && this.m_eDisposition.equals((Object)emailAttachment.m_eDisposition);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFilename).append((Object)this.m_aCharset).append((Object)this.m_sContentType).append((Enum)this.m_eDisposition).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Filename", (Object)this.m_sFilename).append("InputStreamProvider", (Object)this.m_aInputStreamProvider).appendIfNotNull("Charset", (Object)this.m_aCharset).appendIfNotNull("ContentType", (Object)this.m_sContentType).append("Disposition", (Enum)this.m_eDisposition).getToString();
    }
}

