/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailAttachmentList;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailData;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class EmailData
implements IMutableEmailData {
    private EEmailType m_eEmailType;
    private IEmailAddress m_aFrom;
    private final ICommonsList<IEmailAddress> m_aReplyTo = new CommonsArrayList();
    private final ICommonsList<IEmailAddress> m_aTo = new CommonsArrayList();
    private final ICommonsList<IEmailAddress> m_aCc = new CommonsArrayList();
    private final ICommonsList<IEmailAddress> m_aBcc = new CommonsArrayList();
    private LocalDateTime m_aSentDateTime;
    private String m_sSubject;
    private String m_sBody;
    private IMutableEmailAttachmentList m_aAttachments;
    private final StringMap m_aCustomAttrs = new StringMap();

    public EmailData(@Nonnull EEmailType eEmailType) {
        this.setEmailType(eEmailType);
    }

    @Override
    @Nonnull
    public EEmailType getEmailType() {
        return this.m_eEmailType;
    }

    @Override
    @Nonnull
    public final EmailData setEmailType(@Nonnull EEmailType eEmailType) {
        ValueEnforcer.notNull((Object)((Object)eEmailType), (String)"EmailType");
        this.m_eEmailType = eEmailType;
        return this;
    }

    @Override
    @Nullable
    public IEmailAddress getFrom() {
        return this.m_aFrom;
    }

    @Override
    @Nonnull
    public final EmailData setFrom(@Nullable IEmailAddress iEmailAddress) {
        this.m_aFrom = iEmailAddress;
        return this;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IEmailAddress> replyTo() {
        return this.m_aReplyTo;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IEmailAddress> to() {
        return this.m_aTo;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IEmailAddress> cc() {
        return this.m_aCc;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IEmailAddress> bcc() {
        return this.m_aBcc;
    }

    @Override
    @Nonnull
    public final EmailData setSentDateTime(@Nullable LocalDateTime localDateTime) {
        this.m_aSentDateTime = PDTFactory.getWithMillisOnly((LocalDateTime)localDateTime);
        return this;
    }

    @Override
    @Nullable
    public LocalDateTime getSentDateTime() {
        return this.m_aSentDateTime;
    }

    @Override
    @Nonnull
    public final EmailData setSubject(@Nullable String string) {
        this.m_sSubject = string;
        return this;
    }

    @Override
    @Nullable
    public String getSubject() {
        return this.m_sSubject;
    }

    @Override
    @Nonnull
    public final EmailData setBody(@Nullable String string) {
        this.m_sBody = string;
        return this;
    }

    @Override
    @Nullable
    public String getBody() {
        return this.m_sBody;
    }

    @Override
    @Nullable
    public IMutableEmailAttachmentList getAttachments() {
        return this.m_aAttachments;
    }

    @Override
    @Nonnull
    public final EmailData setAttachments(@Nullable IEmailAttachmentList iEmailAttachmentList) {
        this.m_aAttachments = iEmailAttachmentList != null && !iEmailAttachmentList.isEmpty() ? new EmailAttachmentList(iEmailAttachmentList) : null;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public StringMap attrs() {
        return this.m_aCustomAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailData emailData = (EmailData)object;
        return EqualsHelper.equals((Object)this.m_aFrom, (Object)emailData.m_aFrom) && EqualsHelper.equals(this.m_aReplyTo, emailData.m_aReplyTo) && this.m_aTo.equals(emailData.m_aTo) && this.m_aCc.equals(emailData.m_aCc) && this.m_aBcc.equals(emailData.m_aBcc) && EqualsHelper.equals((Object)this.m_aSentDateTime, (Object)emailData.m_aSentDateTime) && EqualsHelper.equals((Object)this.m_sSubject, (Object)emailData.m_sSubject) && EqualsHelper.equals((Object)this.m_sBody, (Object)emailData.m_sBody) && EqualsHelper.equals((Object)this.m_aAttachments, (Object)emailData.m_aAttachments) && this.m_aCustomAttrs.equals((Object)emailData.m_aCustomAttrs);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aFrom).append(this.m_aReplyTo).append(this.m_aTo).append(this.m_aCc).append(this.m_aBcc).append((Object)this.m_aSentDateTime).append((Object)this.m_sSubject).append((Object)this.m_sBody).append((Iterable)((Object)this.m_aAttachments)).append((Map)this.m_aCustomAttrs).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("from", (Object)this.m_aFrom).append("replyTo", this.m_aReplyTo).append("to", this.m_aTo).append("cc", this.m_aCc).append("bcc", this.m_aBcc).append("sendDate", (Object)this.m_aSentDateTime).append("subject", (Object)this.m_sSubject).append("body", (Object)this.m_sBody).appendIfNotNull("attachments", (Object)this.m_aAttachments).append("CustomAttrs", (Object)this.m_aCustomAttrs).getToString();
    }

    @Nonnull
    public static EmailData createEmailData(@Nonnull EEmailType eEmailType, @Nullable IEmailAddress iEmailAddress, @Nullable IEmailAddress iEmailAddress2, @Nullable String string, @Nullable String string2, @Nullable IMutableEmailAttachmentList iMutableEmailAttachmentList) {
        EmailData emailData = new EmailData(eEmailType);
        emailData.setFrom(iEmailAddress);
        if (iEmailAddress2 != null) {
            emailData.to().add((Object)iEmailAddress2);
        }
        emailData.setSubject(string);
        emailData.setBody(string2);
        emailData.setAttachments(iMutableEmailAttachmentList);
        return emailData;
    }
}

