/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.annotation.ContainsSoftMigration;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.email.EmailAddress;
import com.helger.commons.email.IEmailAddress;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailAttachment;
import com.helger.smtp.data.EmailAttachmentList;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IEmailAttachment;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EmailDataMicroTypeConverter
implements IMicroTypeConverter<EmailData> {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_PERSONAL = "personal";
    private static final String ELEMENT_FROM = "from";
    private static final String ELEMENT_REPLYTO = "replyto";
    private static final String ELEMENT_TO = "to";
    private static final String ELEMENT_CC = "cc";
    private static final String ELEMENT_BCC = "bcc";
    private static final String ATTR_SENTDATETIME = "sentdatetime";
    private static final String ATTR_SUBJECT = "subject";
    private static final String ELEMENT_BODY = "body";
    private static final String ELEMENT_ATTACHMENTS = "attachments";
    private static final String ELEMENT_CUSTOM = "custom";
    private static final String ATTR_ID = "id";

    private static void _writeEmailAddress(@Nonnull IMicroElement iMicroElement, @Nonnull IEmailAddress iEmailAddress) {
        iMicroElement.setAttribute(ATTR_ADDRESS, iEmailAddress.getAddress());
        if (iEmailAddress.getPersonal() != null) {
            iMicroElement.setAttribute(ATTR_PERSONAL, iEmailAddress.getPersonal());
        }
    }

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull EmailData emailData, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_TYPE, emailData.getEmailType().getID());
        if (emailData.getFrom() != null) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_FROM), emailData.getFrom());
        }
        for (Object object : emailData.replyTo()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_REPLYTO), (IEmailAddress)object);
        }
        for (Object object : emailData.to()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_TO), (IEmailAddress)object);
        }
        for (Object object : emailData.cc()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_CC), (IEmailAddress)object);
        }
        for (Object object : emailData.bcc()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_BCC), (IEmailAddress)object);
        }
        if (emailData.getSentDateTime() != null) {
            microElement.setAttributeWithConversion(ATTR_SENTDATETIME, (Object)emailData.getSentDateTime());
        }
        if (emailData.getSubject() != null) {
            microElement.setAttribute(ATTR_SUBJECT, emailData.getSubject());
        }
        if (emailData.getBody() != null) {
            microElement.appendElement(string, ELEMENT_BODY).appendText((CharSequence)emailData.getBody());
        }
        microElement.appendChild((IMicroNode)MicroTypeConverter.convertToMicroElement((Object)emailData.getAttachments(), (String)string, (String)ELEMENT_ATTACHMENTS));
        for (Object object : emailData.attrs().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
            IMicroElement iMicroElement = microElement.appendElement(string, ELEMENT_CUSTOM);
            iMicroElement.setAttribute(ATTR_ID, (String)object.getKey());
            iMicroElement.appendText((CharSequence)object.getValue());
        }
        return microElement;
    }

    @Nonnull
    private static IEmailAddress _readEmailAddress(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ADDRESS);
        String string2 = iMicroElement.getAttributeValue(ATTR_PERSONAL);
        return new EmailAddress(string, string2);
    }

    @Nonnull
    @ContainsSoftMigration
    public EmailData convertToNative(@Nonnull IMicroElement iMicroElement) {
        Object object;
        Object object22;
        String string = iMicroElement.getAttributeValue(ATTR_TYPE);
        EEmailType eEmailType = EEmailType.getFromIDOrNull(string);
        EmailData emailData = new EmailData(eEmailType);
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_FROM);
        emailData.setFrom(EmailDataMicroTypeConverter._readEmailAddress(iMicroElement2));
        for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_REPLYTO)) {
            emailData.replyTo().add((Object)EmailDataMicroTypeConverter._readEmailAddress(object22));
        }
        for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_TO)) {
            emailData.to().add((Object)EmailDataMicroTypeConverter._readEmailAddress(object22));
        }
        for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_CC)) {
            emailData.cc().add((Object)EmailDataMicroTypeConverter._readEmailAddress(object22));
        }
        for (Object object22 : iMicroElement.getAllChildElements(ELEMENT_BCC)) {
            emailData.bcc().add((Object)EmailDataMicroTypeConverter._readEmailAddress(object22));
        }
        LocalDateTime localDateTime = (LocalDateTime)iMicroElement.getAttributeValueWithConversion(ATTR_SENTDATETIME, LocalDateTime.class);
        if (localDateTime != null) {
            emailData.setSentDateTime(localDateTime);
        } else {
            object22 = iMicroElement.getAttributeValue("sentdate");
            if (object22 != null && (object = PDTWebDateHelper.getZonedDateTimeFromXSD((String)object22)) != null) {
                emailData.setSentDateTime(((ZonedDateTime)object).toLocalDateTime());
            }
        }
        emailData.setSubject(iMicroElement.getAttributeValue(ATTR_SUBJECT));
        emailData.setBody(MicroHelper.getChildTextContent((IMicroElement)iMicroElement, (String)ELEMENT_BODY));
        object22 = iMicroElement.getFirstChildElement(ELEMENT_ATTACHMENTS);
        if (object22 != null) {
            emailData.setAttachments((IEmailAttachmentList)MicroTypeConverter.convertToNative((IMicroElement)object22, EmailAttachmentList.class));
        } else {
            object = new EmailAttachmentList();
            for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements("attachment")) {
                ((EmailAttachmentList)object).addAttachment((IEmailAttachment)MicroTypeConverter.convertToNative((IMicroElement)iMicroElement3, EmailAttachment.class));
            }
            if (!((EmailAttachmentList)object).isEmpty()) {
                emailData.setAttachments((IEmailAttachmentList)object);
            }
        }
        for (Iterator iterator : iMicroElement.getAllChildElements(ELEMENT_CUSTOM)) {
            emailData.attrs().putIn((Object)iterator.getAttributeValue(ATTR_ID), (Object)iterator.getTextContent());
        }
        return emailData;
    }
}

