/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.email.IEmailAddress;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.IEmailAttachmentList;
import java.time.LocalDateTime;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IEmailData {
    @Nonnull
    public EEmailType getEmailType();

    @Nullable
    public IEmailAddress getFrom();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> replyTo();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> to();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> cc();

    @Nonnull
    @ReturnsMutableObject
    public ICommonsList<IEmailAddress> bcc();

    @Nullable
    public LocalDateTime getSentDateTime();

    @Nullable
    public String getSubject();

    @Nullable
    public String getBody();

    @Nullable
    public IEmailAttachmentList getAttachments();

    @Nonnegative
    default public int getAttachmentCount() {
        IEmailAttachmentList iEmailAttachmentList = this.getAttachments();
        return iEmailAttachmentList == null ? 0 : iEmailAttachmentList.getCount();
    }

    @Nonnull
    @ReturnsMutableObject
    public IStringMap attrs();
}

