/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.email.IEmailAddress;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.mail.address.InternetAddressHelper;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import com.helger.smtp.data.IMutableEmailData;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.nio.charset.Charset;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MailConverter {
    private MailConverter() {
    }

    public static void setSubject(@Nonnull MimeMessage mimeMessage, @Nonnull String string, @Nonnull Charset charset) {
        try {
            mimeMessage.setSubject(string, charset.name());
        }
        catch (MessagingException messagingException) {
            throw new IllegalStateException("Charset " + charset + " is unknown!", messagingException);
        }
    }

    public static void setText(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull String string, @Nonnull Charset charset) {
        try {
            mimeBodyPart.setText(string, charset.name());
        }
        catch (MessagingException messagingException) {
            throw new IllegalStateException("Charset " + charset + " is unknown!", messagingException);
        }
    }

    public static void fillMimeMessageUnsafe(@Nonnull MimeMessage mimeMessage, @Nonnull IMutableEmailData iMutableEmailData, @Nullable Charset charset) throws MessagingException {
        if (iMutableEmailData.getFrom() != null) {
            mimeMessage.setFrom((Address)InternetAddressHelper.getAsInternetAddress((IEmailAddress)iMutableEmailData.getFrom(), (Charset)charset));
        }
        mimeMessage.setReplyTo((Address[])InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.replyTo(), (Charset)charset));
        mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.to(), (Charset)charset));
        mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.cc(), (Charset)charset));
        mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.bcc(), (Charset)charset));
        if (iMutableEmailData.getSentDateTime() != null) {
            mimeMessage.setSentDate((Date)TypeConverter.convert((Object)iMutableEmailData.getSentDateTime(), Date.class));
        }
        if (iMutableEmailData.getSubject() != null) {
            if (charset != null) {
                MailConverter.setSubject(mimeMessage, iMutableEmailData.getSubject(), charset);
            } else {
                mimeMessage.setSubject(iMutableEmailData.getSubject());
            }
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        Object object = new MimeBodyPart();
        if (iMutableEmailData.getEmailType().isHTML()) {
            if (charset != null) {
                object.setContent((Object)iMutableEmailData.getBody(), new MimeType(CMimeType.TEXT_HTML).addParameter("charset", charset.name()).getAsString());
            } else {
                object.setContent((Object)iMutableEmailData.getBody(), CMimeType.TEXT_HTML.getAsString());
            }
        } else if (charset != null) {
            MailConverter.setText((MimeBodyPart)object, iMutableEmailData.getBody(), charset);
        } else {
            object.setText(iMutableEmailData.getBody());
        }
        mimeMultipart.addBodyPart((BodyPart)object);
        object = iMutableEmailData.getAttachments();
        if (object != null) {
            for (IEmailAttachmentDataSource iEmailAttachmentDataSource : object.getAsDataSourceList()) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDisposition(iEmailAttachmentDataSource.getDisposition().getID());
                mimeBodyPart.setFileName(iEmailAttachmentDataSource.getName());
                mimeBodyPart.setDataHandler(iEmailAttachmentDataSource.getAsDataHandler());
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
        }
        mimeMessage.setContent((Multipart)mimeMultipart);
    }

    public static void fillMimeMessage(@Nonnull MimeMessage mimeMessage, @Nonnull IMutableEmailData iMutableEmailData, @Nullable Charset charset) {
        try {
            MailConverter.fillMimeMessageUnsafe(mimeMessage, iMutableEmailData, charset);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

