/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.ESMTPErrorCode;
import com.helger.smtp.transport.ESMTPTransportProperty;
import com.helger.smtp.transport.MailSendDetails;
import com.helger.smtp.transport.MailTransportError;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MailTransport {
    public static final String SMTP_PROTOCOL = "smtp";
    public static final String SMTPS_PROTOCOL = "smtps";
    public static final String HEADER_MESSAGE_ID = "Message-ID";
    public static final String HEADER_X_MAILER = "X-Mailer";
    public static final String X_MAILER = "ph-smtp";
    private static final IMutableStatisticsHandlerCounter STATS_SEND_SUCCESS = StatisticsManager.getCounterHandler((String)(MailTransport.class.getName() + "$success"));
    private static final IMutableStatisticsHandlerCounter STATS_SEND_FAILURE = StatisticsManager.getCounterHandler((String)(MailTransport.class.getName() + "$failed"));
    private static final Logger LOGGER = LoggerFactory.getLogger(MailTransport.class);
    private static final ICommonsMap<String, String> DEFAULT_MAIL_PROPERTIES = new CommonsHashMap();
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger(0);
    private final ISMTPSettings m_aSMTPSettings;
    private final boolean m_bSMTPS;
    private final ICommonsMap<String, String> m_aMailProperties;
    private final Session m_aSession;

    @Nonnull
    public static EChange setDefaultMailProperties(@Nullable Map<String, String> map) {
        if (INSTANCE_COUNT.get() > 0) {
            LOGGER.warn("You are changing the default Mail Properties even though " + INSTANCE_COUNT.get() + " instance(s) of MailTransport were already created! This has no impact on existing instances!");
        }
        return DEFAULT_MAIL_PROPERTIES.setAll(map);
    }

    public static boolean isUseSMTPS(@Nonnull ISMTPSettings iSMTPSettings) {
        return iSMTPSettings.isSSLEnabled() || iSMTPSettings.isSTARTTLSEnabled();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> createSessionProperties(@Nonnull ISMTPSettings iSMTPSettings) {
        long l;
        long l2;
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        boolean bl = MailTransport.isUseSMTPS(iSMTPSettings);
        if (iSMTPSettings.isSSLEnabled()) {
            commonsHashMap.put((Object)ESMTPTransportProperty.SSL_ENABLE.getPropertyName(bl), (Object)Boolean.TRUE.toString());
        }
        if (iSMTPSettings.hasUserName()) {
            commonsHashMap.put((Object)ESMTPTransportProperty.AUTH.getPropertyName(bl), (Object)Boolean.TRUE.toString());
        }
        if (iSMTPSettings.isSTARTTLSEnabled()) {
            commonsHashMap.put((Object)ESMTPTransportProperty.STARTTLS_ENABLE.getPropertyName(bl), (Object)Boolean.TRUE.toString());
        }
        if ((l2 = iSMTPSettings.getConnectionTimeoutMilliSecs()) > 0L) {
            commonsHashMap.put((Object)ESMTPTransportProperty.CONNECTIONTIMEOUT.getPropertyName(bl), (Object)Long.toString(l2));
        }
        if ((l = iSMTPSettings.getTimeoutMilliSecs()) > 0L) {
            commonsHashMap.put((Object)ESMTPTransportProperty.TIMEOUT.getPropertyName(bl), (Object)Long.toString(l));
        }
        commonsHashMap.put((Object)ESMTPTransportProperty.REPORTSUCCESS.getPropertyName(bl), (Object)Boolean.toString(true));
        commonsHashMap.put((Object)ESMTPTransportProperty.SENDPARTIAL.getPropertyName(bl), (Object)Boolean.toString(false));
        commonsHashMap.put((Object)"mail.debug", (Object)Boolean.toString(iSMTPSettings.isDebugSMTP()));
        commonsHashMap.put((Object)"mail.debug.auth", (Object)Boolean.toString(iSMTPSettings.isDebugSMTP()));
        return commonsHashMap;
    }

    public MailTransport(@Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notNull((Object)iSMTPSettings, (String)"Settings");
        this.m_aSMTPSettings = iSMTPSettings;
        this.m_bSMTPS = MailTransport.isUseSMTPS(iSMTPSettings);
        this.m_aMailProperties = MailTransport.createSessionProperties(iSMTPSettings);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mail properties: " + this.m_aMailProperties);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)DEFAULT_MAIL_PROPERTIES);
        properties.putAll((Map<?, ?>)this.m_aMailProperties);
        this.m_aSession = Session.getInstance((Properties)properties);
        INSTANCE_COUNT.incrementAndGet();
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getMailProperties() {
        return (ICommonsMap)this.m_aMailProperties.getClone();
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public ICommonsOrderedMap<IMutableEmailData, MailTransportError> send(@Nullable Collection<IMutableEmailData> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MailTransport mailTransport = (MailTransport)object;
        return this.m_aSMTPSettings.equals(mailTransport.m_aSMTPSettings);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSMTPSettings).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("settings", (Object)this.m_aSMTPSettings).append("properties", this.m_aMailProperties).append("session", (Object)this.m_aSession).getToString();
    }

    private static /* synthetic */ void lambda$send$0(ICommonsOrderedSet iCommonsOrderedSet, MessagingException messagingException, IEmailAddress iEmailAddress) {
        iCommonsOrderedSet.add((Object)new MailSendDetails(false, iEmailAddress.getAddress(), "<generic error>", messagingException.getMessage(), ESMTPErrorCode.FALLBACK));
    }
}

