/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.transport.MailSendDetails;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MailTransportError {
    private final Throwable m_aThrowable;
    private final ICommonsList<MailSendDetails> m_aDetails = new CommonsArrayList();

    public MailTransportError(@Nonnull Throwable throwable) {
        this(throwable, null);
    }

    public MailTransportError(@Nonnull Throwable throwable, @Nullable Iterable<? extends MailSendDetails> iterable) {
        this.m_aThrowable = (Throwable)ValueEnforcer.notNull((Object)throwable, (String)"Throwable");
        this.m_aDetails.addAll(iterable);
    }

    @Nonnull
    public Throwable getThrowable() {
        return this.m_aThrowable;
    }

    @Nonnull
    public ICommonsList<MailSendDetails> getAllDetails() {
        return (ICommonsList)this.m_aDetails.getClone();
    }

    public boolean hasAnyDetails() {
        return this.m_aDetails.isNotEmpty();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Throwable", (Object)this.m_aThrowable).append("Details", this.m_aDetails).getToString();
    }
}

