/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport.listener;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.ICallback;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.commons.string.ToStringGenerator;
import jakarta.mail.event.ConnectionEvent;
import jakarta.mail.event.ConnectionListener;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConnectionListener
implements ConnectionListener,
ICallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConnectionListener.class);
    private final IErrorLevel m_aErrorLevel;

    public LoggingConnectionListener() {
        this((IErrorLevel)EErrorLevel.INFO);
    }

    public LoggingConnectionListener(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = (IErrorLevel)ValueEnforcer.notNull((Object)iErrorLevel, (String)"ErrorLevel");
    }

    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    public void opened(@Nonnull ConnectionEvent connectionEvent) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)this.m_aErrorLevel, (String)"Connected to SMTP server");
    }

    public void disconnected(@Nonnull ConnectionEvent connectionEvent) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)this.m_aErrorLevel, (String)"Disconnected from SMTP server");
    }

    public void closed(@Nonnull ConnectionEvent connectionEvent) {
        LogHelper.log((Logger)LOGGER, (IErrorLevel)this.m_aErrorLevel, (String)"Closed connection to SMTP server");
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ErrorLevel", (Object)this.m_aErrorLevel).getToString();
    }
}

