/*
 * Decompiled with CFR 0.152.
 */
package com.henricook.freeemaildomains;

import com.henricook.freeemaildomains.internal.DomainsData;
import java.util.Locale;
import java.util.Set;

public final class FreeEmailDomains {
    private FreeEmailDomains() {
    }

    public static boolean isFree(String emailOrDomain) {
        if (emailOrDomain == null || emailOrDomain.trim().isEmpty()) {
            throw new IllegalArgumentException("Email or domain cannot be null or empty");
        }
        String domain = FreeEmailDomains.extractDomain(emailOrDomain.trim());
        return DomainsData.DOMAINS.contains(domain.toLowerCase(Locale.ROOT));
    }

    public static Set<String> all() {
        return DomainsData.DOMAINS;
    }

    public static String extractDomain(String emailOrDomain) {
        if (emailOrDomain == null || emailOrDomain.trim().isEmpty()) {
            throw new IllegalArgumentException("Email or domain cannot be null or empty");
        }
        String trimmed = emailOrDomain.trim();
        int atIndex = trimmed.lastIndexOf(64);
        if (atIndex == -1) {
            return trimmed;
        }
        if (atIndex == trimmed.length() - 1) {
            throw new IllegalArgumentException("Invalid email format: " + emailOrDomain);
        }
        return trimmed.substring(atIndex + 1);
    }
}

