/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.server.servlet;

import com.hexagonkt.core.HelpersKt;
import com.hexagonkt.core.logging.Logger;
import com.hexagonkt.core.media.TextMedia;
import com.hexagonkt.http.HttpKt;
import com.hexagonkt.http.model.ContentType;
import com.hexagonkt.http.model.HttpCookie;
import com.hexagonkt.http.model.HttpMethod;
import com.hexagonkt.http.server.HttpServerFeature;
import com.hexagonkt.http.server.HttpServerSettings;
import com.hexagonkt.http.server.handlers.PathHandler;
import com.hexagonkt.http.server.model.HttpServerRequestPort;
import com.hexagonkt.http.server.model.HttpServerResponse;
import com.hexagonkt.http.server.servlet.ServletFilter;
import com.hexagonkt.http.server.servlet.ServletRequestAdapterAsync;
import com.hexagonkt.http.server.servlet.ServletRequestAdapterSync;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/hexagonkt/http/server/servlet/ServletFilter;", "Ljakarta/servlet/http/HttpFilter;", "pathHandler", "Lcom/hexagonkt/http/server/handlers/PathHandler;", "serverSettings", "Lcom/hexagonkt/http/server/HttpServerSettings;", "(Lcom/hexagonkt/http/server/handlers/PathHandler;Lcom/hexagonkt/http/server/HttpServerSettings;)V", "async", "", "handlers", "", "", "logger", "Lcom/hexagonkt/core/logging/Logger;", "destroy", "", "doFilter", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "chain", "Ljakarta/servlet/FilterChain;", "doFilterAsync", "init", "filterConfig", "Ljakarta/servlet/FilterConfig;", "responseToServlet", "Lcom/hexagonkt/http/server/model/HttpServerResponse;", "servletResponse", "http_server_servlet"})
public final class ServletFilter
extends HttpFilter {
    @NotNull
    private final HttpServerSettings serverSettings;
    @NotNull
    private final Logger logger;
    private final boolean async;
    @NotNull
    private final Map<String, PathHandler> handlers;

    /*
     * WARNING - void declaration
     */
    public ServletFilter(@NotNull PathHandler pathHandler, @NotNull HttpServerSettings serverSettings) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Intrinsics.checkNotNullParameter((Object)pathHandler, (String)"pathHandler");
        Intrinsics.checkNotNullParameter((Object)serverSettings, (String)"serverSettings");
        this.serverSettings = serverSettings;
        this.logger = new Logger(Reflection.getOrCreateKotlinClass(ServletFilter.class));
        this.async = this.serverSettings.getFeatures().contains(HttpServerFeature.ASYNC);
        Map map = pathHandler.byMethod();
        ServletFilter servletFilter = this;
        boolean $i$f$mapKeys = false;
        void var5_6 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            String string = ((HttpMethod)it.getKey()).toString();
            Map map3 = map2;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            map3.put(string, entry);
        }
        servletFilter.handlers = destination$iv$iv;
    }

    public void init(@NotNull FilterConfig filterConfig) {
        Intrinsics.checkNotNullParameter((Object)filterConfig, (String)"filterConfig");
        String filterName = filterConfig.getFilterName();
        Enumeration enumeration = filterConfig.getInitParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"filterConfig.initParameterNames");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
        String parameterNames2 = CollectionsKt.joinToString$default((Iterable)arrayList, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(filterConfig){
            final /* synthetic */ FilterConfig $filterConfig;
            {
                this.$filterConfig = $filterConfig;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(String it) {
                return it + " = " + this.$filterConfig.getInitParameter(it);
            }
        }), (int)30, null);
        this.logger.info((Function0)new Function0<Object>(filterName, filterConfig, parameterNames2, this){
            final /* synthetic */ String $filterName;
            final /* synthetic */ FilterConfig $filterConfig;
            final /* synthetic */ String $parameterNames;
            final /* synthetic */ ServletFilter this$0;
            {
                this.$filterName = $filterName;
                this.$filterConfig = $filterConfig;
                this.$parameterNames = $parameterNames;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return StringsKt.trimMargin$default((String)('\'' + this.$filterName + "' Servlet filter initialized.\n              |  * Context path: " + this.$filterConfig.getServletContext().getContextPath() + "\n              |  * Parameters: " + this.$parameterNames + "\n              |  * Server settings: " + ServletFilter.access$getServerSettings$p(this.this$0) + "\n            "), null, (int)1, null);
            }
        });
    }

    public void destroy() {
        this.logger.info((Function0)destroy.1.INSTANCE);
    }

    protected void doFilter(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (this.async) {
            this.doFilterAsync(request, response);
        } else {
            this.doFilter(request, response);
        }
    }

    private final void doFilterAsync(HttpServletRequest request, HttpServletResponse response) {
        AsyncContext asyncContext = request.startAsync();
        ServletInputStream inputStream = request.getInputStream();
        inputStream.setReadListener(new ReadListener(inputStream, this, request, response, asyncContext){
            @NotNull
            private final byte[] buffer;
            @NotNull
            private byte[] bytes;
            final /* synthetic */ ServletInputStream $inputStream;
            final /* synthetic */ ServletFilter this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ HttpServletResponse $response;
            final /* synthetic */ AsyncContext $asyncContext;
            {
                this.$inputStream = $inputStream;
                this.this$0 = $receiver;
                this.$request = $request;
                this.$response = $response;
                this.$asyncContext = $asyncContext;
                this.buffer = new byte[4096];
                this.bytes = new byte[0];
            }

            @NotNull
            public final byte[] getBuffer() {
                return this.buffer;
            }

            @NotNull
            public final byte[] getBytes() {
                return this.bytes;
            }

            public final void setBytes(@NotNull byte[] byArray) {
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
                this.bytes = byArray;
            }

            public void onDataAvailable() {
                int length;
                while ((length = this.$inputStream.read(this.buffer)) >= 0) {
                    int size2 = this.bytes.length;
                    Intrinsics.checkNotNullExpressionValue((Object)Arrays.copyOf(this.bytes, size2 + length), (String)"copyOf(this, newSize)");
                    this.bytes = this.bytes;
                    ArraysKt.copyInto((byte[])this.buffer, (byte[])this.bytes, (int)size2, (int)0, (int)length);
                    if (this.$inputStream.isReady()) continue;
                }
            }

            public void onAllDataRead() {
                HttpServerResponse httpServerResponse;
                PathHandler pathHandler = (PathHandler)ServletFilter.access$getHandlers$p(this.this$0).get(this.$request.getMethod());
                HttpServerResponse handlerResponse = pathHandler != null && (httpServerResponse = pathHandler.process((HttpServerRequestPort)new ServletRequestAdapterAsync(this.$request, this.bytes))) != null ? httpServerResponse : new HttpServerResponse(null, null, null, null, null, 31, null);
                ServletFilter.access$responseToServlet(this.this$0, handlerResponse, this.$response);
                ServletOutputStream servletOutputStream = this.$response.getOutputStream();
                Intrinsics.checkNotNullExpressionValue((Object)servletOutputStream, (String)"response.outputStream");
                ServletOutputStream outputStream = servletOutputStream;
                outputStream.setWriteListener(new WriteListener(handlerResponse, outputStream, this.$asyncContext, this.this$0, this.$response){
                    @NotNull
                    private final ByteBuffer outBuffer;
                    final /* synthetic */ ServletOutputStream $outputStream;
                    final /* synthetic */ AsyncContext $asyncContext;
                    final /* synthetic */ ServletFilter this$0;
                    final /* synthetic */ HttpServletResponse $response;
                    {
                        ByteBuffer byteBuffer;
                        this.$outputStream = $outputStream;
                        this.$asyncContext = $asyncContext;
                        this.this$0 = $receiver;
                        this.$response = $response;
                        doFilterAsync.onAllDataRead.1 var8_6 = this;
                        try {
                            doFilterAsync.onAllDataRead.1 v0 = var8_6;
                            ByteBuffer byteBuffer2 = ByteBuffer.wrap(HttpKt.bodyToBytes((Object)$handlerResponse.getBody()));
                            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"{\n                      \u2026                        }");
                            byteBuffer = byteBuffer2;
                        }
                        catch (Exception exception) {
                            void e;
                            doFilterAsync.onAllDataRead.1 v2 = var8_6;
                            this.onError((Throwable)e);
                            throw e;
                        }
                        v0.outBuffer = byteBuffer;
                    }

                    @NotNull
                    public final ByteBuffer getOutBuffer() {
                        return this.outBuffer;
                    }

                    public void onWritePossible() {
                        while (this.$outputStream.isReady()) {
                            if (!this.outBuffer.hasRemaining()) {
                                this.$asyncContext.complete();
                                return;
                            }
                            int n = 0;
                            byte[] byArray = new byte[1];
                            while (n < 1) {
                                int n2 = n++;
                                byArray[n2] = this.outBuffer.get();
                            }
                            byte[] buffer = byArray;
                            this.$outputStream.write(buffer);
                        }
                    }

                    public void onError(@NotNull Throwable t) {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        Logger.error$default((Logger)ServletFilter.access$getLogger$p(this.this$0), (Throwable)t, null, (int)2, null);
                        this.$response.addHeader("content-type", TextMedia.PLAIN.getFullType());
                        this.$response.setStatus(500);
                        String string = HelpersKt.toText$default((Throwable)t, null, (int)1, null);
                        byte[] byArray = string.getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        this.$outputStream.write(byArray);
                        this.$asyncContext.complete();
                    }
                });
            }

            public void onError(@Nullable Throwable t) {
                Logger.error$default((Logger)ServletFilter.access$getLogger$p(this.this$0), (Throwable)t, null, (int)2, null);
                this.$asyncContext.complete();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doFilter(HttpServletRequest request, HttpServletResponse response) {
        Object object;
        PathHandler pathHandler = this.handlers.get(request.getMethod());
        HttpServerResponse handlerResponse = pathHandler != null && (object = pathHandler.process((HttpServerRequestPort)new ServletRequestAdapterSync(request))) != null ? object : new HttpServerResponse(null, null, null, null, null, 31, null);
        try {
            this.responseToServlet(handlerResponse, response);
            response.getOutputStream().write(HttpKt.bodyToBytes((Object)handlerResponse.getBody()));
        }
        catch (Exception e) {
            response.addHeader("content-type", TextMedia.PLAIN.getFullType());
            response.setStatus(500);
            ServletOutputStream servletOutputStream = response.getOutputStream();
            object = HelpersKt.toText$default((Throwable)e, null, (int)1, null);
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            servletOutputStream.write(byArray);
        }
        finally {
            response.getOutputStream().flush();
        }
    }

    private final void responseToServlet(HttpServerResponse response, HttpServletResponse servletResponse) {
        Map.Entry element$iv;
        Object $this$forEach$iv = response.getHeaders().getAllValues();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            List v = (List)entry.getValue();
            Iterable $this$forEach$iv2 = v;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                servletResponse.addHeader(k, it);
            }
        }
        $this$forEach$iv = response.getCookies();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Cookie cookie;
            element$iv = iterator.next();
            HttpCookie it = (HttpCookie)element$iv;
            boolean bl = false;
            Cookie $this$responseToServlet_u24lambda_u2d4_u24lambda_u2d3 = cookie = new Cookie(it.getName(), it.getValue());
            boolean bl3 = false;
            $this$responseToServlet_u24lambda_u2d4_u24lambda_u2d3.setMaxAge((int)it.getMaxAge());
            $this$responseToServlet_u24lambda_u2d4_u24lambda_u2d3.setSecure(it.getSecure());
            Cookie cookie2 = cookie;
            servletResponse.addCookie(cookie2);
        }
        ContentType contentType2 = response.getContentType();
        if (contentType2 != null) {
            ContentType it = contentType2;
            boolean bl = false;
            servletResponse.addHeader("content-type", it.getText());
        }
        servletResponse.setStatus(response.getStatus().getCode());
    }

    public static final /* synthetic */ HttpServerSettings access$getServerSettings$p(ServletFilter $this) {
        return $this.serverSettings;
    }

    public static final /* synthetic */ Map access$getHandlers$p(ServletFilter $this) {
        return $this.handlers;
    }

    public static final /* synthetic */ void access$responseToServlet(ServletFilter $this, HttpServerResponse response, HttpServletResponse servletResponse) {
        $this.responseToServlet(response, servletResponse);
    }

    public static final /* synthetic */ Logger access$getLogger$p(ServletFilter $this) {
        return $this.logger;
    }
}

