/*
 * Decompiled with CFR 0.152.
 */
package com.hexagonkt.http.server.servlet;

import com.hexagonkt.http.HttpKt;
import com.hexagonkt.http.model.ContentType;
import com.hexagonkt.http.model.Header;
import com.hexagonkt.http.model.HttpCookie;
import com.hexagonkt.http.model.HttpFields;
import com.hexagonkt.http.model.HttpMethod;
import com.hexagonkt.http.model.HttpPartPort;
import com.hexagonkt.http.model.HttpProtocol;
import com.hexagonkt.http.model.QueryParameter;
import com.hexagonkt.http.server.model.HttpServerRequestPort;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 @2\u00020\u0001:\u0001@B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR'\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00068VX\u0096\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u000b\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\tR\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000b\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0017\u001a\u0004\u0018\u00010\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000b\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00068VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u000b\u001a\u0004\b\u001d\u0010\tR!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000b\u001a\u0004\b\"\u0010#R\u001b\u0010%\u001a\u00020&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000b\u001a\u0004\b'\u0010(R\u001b\u0010*\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000b\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u00020&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u000b\u001a\u0004\b0\u0010(R\u001b\u00102\u001a\u0002038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u0010\u000b\u001a\u0004\b4\u00105R\u001b\u00107\u001a\u0002088VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u000b\u001a\u0004\b9\u0010:R!\u0010<\u001a\b\u0012\u0004\u0012\u00020=0 8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u0010\u000b\u001a\u0004\b>\u0010#\u00a8\u0006A"}, d2={"Lcom/hexagonkt/http/server/servlet/ServletRequestAdapter;", "Lcom/hexagonkt/http/server/model/HttpServerRequestPort;", "req", "Ljakarta/servlet/http/HttpServletRequest;", "(Ljakarta/servlet/http/HttpServletRequest;)V", "accept", "", "Lcom/hexagonkt/http/model/ContentType;", "getAccept", "()Ljava/util/List;", "accept$delegate", "Lkotlin/Lazy;", "certificateChain", "Ljava/security/cert/X509Certificate;", "getCertificateChain$annotations", "()V", "getCertificateChain", "certificateChain$delegate", "contentLength", "", "getContentLength", "()J", "contentLength$delegate", "contentType", "getContentType", "()Lcom/hexagonkt/http/model/ContentType;", "contentType$delegate", "cookies", "Lcom/hexagonkt/http/model/HttpCookie;", "getCookies", "cookies$delegate", "headers", "Lcom/hexagonkt/http/model/HttpFields;", "Lcom/hexagonkt/http/model/Header;", "getHeaders", "()Lcom/hexagonkt/http/model/HttpFields;", "headers$delegate", "host", "", "getHost", "()Ljava/lang/String;", "host$delegate", "method", "Lcom/hexagonkt/http/model/HttpMethod;", "getMethod", "()Lcom/hexagonkt/http/model/HttpMethod;", "method$delegate", "path", "getPath", "path$delegate", "port", "", "getPort", "()I", "port$delegate", "protocol", "Lcom/hexagonkt/http/model/HttpProtocol;", "getProtocol", "()Lcom/hexagonkt/http/model/HttpProtocol;", "protocol$delegate", "queryParameters", "Lcom/hexagonkt/http/model/QueryParameter;", "getQueryParameters", "queryParameters$delegate", "Companion", "http_server_servlet"})
public abstract class ServletRequestAdapter
implements HttpServerRequestPort {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy certificateChain$delegate;
    @NotNull
    private final Lazy accept$delegate;
    @NotNull
    private final Lazy contentLength$delegate;
    @NotNull
    private final Lazy queryParameters$delegate;
    @NotNull
    private final Lazy method$delegate;
    @NotNull
    private final Lazy protocol$delegate;
    @NotNull
    private final Lazy host$delegate;
    @NotNull
    private final Lazy port$delegate;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Lazy cookies$delegate;
    @NotNull
    private final Lazy headers$delegate;
    @NotNull
    private final Lazy contentType$delegate;
    @Deprecated
    @NotNull
    public static final String CERTIFICATE_ATTRIBUTE = "jakarta.servlet.request.X509Certificate";

    public ServletRequestAdapter(@NotNull HttpServletRequest req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        this.certificateChain$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends X509Certificate>>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @NotNull
            public final List<X509Certificate> invoke() {
                Object object = this.$req.getAttribute("jakarta.servlet.request.X509Certificate");
                Object[] objectArray = object instanceof X509Certificate[] ? (X509Certificate[])object : null;
                return objectArray != null && (object = ArraysKt.toList((Object[])objectArray)) != null ? object : CollectionsKt.emptyList();
            }
        }));
        this.accept$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends ContentType>>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @NotNull
            public final List<ContentType> invoke() {
                List list;
                Object object = this.$req.getHeaders("accept");
                if (object != null) {
                    ArrayList<T> arrayList = Collections.list(object);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                    object = arrayList;
                    if (object != null) {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = (Iterable)object;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                        while (true) {
                            void it;
                            if (!iterator.hasNext()) {
                                list = (List)destination$iv$iv;
                                return list;
                            }
                            T item$iv$iv = iterator.next();
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            collection.add(HttpKt.parseContentType((String)it));
                        }
                    }
                }
                list = CollectionsKt.emptyList();
                return list;
            }
        }));
        this.contentLength$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.$req.getContentLength();
            }
        }));
        this.queryParameters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpFields<QueryParameter>>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @NotNull
            public final HttpFields<QueryParameter> invoke() {
                String string = this.$req.getQueryString();
                if (string == null) {
                    string = "";
                }
                return HttpKt.parseQueryString((String)string);
            }
        }));
        this.method$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpMethod>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @NotNull
            public final HttpMethod invoke() {
                String string = this.$req.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"req.method");
                return HttpMethod.valueOf((String)string);
            }
        }));
        this.protocol$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpProtocol>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @NotNull
            public final HttpProtocol invoke() {
                String string = this.$req.getScheme();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"req.scheme");
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                return HttpProtocol.valueOf((String)string2);
            }
        }));
        this.host$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            public final String invoke() {
                return this.$req.getRemoteHost();
            }
        }));
        this.port$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.$req.getServerPort();
            }
        }));
        this.path$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            public final String invoke() {
                CharSequence charSequence;
                CharSequence charSequence2 = this.$req.getServletPath();
                HttpServletRequest httpServletRequest = this.$req;
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = httpServletRequest.getPathInfo();
                } else {
                    charSequence = charSequence2;
                }
                return (String)charSequence;
            }
        }));
        this.cookies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends HttpCookie>>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<HttpCookie> invoke() {
                List list;
                Cookie[] cookieArray = this.$req.getCookies();
                if (cookieArray != null) {
                    void $this$mapTo$iv$iv;
                    Cookie[] $this$map$iv = cookieArray;
                    boolean $i$f$map = false;
                    Cookie[] cookieArray2 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n = ((void)$this$mapTo$iv$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void it;
                        void item$iv$iv;
                        void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        String string2 = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.value");
                        collection.add(new HttpCookie(string, string2, (long)it.getMaxAge(), it.getSecure(), null, false, null, false, null, 496, null));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
        }));
        this.headers$delegate = LazyKt.lazy((Function0)((Function0)new Function0<HttpFields<Header>>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HttpFields<Header> invoke() {
                void $this$mapTo$iv$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                Enumeration enumeration = this.$req.getHeaderNames();
                Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"req.headerNames");
                ArrayList<T> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(this)");
                Iterable $this$map$iv = arrayList;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterable<E> destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    String string = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    String string2 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string2);
                }
                $this$map$iv = (List)destination$iv$iv;
                HttpServletRequest httpServletRequest = this.$req;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String bl = (String)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Enumeration enumeration2 = httpServletRequest.getHeaders((String)it);
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration2, (String)"req.getHeaders(it)");
                    ArrayList<T> arrayList2 = Collections.list(enumeration2);
                    Intrinsics.checkNotNullExpressionValue(arrayList2, (String)"list(this)");
                    collection.add(new Header((String)it, (List)arrayList2));
                }
                List list = (List)destination$iv$iv2;
                return new HttpFields(list);
            }
        }));
        this.contentType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ContentType>(req){
            final /* synthetic */ HttpServletRequest $req;
            {
                this.$req = $req;
                super(0);
            }

            @Nullable
            public final ContentType invoke() {
                ContentType contentType2;
                String string = this.$req.getContentType();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    contentType2 = HttpKt.parseContentType((String)it);
                } else {
                    contentType2 = null;
                }
                return contentType2;
            }
        }));
    }

    @NotNull
    public List<X509Certificate> getCertificateChain() {
        Lazy lazy = this.certificateChain$delegate;
        return (List)lazy.getValue();
    }

    public static /* synthetic */ void getCertificateChain$annotations() {
    }

    @NotNull
    public List<ContentType> getAccept() {
        Lazy lazy = this.accept$delegate;
        return (List)lazy.getValue();
    }

    public long getContentLength() {
        Lazy lazy = this.contentLength$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    @NotNull
    public HttpFields<QueryParameter> getQueryParameters() {
        Lazy lazy = this.queryParameters$delegate;
        return (HttpFields)lazy.getValue();
    }

    @NotNull
    public HttpMethod getMethod() {
        Lazy lazy = this.method$delegate;
        return (HttpMethod)lazy.getValue();
    }

    @NotNull
    public HttpProtocol getProtocol() {
        Lazy lazy = this.protocol$delegate;
        return (HttpProtocol)lazy.getValue();
    }

    @NotNull
    public String getHost() {
        Lazy lazy = this.host$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-host>(...)");
        return (String)object;
    }

    public int getPort() {
        Lazy lazy = this.port$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public String getPath() {
        Lazy lazy = this.path$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-path>(...)");
        return (String)object;
    }

    @NotNull
    public List<HttpCookie> getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public HttpFields<Header> getHeaders() {
        Lazy lazy = this.headers$delegate;
        return (HttpFields)lazy.getValue();
    }

    @Nullable
    public ContentType getContentType() {
        Lazy lazy = this.contentType$delegate;
        return (ContentType)lazy.getValue();
    }

    @NotNull
    public String bodyString() {
        return HttpServerRequestPort.DefaultImpls.bodyString((HttpServerRequestPort)this);
    }

    @Nullable
    public X509Certificate certificate() {
        return HttpServerRequestPort.DefaultImpls.certificate((HttpServerRequestPort)this);
    }

    @NotNull
    public Map<String, HttpCookie> cookiesMap() {
        return HttpServerRequestPort.DefaultImpls.cookiesMap((HttpServerRequestPort)this);
    }

    @Nullable
    public String origin() {
        return HttpServerRequestPort.DefaultImpls.origin((HttpServerRequestPort)this);
    }

    @NotNull
    public Map<String, HttpPartPort> partsMap() {
        return HttpServerRequestPort.DefaultImpls.partsMap((HttpServerRequestPort)this);
    }

    @Nullable
    public String referer() {
        return HttpServerRequestPort.DefaultImpls.referer((HttpServerRequestPort)this);
    }

    @NotNull
    public URL url() {
        return HttpServerRequestPort.DefaultImpls.url((HttpServerRequestPort)this);
    }

    @Nullable
    public String userAgent() {
        return HttpServerRequestPort.DefaultImpls.userAgent((HttpServerRequestPort)this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/hexagonkt/http/server/servlet/ServletRequestAdapter$Companion;", "", "()V", "CERTIFICATE_ATTRIBUTE", "", "http_server_servlet"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

